/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.collection;

import io.activej.common.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class CollectionUtils {
    public static <D> List<D> concat(List<? extends D> list1, List<? extends D> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        Object[] objects = new Object[list1.size() + list2.size()];
        System.arraycopy(list1.toArray(), 0, objects, 0, list1.size());
        System.arraycopy(list2.toArray(), 0, objects, list1.size(), list2.size());
        return List.of(objects);
    }

    public static <T> Set<T> difference(Set<? extends T> a, Set<? extends T> b) {
        if (b.isEmpty()) {
            return a;
        }
        return a.stream().filter(Predicate.not(b::contains)).collect(Collectors.toSet());
    }

    public static <T> Set<T> intersection(Set<? extends T> a, Set<? extends T> b) {
        return a.size() < b.size() ? a.stream().filter(b::contains).collect(Collectors.toSet()) : b.stream().filter(a::contains).collect(Collectors.toSet());
    }

    public static <T> boolean hasIntersection(Set<? extends T> a, Set<? extends T> b) {
        return a.size() < b.size() ? a.stream().anyMatch(b::contains) : b.stream().anyMatch(a::contains);
    }

    public static <T> Set<T> union(Set<? extends T> a, Set<? extends T> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        HashSet<T> result = new HashSet<T>(Math.max(a.size(), b.size()));
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    public static <T> T first(List<? extends T> list) {
        return list.get(0);
    }

    public static <T> T first(Iterable<? extends T> iterable) {
        return iterable.iterator().next();
    }

    public static <T> T last(List<? extends T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T last(Iterable<? extends T> iterable) {
        T value;
        Iterator<T> iterator = iterable.iterator();
        do {
            value = iterator.next();
        } while (iterator.hasNext());
        return value;
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialSize) {
        return new HashMap(Utils.initialCapacity(initialSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int initialSize) {
        return new LinkedHashMap(Utils.initialCapacity(initialSize));
    }

    public static <T> HashSet<T> newHashSet(int initialSize) {
        return new HashSet(Utils.initialCapacity(initialSize));
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(int initialSize) {
        return new LinkedHashSet(Utils.initialCapacity(initialSize));
    }
}

