/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.collection;

import io.activej.common.Utils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectorUtils {
    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<? extends K, ? extends V>, ?, M> entriesToMap(Supplier<M> mapFactory) {
        return CollectorUtils.toMap(Map.Entry::getKey, Map.Entry::getValue, mapFactory);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, LinkedHashMap<K, V>> entriesToLinkedHashMap() {
        return CollectorUtils.toMap(Map.Entry::getKey, Map.Entry::getValue, LinkedHashMap::new);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, HashMap<K, V>> entriesToHashMap() {
        return CollectorUtils.toMap(Map.Entry::getKey, Map.Entry::getValue, HashMap::new);
    }

    public static <K, V, K1, V1, M extends Map<K1, V1>> Collector<Map.Entry<? extends K, ? extends V>, ?, M> entriesToMap(Function<? super K, ? extends K1> keyMapper, Function<? super V, ? extends V1> valueMapper, Supplier<M> mapFactory) {
        return CollectorUtils.toMap(entry -> keyMapper.apply((Object)entry.getKey()), entry -> valueMapper.apply((Object)entry.getValue()), mapFactory);
    }

    public static <K, V, K1, V1> Collector<Map.Entry<? extends K, ? extends V>, ?, LinkedHashMap<K1, V1>> entriesToLinkedHashMap(Function<? super K, ? extends K1> keyMapper, Function<? super V, ? extends V1> valueMapper) {
        return CollectorUtils.entriesToMap(keyMapper, valueMapper, LinkedHashMap::new);
    }

    public static <K, V, K1, V1> Collector<Map.Entry<? extends K, ? extends V>, ?, HashMap<K1, V1>> entriesToHashMap(Function<? super K, ? extends K1> keyMapper, Function<? super V, ? extends V1> valueMapper) {
        return CollectorUtils.entriesToMap(keyMapper, valueMapper, HashMap::new);
    }

    public static <K, V, V1, M extends Map<K, V1>> Collector<Map.Entry<? extends K, ? extends V>, ?, M> entriesToMap(Function<? super V, ? extends V1> valueMapper, Supplier<M> mapFactory) {
        return CollectorUtils.toMap(Map.Entry::getKey, entry -> valueMapper.apply((Object)entry.getValue()), mapFactory);
    }

    public static <K, V, V1> Collector<Map.Entry<? extends K, ? extends V>, ?, LinkedHashMap<K, V1>> entriesToLinkedHashMap(Function<? super V, ? extends V1> valueMapper) {
        return CollectorUtils.entriesToMap(valueMapper, LinkedHashMap::new);
    }

    public static <K, V, V1> Collector<Map.Entry<? extends K, ? extends V>, ?, HashMap<K, V1>> entriesToHashMap(Function<? super V, ? extends V1> valueMapper) {
        return CollectorUtils.entriesToMap(valueMapper, HashMap::new);
    }

    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Supplier<M> mapFactory) {
        return Collectors.toMap(keyMapper, valueMapper, Utils.noMergeFunction(), mapFactory);
    }

    public static <T, K, V> Collector<T, ?, LinkedHashMap<K, V>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return CollectorUtils.toMap(keyMapper, valueMapper, LinkedHashMap::new);
    }

    public static <T, K, V> Collector<T, ?, HashMap<K, V>> toHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return CollectorUtils.toMap(keyMapper, valueMapper, HashMap::new);
    }

    public static <K, V, M extends Map<K, V>> Collector<K, ?, M> toMap(Function<? super K, ? extends V> valueMapper, Supplier<M> mapFactory) {
        return CollectorUtils.toMap(Function.identity(), valueMapper, mapFactory);
    }

    public static <K, V> Collector<K, ?, LinkedHashMap<K, V>> toLinkedHashMap(Function<? super K, ? extends V> valueMapper) {
        return CollectorUtils.toLinkedHashMap(Function.identity(), valueMapper);
    }

    public static <K, V> Collector<K, ?, HashMap<K, V>> toHashMap(Function<? super K, ? extends V> valueMapper) {
        return CollectorUtils.toHashMap(Function.identity(), valueMapper);
    }
}

