/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class IteratorUtils {
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <T> Iterator<T> iteratorOf() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> iteratorOf(final T item) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return item;
            }
        };
    }

    public static <T> Iterator<T> iteratorOf(final T item1, final T item2) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.i++ == 0 ? item1 : item2;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iteratorOf(final T ... items) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < items.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return items[this.i++];
            }
        };
    }

    public static <T, R> Iterator<R> transformIterator(final Iterator<? extends T> iterator, final Function<? super T, ? extends R> fn) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return fn.apply(iterator.next());
            }
        };
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2) {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(iterator1, iterator2));
    }

    public static <T> Iterator<T> append(final Iterator<? extends T> iterator, final T value) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return value;
            }
        };
    }

    public static <T> Iterator<T> prepend(final T value, final Iterator<? extends T> iterator) {
        return new Iterator<T>(){
            @Nullable
            Iterator<? extends T> it;

            @Override
            public boolean hasNext() {
                return this.it == null || this.it.hasNext();
            }

            @Override
            public T next() {
                if (this.it != null) {
                    return this.it.next();
                }
                this.it = iterator;
                return value;
            }
        };
    }

    public static <T> Iterator<T> concat(final Iterator<? extends Iterator<? extends T>> iterators) {
        return new Iterator<T>(){
            @Nullable
            Iterator<? extends T> it;
            {
                this.it = 8.findNextIterator(iterators);
            }

            @Override
            public boolean hasNext() {
                return this.it != null;
            }

            @Override
            public T next() {
                if (this.it == null) {
                    throw new NoSuchElementException();
                }
                Object next = this.it.next();
                if (!this.it.hasNext()) {
                    this.it = 8.findNextIterator(iterators);
                }
                return next;
            }

            @Nullable
            private static <T> Iterator<? extends T> findNextIterator(Iterator<? extends Iterator<? extends T>> iterators2) {
                while (iterators2.hasNext()) {
                    Iterator<T> it = iterators2.next();
                    if (!it.hasNext()) continue;
                    return it;
                }
                return null;
            }
        };
    }
}

