/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.collection;

import io.activej.common.Checks;
import io.activej.common.collection.Either;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;
import io.activej.common.recycle.Recyclers;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class Try<T> {
    private final T result;
    @Nullable
    private final Exception exception;

    private Try(@Nullable T result, @Nullable Exception e) {
        this.result = result;
        this.exception = e;
    }

    public static <T> Try<T> of(@Nullable T result) {
        return new Try<T>(result, null);
    }

    public static <T> Try<T> of(@Nullable T result, @Nullable Exception e) {
        Checks.checkArgument(result == null || e == null, "Either result or exception should be null");
        return new Try<T>(result, e);
    }

    public static <T> Try<T> ofException(Exception e) {
        return new Try<Object>(null, e);
    }

    public static <T> Try<T> wrap(SupplierEx<T> computation) {
        try {
            return new Try<T>(computation.get(), null);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError(ex, computation);
            return new Try<Object>(null, ex);
        }
    }

    public static <T> Try<T> wrap(RunnableEx computation) {
        try {
            computation.run();
            return new Try<Object>(null, null);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError(ex, computation);
            return new Try<Object>(null, ex);
        }
    }

    public static <T> Try<T> wrap(Callable<? extends T> computation) {
        try {
            @Nullable T result = computation.call();
            return new Try<T>(result, null);
        }
        catch (Exception e) {
            FatalErrorHandler.handleError(e, computation);
            return new Try<Object>(null, e);
        }
    }

    @Contract(pure=true)
    public boolean isSuccess() {
        return this.exception == null;
    }

    @Contract(pure=true)
    public boolean isException() {
        return this.exception != null;
    }

    @Contract(pure=true)
    public T get() {
        return this.result;
    }

    @Contract(pure=true)
    public T getElse(@Nullable T defaultValue) {
        return this.exception == null ? this.result : defaultValue;
    }

    @Contract(pure=true)
    public T getElseGet(Supplier<? extends T> defaultValueSupplier) {
        return this.exception == null ? this.result : defaultValueSupplier.get();
    }

    @Contract(pure=true)
    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public Try<T> ifSuccess(Consumer<? super T> resultConsumer) {
        if (this.isSuccess()) {
            resultConsumer.accept(this.result);
        }
        return this;
    }

    public Try<T> ifException(Consumer<Exception> exceptionConsumer) {
        if (this.isException()) {
            exceptionConsumer.accept(this.exception);
        }
        return this;
    }

    public Try<T> consume(BiConsumer<? super T, Exception> consumer) {
        consumer.accept(this.result, this.exception);
        return this;
    }

    public Try<T> consume(Consumer<? super T> resultConsumer, Consumer<Exception> exceptionConsumer) {
        if (this.isSuccess()) {
            resultConsumer.accept(this.result);
        } else {
            exceptionConsumer.accept(this.exception);
        }
        return this;
    }

    @Contract(pure=true)
    private <U> Try<U> mold() {
        Checks.checkState(this.isException());
        return this;
    }

    @Contract(pure=true)
    public <U> U reduce(Function<? super T, ? extends U> function, Function<Exception, ? extends U> exceptionFunction) {
        return this.exception == null ? function.apply(this.result) : exceptionFunction.apply(this.exception);
    }

    @Contract(pure=true)
    public <U> U reduce(BiFunction<? super T, Exception, ? extends U> fn) {
        return fn.apply(this.result, this.exception);
    }

    @Contract(pure=true)
    public <U> Try<U> map(FunctionEx<T, U> function) {
        if (this.exception == null) {
            try {
                return new Try<U>(function.apply(this.result), null);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError(ex, function);
                return new Try<Object>(null, ex);
            }
        }
        return this.mold();
    }

    @Contract(pure=true)
    public <U> Try<U> flatMap(Function<T, Try<U>> function) {
        return this.exception == null ? function.apply(this.result) : this.mold();
    }

    @Contract(pure=true)
    public Either<T, Exception> toEither() {
        return this.exception == null ? Either.left(this.result) : Either.right(this.exception);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Try other = (Try)o;
        if (!Objects.equals(this.result, other.result)) {
            return false;
        }
        return Objects.equals(this.exception, other.exception);
    }

    public int hashCode() {
        int hash = this.result != null ? this.result.hashCode() : 0;
        hash = 31 * hash + (this.exception != null ? this.exception.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "{" + (this.isSuccess() ? "" + this.result : "" + this.exception) + "}";
    }

    static {
        Recyclers.register(Try.class, aTry -> Recyclers.recycle(aTry.result));
    }
}

