/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.concurrent;

import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class ObjectPool<T> {
    private static final int PARK_NANOS = ApplicationSettings.getInt(ObjectPool.class, "parkNanos", 1);
    private static final int INITIAL_CAPACITY = ApplicationSettings.getInt(ObjectPool.class, "initialCapacity", 1);
    private volatile Ring<T> ring;
    @Nullable
    private final Supplier<T> supplier;

    public ObjectPool() {
        this(INITIAL_CAPACITY, null);
    }

    public ObjectPool(int initialCapacity) {
        this(initialCapacity, null);
    }

    public ObjectPool(@Nullable Supplier<T> supplier) {
        this(INITIAL_CAPACITY, supplier);
    }

    public ObjectPool(int initialCapacity, @Nullable Supplier<T> supplier) {
        Checks.checkArgument(initialCapacity == 1 << 32 - Integer.numberOfLeadingZeros(initialCapacity - 1), "initialCapacity must be a power of 2");
        this.ring = new Ring(initialCapacity);
        this.supplier = supplier;
    }

    public T poll() {
        Ring<T> ring = this.ring;
        return ring.poll();
    }

    public T ensure() {
        if (this.supplier == null) {
            throw new UnsupportedOperationException();
        }
        T item = this.poll();
        return item != null ? item : this.supplier.get();
    }

    public T ensure(Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        T item = this.poll();
        return item != null ? item : supplier.get();
    }

    public void offer(T item) {
        Ring<T> ring = this.ring;
        if (ring.offer(item)) {
            return;
        }
        this.grow(item, ring);
    }

    private synchronized void grow(T item, Ring<T> ring) {
        if (ring == this.ring) {
            this.ring = new Ring(ring.length * 2);
        }
        this.ring.offer(item);
        while ((item = ring.poll()) != null) {
            this.ring.offer(item);
        }
    }

    public synchronized void clear() {
        this.ring = new Ring(this.ring.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        long pos = this.ring.pos.get();
        int head = (int)(pos >>> 32);
        int tail = (int)pos;
        return head - tail;
    }

    public int capacity() {
        return this.ring.length;
    }

    public String toString() {
        return "ObjectPool{size=" + this.size() + "}";
    }

    private static final class Ring<T> {
        private final AtomicLong pos = new AtomicLong(0L);
        private final AtomicReferenceArray<T> items;
        private final int length;
        private final int mask;

        Ring(int items) {
            this.items = new AtomicReferenceArray(items);
            this.length = this.items.length();
            this.mask = this.length - 1;
        }

        public T poll() {
            T item;
            int tail;
            while (true) {
                long pos1;
                int head;
                if ((head = (int)((pos1 = this.pos.get()) >>> 32)) == (tail = (int)pos1)) {
                    return null;
                }
                long pos2 = ((long)head << 32) + ((long)(tail + 1) & 0xFFFFFFFFL);
                if (this.pos.compareAndSet(pos1, pos2)) break;
                LockSupport.parkNanos(PARK_NANOS);
            }
            while ((item = this.items.getAndSet(tail & this.mask, null)) == null) {
            }
            return item;
        }

        public boolean offer(T item) {
            int head;
            while (true) {
                int tail;
                long pos1;
                if ((head = (int)((pos1 = this.pos.get()) >>> 32)) == (tail = (int)pos1) + this.length) {
                    return false;
                }
                long pos2 = pos1 + 0x100000000L;
                if (this.pos.compareAndSet(pos1, pos2)) break;
                LockSupport.parkNanos(PARK_NANOS);
            }
            while ((item = this.items.getAndSet(head & this.mask, item)) != null) {
            }
            return true;
        }
    }
}

