/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.exception;

import io.activej.common.exception.FatalErrorHandlers;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface FatalErrorHandler {
    public void handle(Throwable var1, @Nullable Object var2);

    default public void handle(Throwable e) {
        this.handle(e, null);
    }

    default public FatalErrorHandler andThen(FatalErrorHandler nextHandler) {
        return (e, context) -> {
            this.handle(e, context);
            nextHandler.handle(e, context);
        };
    }

    public static void setThreadFatalErrorHandler(@Nullable FatalErrorHandler handler) {
        if (handler == null) {
            FatalErrorHandlers.CURRENT_HANDLER.remove();
        } else {
            FatalErrorHandlers.CURRENT_HANDLER.set(handler);
        }
    }

    public static void setGlobalFatalErrorHandler(FatalErrorHandler handler) {
        FatalErrorHandlers.globalFatalErrorHandler = handler;
    }

    public static FatalErrorHandler getCurrent() {
        FatalErrorHandler handler = FatalErrorHandlers.CURRENT_HANDLER.get();
        return handler != null ? handler : FatalErrorHandlers.globalFatalErrorHandler;
    }

    public static void handleError(FatalErrorHandler fatalErrorHandler, Throwable e, @Nullable Object context) {
        if (e instanceof RuntimeException || !(e instanceof Exception)) {
            fatalErrorHandler.handle(e, context);
        }
    }

    public static void handleError(Throwable e, @Nullable Object context) {
        if (e instanceof RuntimeException || !(e instanceof Exception)) {
            FatalErrorHandler.getCurrent().handle(e, context);
        }
    }

    public static void handleError(Throwable e) {
        FatalErrorHandler.handleError(e, null);
    }

    public static Exception getExceptionOrThrowError(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new Error(t);
    }
}

