/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.exception;

import io.activej.common.exception.FatalErrorHandler;
import java.io.PrintStream;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatalErrorHandlers {
    static volatile FatalErrorHandler globalFatalErrorHandler = FatalErrorHandlers.rethrow();
    static final ThreadLocal<FatalErrorHandler> CURRENT_HANDLER = new ThreadLocal();

    public static FatalErrorHandler ignore() {
        return (e, context) -> {};
    }

    public static FatalErrorHandler halt() {
        return FatalErrorHandlers.haltOn(t -> true);
    }

    public static FatalErrorHandler haltOnError() {
        return FatalErrorHandlers.haltOn(e -> e instanceof Error);
    }

    public static FatalErrorHandler haltOnVirtualMachineError() {
        return FatalErrorHandlers.haltOn(e -> e instanceof VirtualMachineError);
    }

    public static FatalErrorHandler haltOnOutOfMemoryError() {
        return FatalErrorHandlers.haltOn(e -> e instanceof OutOfMemoryError);
    }

    public static FatalErrorHandler haltOn(Predicate<Throwable> predicate) {
        return (e, context) -> {
            if (predicate.test(e)) {
                Runtime.getRuntime().halt(1);
            }
        };
    }

    public static FatalErrorHandler rethrow() {
        return FatalErrorHandlers.rethrowOn(t -> true);
    }

    public static FatalErrorHandler rethrowOn(Predicate<Throwable> predicate) {
        return (e, context) -> {
            if (predicate.test(e)) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new Error(e);
            }
        };
    }

    public static FatalErrorHandler logging() {
        return FatalErrorHandlers.loggingTo(LoggerFactory.getLogger(FatalErrorHandler.class));
    }

    public static FatalErrorHandler loggingTo(Logger logger) {
        return (e, context) -> {
            if (!logger.isErrorEnabled()) {
                return;
            }
            if (context == null) {
                logger.error("Fatal error", e);
            } else {
                logger.error("Fatal error in {}", context, (Object)e);
            }
        };
    }

    public static FatalErrorHandler loggingToSystemOut() {
        return FatalErrorHandlers.loggingTo(System.out);
    }

    public static FatalErrorHandler loggingToSystemErr() {
        return FatalErrorHandlers.loggingTo(System.err);
    }

    public static FatalErrorHandler loggingTo(PrintStream stream) {
        return (e, context) -> {
            if (context == null) {
                stream.println("Fatal error");
            } else {
                stream.println("Fatal error in " + context);
            }
            e.printStackTrace(stream);
        };
    }
}

