/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.UncheckedException;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface BiConsumerEx<T, U> {
    public void accept(T var1, U var2) throws Exception;

    public static <T, U> BiConsumerEx<T, U> of(BiConsumer<T, U> uncheckedFn) {
        return (t, u) -> {
            try {
                uncheckedFn.accept(t, u);
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T, U> BiConsumer<T, U> uncheckedOf(BiConsumerEx<T, U> checkedFn) {
        return (t, u) -> {
            try {
                checkedFn.accept(t, u);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

