/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.UncheckedException;
import java.util.function.BiFunction;

@FunctionalInterface
public interface BiFunctionEx<T, U, R> {
    public R apply(T var1, U var2) throws Exception;

    public static <T, U, R> BiFunctionEx<T, U, R> of(BiFunction<T, U, R> uncheckedFn) {
        return (t, u) -> {
            try {
                return uncheckedFn.apply(t, u);
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> uncheckedOf(BiFunctionEx<T, U, R> checkedFn) {
        return (t, u) -> {
            try {
                return checkedFn.apply(t, u);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

