/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.UncheckedException;
import java.util.function.Function;

@FunctionalInterface
public interface FunctionEx<T, R> {
    public R apply(T var1) throws Exception;

    public static <T, R> FunctionEx<T, R> of(Function<T, R> fn) {
        return t -> {
            try {
                return fn.apply(t);
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T, R> Function<T, R> uncheckedOf(FunctionEx<T, R> checkedFn) {
        return t -> {
            try {
                return checkedFn.apply(t);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }

    public static <T> FunctionEx<T, T> identity() {
        return t -> t;
    }
}

