/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.UncheckedException;
import java.util.function.Supplier;

@FunctionalInterface
public interface SupplierEx<T> {
    public T get() throws Exception;

    public static <T> SupplierEx<T> of(Supplier<T> uncheckedFn) {
        return () -> {
            try {
                return uncheckedFn.get();
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> Supplier<T> uncheckedOf(SupplierEx<T> checkedFn) {
        return () -> {
            try {
                return checkedFn.get();
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

