/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.initializer;

import io.activej.common.initializer.Initializer;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public interface WithInitializer<T extends WithInitializer<T>> {
    default public T initialize(Initializer<? super T> initializer) {
        initializer.initialize(this);
        return (T)this;
    }

    default public <V> T set(BiConsumer<T, ? super V> setter, V value) {
        return (T)this.initialize(instance -> setter.accept((Object)instance, (Object)value));
    }

    default public <V> T setIf(BiConsumer<T, ? super V> setter, V value, Predicate<? super V> predicate) {
        return (T)(predicate.test(value) ? this.set(setter, value) : this);
    }

    default public <V> T setIfNotNull(BiConsumer<T, ? super V> setter, V value) {
        return this.setIf(setter, value, Objects::nonNull);
    }
}

