/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.time;

import io.activej.common.Checks;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private boolean isRunning;
    private long start;
    private long nanos;

    private Stopwatch() {
    }

    public static Stopwatch createUnstarted() {
        return new Stopwatch();
    }

    public static Stopwatch createStarted() {
        return new Stopwatch().start();
    }

    public Stopwatch start() {
        Checks.checkState(!this.isRunning, "This stopwatch is already running.");
        this.isRunning = true;
        this.start = System.nanoTime();
        return this;
    }

    public Stopwatch stop() {
        long tick = System.nanoTime();
        Checks.checkState(this.isRunning, "This stopwatch is already stopped.");
        this.isRunning = false;
        this.nanos += tick - this.start;
        return this;
    }

    public Stopwatch reset() {
        this.isRunning = false;
        this.nanos = 0L;
        return this;
    }

    private long time() {
        if (this.isRunning) {
            return System.nanoTime() - this.start + this.nanos;
        }
        return this.nanos;
    }

    private long elapsedNanos() {
        return this.isRunning ? System.nanoTime() - this.start + this.nanos : this.nanos;
    }

    public String toString() {
        long nanos = this.elapsedNanos();
        TimeUnit unit = Stopwatch.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return String.format("%.4g %s", value, Stopwatch.abbreviate(unit));
    }

    public long elapsed(TimeUnit timeUnit) {
        return timeUnit.convert(this.time(), TimeUnit.NANOSECONDS);
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.NANOSECONDS -> "ns";
            case TimeUnit.MICROSECONDS -> "\u03bcs";
            case TimeUnit.MILLISECONDS -> "ms";
            case TimeUnit.SECONDS -> "s";
            case TimeUnit.MINUTES -> "min";
            case TimeUnit.HOURS -> "h";
            case TimeUnit.DAYS -> "d";
        };
    }
}

