/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config.converter;

import io.activej.common.Checks;
import io.activej.config.Config;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigConverter<T> {
    public T get(Config var1, @Nullable T var2);

    @NotNull
    public T get(Config var1);

    default public <V> ConfigConverter<V> transform(final Function<T, V> to, final Function<V, T> from) {
        final ConfigConverter thisConverter = this;
        return new ConfigConverter<V>(){

            @Override
            public V get(Config config, @Nullable V defaultValue) {
                Object value = thisConverter.get(config, defaultValue == null ? null : (Object)from.apply(defaultValue));
                return value != null ? (Object)to.apply(value) : null;
            }

            @Override
            @NotNull
            public V get(Config config) {
                return to.apply(thisConverter.get(config));
            }
        };
    }

    default public ConfigConverter<T> withConstraint(final Predicate<T> predicate) {
        final ConfigConverter thisConverter = this;
        return new ConfigConverter<T>(){

            @Override
            public T get(Config config, T defaultValue) {
                Object value = thisConverter.get(config, defaultValue);
                return Checks.checkArgument(value, (Predicate)predicate, () -> "Constraint violation: " + value);
            }

            @Override
            @NotNull
            public T get(Config config) {
                Object value = thisConverter.get(config);
                return Checks.checkArgument(value, (Predicate)predicate, () -> "Constraint violation: " + value);
            }
        };
    }
}

