/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config;

import io.activej.common.Checks;
import io.activej.config.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public final class FullPathConfig
implements Config {
    private final String path;
    private final Config config;
    private final Map<String, Config> children;

    private FullPathConfig(String path, Config config) {
        this.path = path;
        this.config = config;
        this.children = new LinkedHashMap<String, Config>();
        config.getChildren().forEach((key, value) -> this.children.put((String)key, new FullPathConfig(Config.concatPath(this.path, key), (Config)value)));
    }

    public static FullPathConfig wrap(Config config) {
        return new FullPathConfig("", config);
    }

    @Override
    public String getValue(String defaultValue) {
        return this.config.getValue(defaultValue);
    }

    @Override
    public String getValue() throws NoSuchElementException {
        try {
            return this.config.getValue();
        }
        catch (NoSuchElementException ignored) {
            throw new NoSuchElementException(this.path);
        }
    }

    @Override
    public Map<String, Config> getChildren() {
        return this.children;
    }

    @Override
    public Config provideNoKeyChild(String key) {
        Checks.checkArgument((!this.children.containsKey(key) ? 1 : 0) != 0, (String)"Children already contain key '%s'", (Object[])new Object[]{key});
        return new FullPathConfig(Config.concatPath(this.path, key), this.config.provideNoKeyChild(key));
    }
}

