/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config.converter;

import io.activej.async.service.TaskScheduler;
import io.activej.common.MemSize;
import io.activej.common.StringFormatUtils;
import io.activej.common.Utils;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.config.Config;
import io.activej.config.converter.ComplexConfigConverter;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.SimpleConfigConverter;
import io.activej.eventloop.inspector.ThrottlingController;
import io.activej.promise.RetryPolicy;
import io.activej.reactor.Reactor;
import io.activej.reactor.net.DatagramSocketSettings;
import io.activej.reactor.net.ServerSocketSettings;
import io.activej.reactor.net.SocketSettings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.AbstractQueue;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigConverters {
    private static final ConfigConverter<List<Class<?>>> OF_CLASSES = ConfigConverters.ofList(ConfigConverters.ofClass());

    public static ConfigConverter<LocalDate> ofLocalDate() {
        return SimpleConfigConverter.of(LocalDate::parse, LocalDate::toString);
    }

    public static ConfigConverter<LocalTime> ofLocalTime() {
        return SimpleConfigConverter.of(LocalTime::parse, LocalTime::toString);
    }

    public static ConfigConverter<LocalDateTime> ofLocalDateTime() {
        return SimpleConfigConverter.of(StringFormatUtils::parseLocalDateTime, StringFormatUtils::formatLocalDateTime);
    }

    public static ConfigConverter<Period> ofPeriod() {
        return SimpleConfigConverter.of(StringFormatUtils::parsePeriod, StringFormatUtils::formatPeriod);
    }

    public static ConfigConverter<Integer> ofPeriodAsDays() {
        return ConfigConverters.ofPeriod().transform(Period::getDays, Period::ofDays);
    }

    public static ConfigConverter<Duration> ofDuration() {
        return SimpleConfigConverter.of(StringFormatUtils::parseDuration, StringFormatUtils::formatDuration);
    }

    public static ConfigConverter<Long> ofDurationAsMillis() {
        return ConfigConverters.ofDuration().transform(Duration::toMillis, Duration::ofMillis);
    }

    public static ConfigConverter<Instant> ofInstant() {
        return SimpleConfigConverter.of(StringFormatUtils::parseInstant, StringFormatUtils::formatInstant);
    }

    public static ConfigConverter<Long> ofInstantAsEpochMillis() {
        return ConfigConverters.ofInstant().transform(Instant::toEpochMilli, Instant::ofEpochMilli);
    }

    public static ConfigConverter<String> ofString() {
        return new ConfigConverter<String>(){

            @Override
            public String get(Config config, String defaultValue) {
                return config.getValue(defaultValue);
            }

            @Override
            public String get(Config config) {
                return config.getValue();
            }
        };
    }

    public static ConfigConverter<Byte> ofByte() {
        return SimpleConfigConverter.of(Byte::valueOf, aByte -> Byte.toString(aByte));
    }

    public static ConfigConverter<Integer> ofInteger() {
        return SimpleConfigConverter.of(Integer::valueOf, anInteger -> Integer.toString(anInteger));
    }

    public static ConfigConverter<Long> ofLong() {
        return SimpleConfigConverter.of(Long::valueOf, aLong -> Long.toString(aLong));
    }

    public static ConfigConverter<Float> ofFloat() {
        return SimpleConfigConverter.of(Float::valueOf, aFloat -> Float.toString(aFloat.floatValue()));
    }

    public static ConfigConverter<Double> ofDouble() {
        return SimpleConfigConverter.of(Double::valueOf, aDouble -> Double.toString(aDouble));
    }

    public static ConfigConverter<Boolean> ofBoolean() {
        return SimpleConfigConverter.of(Boolean::valueOf, aBoolean -> Boolean.toString(aBoolean));
    }

    public static <E extends Enum<E>> SimpleConfigConverter<E> ofEnum(Class<E> enumClass) {
        return SimpleConfigConverter.of(string -> Enum.valueOf(enumClass, string), Enum::name);
    }

    public static ConfigConverter<Class<?>> ofClass() {
        return SimpleConfigConverter.of(Class::forName, Class::getName);
    }

    public static ConfigConverter<InetAddress> ofInetAddress() {
        return SimpleConfigConverter.of(InetAddress::getByName, InetAddress::getHostAddress);
    }

    public static ConfigConverter<InetSocketAddress> ofInetSocketAddress() {
        return SimpleConfigConverter.of(StringFormatUtils::parseInetSocketAddressResolving, value -> value.getAddress().getHostAddress() + ":" + value.getPort());
    }

    public static ConfigConverter<Path> ofPath() {
        return SimpleConfigConverter.of(x$0 -> Paths.get(x$0, new String[0]), value -> value.toAbsolutePath().normalize().toString());
    }

    public static ConfigConverter<MemSize> ofMemSize() {
        return SimpleConfigConverter.of(MemSize::valueOf, MemSize::format);
    }

    public static ConfigConverter<Long> ofMemSizeAsLong() {
        return ConfigConverters.ofMemSize().transform(MemSize::toLong, MemSize::of);
    }

    public static ConfigConverter<Integer> ofMemSizeAsInt() {
        return ConfigConverters.ofMemSize().transform(MemSize::toInt, MemSize::of);
    }

    public static <T> ConfigConverter<List<T>> ofList(final ConfigConverter<T> elementConverter, final CharSequence separators) {
        return new SimpleConfigConverter<List<T>>(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(separators.chars().mapToObj(c -> "\\" + (char)c).collect(Collectors.joining("", "[", "]")));
            }

            @Override
            public List<T> fromString(String string) {
                return this.pattern.splitAsStream(string).map(String::trim).filter(Utils.not(String::isEmpty)).map(s -> elementConverter.get(Config.ofValue(s))).collect(Collectors.toList());
            }

            @Override
            public String toString(List<T> value) {
                return value.stream().map(v -> {
                    Config config = Config.ofValue(elementConverter, v);
                    if (config.hasChildren()) {
                        throw new AssertionError((Object)("Unexpected child entries: " + config.toMap()));
                    }
                    return config.getValue();
                }).collect(Collectors.joining(String.valueOf(separators.charAt(0))));
            }
        };
    }

    public static <T> ConfigConverter<List<T>> ofList(ConfigConverter<T> elementConverter) {
        return ConfigConverters.ofList(elementConverter, ",;");
    }

    public static ConfigConverter<ServerSocketSettings> ofServerSocketSettings() {
        return new ComplexConfigConverter<ServerSocketSettings>(ServerSocketSettings.defaultInstance()){

            @Override
            protected ServerSocketSettings provide(Config config, ServerSocketSettings defaultValue) {
                return (ServerSocketSettings)((ServerSocketSettings.Builder)((ServerSocketSettings.Builder)((ServerSocketSettings.Builder)ServerSocketSettings.builder().set(ServerSocketSettings.Builder::withBacklog, (Object)config.get(ConfigConverters.ofInteger(), "backlog", defaultValue.getBacklog()))).setIfNotNull(ServerSocketSettings.Builder::withReceiveBufferSize, (Object)config.get(ConfigConverters.ofMemSize(), "receiveBufferSize", defaultValue.getReceiveBufferSize()))).setIfNotNull(ServerSocketSettings.Builder::withReuseAddress, (Object)config.get(ConfigConverters.ofBoolean(), "reuseAddress", defaultValue.getReuseAddress()))).build();
            }
        };
    }

    public static ConfigConverter<SocketSettings> ofSocketSettings() {
        return new ComplexConfigConverter<SocketSettings>(SocketSettings.defaultInstance()){

            @Override
            protected SocketSettings provide(Config config, SocketSettings defaultValue) {
                return (SocketSettings)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)((SocketSettings.Builder)SocketSettings.builder().setIfNotNull(SocketSettings.Builder::withReceiveBufferSize, (Object)config.get(ConfigConverters.ofMemSize(), "receiveBufferSize", defaultValue.getReceiveBufferSize()))).setIfNotNull(SocketSettings.Builder::withSendBufferSize, (Object)config.get(ConfigConverters.ofMemSize(), "sendBufferSize", defaultValue.getSendBufferSize()))).setIfNotNull(SocketSettings.Builder::withReuseAddress, (Object)config.get(ConfigConverters.ofBoolean(), "reuseAddress", defaultValue.getReuseAddress()))).setIfNotNull(SocketSettings.Builder::withKeepAlive, (Object)config.get(ConfigConverters.ofBoolean(), "keepAlive", defaultValue.getKeepAlive()))).setIfNotNull(SocketSettings.Builder::withTcpNoDelay, (Object)config.get(ConfigConverters.ofBoolean(), "tcpNoDelay", defaultValue.getTcpNoDelay()))).setIfNotNull(SocketSettings.Builder::withLingerTimeout, (Object)config.get(ConfigConverters.ofDuration(), "lingerTimeout", defaultValue.getLingerTimeout()))).setIfNotNull(SocketSettings.Builder::withImplReadTimeout, (Object)config.get(ConfigConverters.ofDuration(), "implReadTimeout", defaultValue.getImplReadTimeout()))).setIfNotNull(SocketSettings.Builder::withImplWriteTimeout, (Object)config.get(ConfigConverters.ofDuration(), "implWriteTimeout", defaultValue.getImplWriteTimeout()))).setIfNotNull(SocketSettings.Builder::withImplReadBufferSize, (Object)config.get(ConfigConverters.ofMemSize(), "implReadBufferSize", defaultValue.getImplReadBufferSize()))).build();
            }
        };
    }

    public static ConfigConverter<DatagramSocketSettings> ofDatagramSocketSettings() {
        return new ComplexConfigConverter<DatagramSocketSettings>(DatagramSocketSettings.create()){

            @Override
            protected DatagramSocketSettings provide(Config config, DatagramSocketSettings defaultValue) {
                return (DatagramSocketSettings)((DatagramSocketSettings.Builder)((DatagramSocketSettings.Builder)((DatagramSocketSettings.Builder)((DatagramSocketSettings.Builder)DatagramSocketSettings.builder().setIfNotNull(DatagramSocketSettings.Builder::withReceiveBufferSize, (Object)config.get(ConfigConverters.ofMemSize(), "receiveBufferSize", defaultValue.getReceiveBufferSize()))).setIfNotNull(DatagramSocketSettings.Builder::withSendBufferSize, (Object)config.get(ConfigConverters.ofMemSize(), "sendBufferSize", defaultValue.getSendBufferSize()))).setIfNotNull(DatagramSocketSettings.Builder::withReuseAddress, (Object)config.get(ConfigConverters.ofBoolean(), "reuseAddress", defaultValue.getReuseAddress()))).setIfNotNull(DatagramSocketSettings.Builder::withBroadcast, (Object)config.get(ConfigConverters.ofBoolean(), "broadcast", defaultValue.getBroadcast()))).build();
            }
        };
    }

    public static ConfigConverter<List<Class<?>>> ofClasses() {
        return OF_CLASSES;
    }

    public static ConfigConverter<FatalErrorHandler> ofFatalErrorHandler() {
        return new ConfigConverter<FatalErrorHandler>(){

            @Override
            public FatalErrorHandler get(Config config) {
                return switch (config.getValue()) {
                    case "rethrow" -> FatalErrorHandlers.rethrow();
                    case "ignore" -> FatalErrorHandlers.ignore();
                    case "halt" -> FatalErrorHandlers.halt();
                    case "haltOnError" -> FatalErrorHandlers.haltOnError();
                    case "haltOnVirtualMachineError" -> FatalErrorHandlers.haltOnVirtualMachineError();
                    case "haltOnOutOfMemoryError" -> FatalErrorHandlers.haltOnOutOfMemoryError();
                    case "rethrowOn" -> FatalErrorHandlers.rethrowOn(ConfigConverters.toThrowablePredicate(config.get(OF_CLASSES, "whitelist", List.of()), config.get(OF_CLASSES, "blacklist", List.of())));
                    case "haltOn" -> FatalErrorHandlers.haltOn(ConfigConverters.toThrowablePredicate(config.get(OF_CLASSES, "whitelist", List.of()), config.get(OF_CLASSES, "blacklist", List.of())));
                    case "logging" -> FatalErrorHandlers.logging();
                    case "loggingToSystemOut" -> FatalErrorHandlers.loggingToSystemOut();
                    case "loggingToSystemErr" -> FatalErrorHandlers.loggingToSystemErr();
                    case "loggingToEventloop" -> {
                        FatalErrorHandler logging = FatalErrorHandlers.logging();
                        yield (e, context) -> {
                            Reactor reactor = Reactor.getCurrentReactorOrNull();
                            if (reactor != null) {
                                reactor.logFatalError(e, context);
                            } else {
                                logging.handle(e, context);
                            }
                        };
                    }
                    default -> throw new IllegalArgumentException("No fatal error handler named " + config.getValue() + " exists!");
                };
            }

            @Override
            public FatalErrorHandler get(Config config, FatalErrorHandler defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    private static Predicate<Throwable> toThrowablePredicate(List<Class<?>> whiteList, List<Class<?>> blackList) {
        return e -> ConfigConverters.matchesAny(e.getClass(), whiteList) && !ConfigConverters.matchesAny(e.getClass(), blackList);
    }

    private static boolean matchesAny(Class<?> c, List<Class<?>> list) {
        return list.stream().anyMatch(cl -> cl.isAssignableFrom(c));
    }

    public static ConfigConverter<TaskScheduler.Schedule> ofReactorTaskSchedule() {
        return new ConfigConverter<TaskScheduler.Schedule>(){

            @Override
            public TaskScheduler.Schedule get(Config config) {
                return switch (config.get("type")) {
                    case "immediate" -> TaskScheduler.Schedule.immediate();
                    case "delay" -> TaskScheduler.Schedule.ofDelay((Duration)config.get(ConfigConverters.ofDuration(), "value"));
                    case "interval" -> TaskScheduler.Schedule.ofInterval((Duration)config.get(ConfigConverters.ofDuration(), "value"));
                    case "period" -> TaskScheduler.Schedule.ofPeriod((Duration)config.get(ConfigConverters.ofDuration(), "value"));
                    default -> throw new IllegalArgumentException("No reactor task schedule type named " + config.getValue() + " exists!");
                };
            }

            @Override
            public TaskScheduler.Schedule get(Config config, TaskScheduler.Schedule defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    public static ConfigConverter<RetryPolicy> ofRetryPolicy() {
        return new ConfigConverter<RetryPolicy>(){

            @Override
            public RetryPolicy get(Config config) {
                if (!config.hasValue() || config.getValue().equals("no")) {
                    return RetryPolicy.noRetry();
                }
                RetryPolicy retryPolicy = switch (config.getValue()) {
                    case "immediate" -> RetryPolicy.immediateRetry();
                    case "fixedDelay" -> RetryPolicy.fixedDelay((long)config.get(ConfigConverters.ofDuration(), "delay").toMillis());
                    case "exponentialBackoff" -> RetryPolicy.exponentialBackoff((long)config.get(ConfigConverters.ofDuration(), "initialDelay").toMillis(), (long)config.get(ConfigConverters.ofDuration(), "maxDelay").toMillis(), (double)config.get(ConfigConverters.ofDouble(), "exponent", 2.0));
                    default -> throw new IllegalArgumentException("No retry policy named " + config.getValue() + " exists!");
                };
                int maxRetryCount = config.get(ConfigConverters.ofInteger(), "maxRetryCount", Integer.MAX_VALUE);
                if (maxRetryCount != Integer.MAX_VALUE) {
                    retryPolicy = retryPolicy.withMaxTotalRetryCount(maxRetryCount);
                }
                Duration max = Duration.ofSeconds(Long.MAX_VALUE);
                Duration maxRetryTimeout = config.get(ConfigConverters.ofDuration(), "maxRetryTimeout", max);
                if (!maxRetryTimeout.equals(max)) {
                    retryPolicy = retryPolicy.withMaxTotalRetryTimeout(maxRetryTimeout);
                }
                return retryPolicy;
            }

            @Override
            public RetryPolicy get(Config config, RetryPolicy defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    public static ConfigConverter<ThrottlingController> ofThrottlingController() {
        return new ComplexConfigConverter<ThrottlingController>(ThrottlingController.create()){

            @Override
            protected ThrottlingController provide(Config config, ThrottlingController defaultValue) {
                return (ThrottlingController)ThrottlingController.builder().withTargetTime(config.get(ConfigConverters.ofDuration(), "targetTime", defaultValue.getTargetTime())).withGcTime(config.get(ConfigConverters.ofDuration(), "gcTime", defaultValue.getGcTime())).withSmoothingWindow(config.get(ConfigConverters.ofDuration(), "smoothingWindow", defaultValue.getSmoothingWindow())).withThrottlingDecrease(config.get(ConfigConverters.ofDouble(), "throttlingDecrease", defaultValue.getThrottlingDecrease()).doubleValue()).withInitialKeysPerSecond(config.get(ConfigConverters.ofDouble(), "initialKeysPerSecond", 100.0).doubleValue()).withInitialThrottling(config.get(ConfigConverters.ofDouble(), "initialThrottling", 0.0).doubleValue()).build();
            }
        };
    }

    public static ExecutorService getExecutor(Config config) {
        int corePoolSize = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= 0), "corePoolSize", 0);
        int maxPoolSize = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= corePoolSize), "maxPoolSize", Integer.MAX_VALUE);
        int keepAlive = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= 0), "keepAliveSeconds", 60);
        int queueSize = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= 0), "queueSize", Integer.MAX_VALUE);
        AbstractQueue queue = queueSize == 0 ? new SynchronousQueue() : (queueSize == Integer.MAX_VALUE ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueSize));
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize == 0 ? Integer.MAX_VALUE : maxPoolSize, keepAlive, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue));
    }

    public static ConfigConverter<ExecutorService> ofExecutor() {
        return new ConfigConverter<ExecutorService>(){

            @Override
            public ExecutorService get(Config config) {
                return ConfigConverters.getExecutor(config);
            }

            @Override
            public ExecutorService get(Config config, ExecutorService defaultValue) {
                throw new IllegalArgumentException("Should not use executor config converter with default value");
            }
        };
    }
}

