/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.ByteBufsCodec;
import io.activej.csp.binary.ByteBufsDecoder;

public class Utils {
    public static ByteBufsCodec<ByteBuf, ByteBuf> nullTerminated() {
        return ByteBufsCodec.ofDelimiter(ByteBufsDecoder.ofNullTerminatedBytes(), buf -> {
            ByteBuf buf1 = ByteBufPool.ensureWriteRemaining((ByteBuf)buf, (int)1);
            buf1.put((byte)0);
            return buf1;
        });
    }

    static ByteBufsDecoder<ByteBuf> decodeUntilTerminatorByte(byte terminator, int maxSize) {
        return bufs -> {
            int bytes = bufs.scanBytes((index, nextByte) -> {
                if (nextByte == terminator) {
                    return true;
                }
                if (index == maxSize - 1) {
                    throw new MalformedDataException("No terminator byte is found in " + maxSize + " bytes");
                }
                return false;
            });
            if (bytes == 0) {
                return null;
            }
            ByteBuf buf = bufs.takeExactSize(bytes);
            buf.moveTail(-1);
            return buf;
        };
    }

    static class IntScanner
    implements ByteBufs.ByteScanner {
        int result;

        IntScanner() {
        }

        public boolean consume(int index, byte b) {
            this.result = this.result << 8 | b & 0xFF;
            return index == 3;
        }
    }

    static class VarIntScanner
    implements ByteBufs.ByteScanner {
        int result;

        VarIntScanner() {
        }

        public boolean consume(int index, byte b) throws MalformedDataException {
            this.result = (index == 0 ? 0 : this.result) | (b & 0x7F) << index * 7;
            if ((b & 0x80) == 0) {
                return true;
            }
            if (index == 4) {
                throw new InvalidSizeException("VarInt is too long for a 32-bit integer");
            }
            return false;
        }
    }
}

