/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.process.frames.BlockDecoder;
import io.activej.csp.process.frames.LZ4FrameFormat;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jetbrains.annotations.Nullable;

final class LZ4BlockDecoder
implements BlockDecoder {
    private static final int LAST_BLOCK_INT = -1;
    private final LZ4FastDecompressor decompressor;
    private boolean readHeader = true;
    private final IntScanner intScanner = new IntScanner();

    LZ4BlockDecoder(LZ4FastDecompressor decompressor) {
        this.decompressor = decompressor;
    }

    @Override
    public void reset() {
        this.readHeader = true;
    }

    @Override
    @Nullable
    public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
        if (this.readHeader) {
            if (!this.readHeader(bufs)) {
                return null;
            }
            this.readHeader = false;
        }
        if (bufs.scanBytes((ByteBufs.ByteScanner)this.intScanner) == 0) {
            return null;
        }
        int compressedSize = this.intScanner.value;
        if (compressedSize == -1) {
            bufs.skip(4);
            return END_OF_STREAM;
        }
        if (compressedSize >= 0) {
            if (!bufs.hasRemainingBytes(4 + compressedSize + 1)) {
                return null;
            }
            bufs.skip(4);
            ByteBuf result = bufs.takeExactSize(compressedSize + 1);
            if (result.at(result.tail() - 1) != 1) {
                throw new MalformedDataException("Block does not end with special byte '1'");
            }
            result.moveTail(-1);
            return result;
        }
        return this.decompress(bufs, compressedSize & Integer.MAX_VALUE);
    }

    @Override
    public boolean ignoreMissingEndOfStreamBlock() {
        return false;
    }

    private boolean readHeader(ByteBufs bufs) throws MalformedDataException {
        return bufs.consumeBytes((index, value) -> {
            if (value != LZ4FrameFormat.MAGIC[index]) {
                throw new UnknownFormatException("Expected stream to start with bytes: " + Arrays.toString(LZ4FrameFormat.MAGIC));
            }
            return index == LZ4FrameFormat.MAGIC_LENGTH - 1;
        }) != 0;
    }

    @Nullable
    private ByteBuf decompress(ByteBufs bufs, int compressedSize) throws MalformedDataException {
        ByteBuf compressedBuf;
        if (!bufs.hasRemainingBytes(8 + compressedSize + 1)) {
            return null;
        }
        bufs.consumeBytes(4, (ByteBufs.ByteScanner)this.intScanner);
        int originalSize = this.intScanner.value;
        if (originalSize < 0 || originalSize > LZ4FrameFormat.MAX_BLOCK_SIZE.toInt()) {
            throw new InvalidSizeException("Size (" + originalSize + ") of block is either negative or exceeds max block size (" + LZ4FrameFormat.MAX_BLOCK_SIZE + ')');
        }
        ByteBuf firstBuf = bufs.peekBuf();
        assert (firstBuf != null);
        ByteBuf byteBuf = compressedBuf = firstBuf.readRemaining() >= compressedSize + 1 ? firstBuf : bufs.takeExactSize(compressedSize + 1);
        if (compressedBuf.at(compressedBuf.head() + compressedSize) != 1) {
            throw new MalformedDataException("Block does not end with special byte '1'");
        }
        ByteBuf buf = ByteBufPool.allocate((int)originalSize);
        try {
            int readBytes = this.decompressor.decompress(compressedBuf.array(), compressedBuf.head(), buf.array(), 0, originalSize);
            if (readBytes != compressedSize) {
                buf.recycle();
                throw new InvalidSizeException("Actual size of decompressed data does not equal expected size of decompressed data");
            }
            buf.tail(originalSize);
        }
        catch (LZ4Exception e) {
            buf.recycle();
            throw new MalformedDataException("Failed to decompress data", (Throwable)e);
        }
        if (compressedBuf != firstBuf) {
            compressedBuf.recycle();
        } else {
            bufs.skip(compressedSize + 1);
        }
        return buf;
    }

    private static final class IntScanner
    implements ByteBufs.ByteScanner {
        int value;

        private IntScanner() {
        }

        public boolean consume(int index, byte b) {
            this.value = this.value << 8 | b & 0xFF;
            return index == 3;
        }
    }
}

