/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.initializer.WithInitializer;
import io.activej.csp.process.frames.BlockDecoder;
import io.activej.csp.process.frames.BlockEncoder;
import io.activej.csp.process.frames.FrameFormat;
import io.activej.csp.process.frames.LZ4BlockDecoder;
import io.activej.csp.process.frames.LZ4BlockEncoder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public final class LZ4FrameFormat
implements FrameFormat,
WithInitializer<LZ4FrameFormat> {
    public static final MemSize MAX_BLOCK_SIZE = ApplicationSettings.getMemSize(LZ4FrameFormat.class, (String)"maxBlockSize", (MemSize)MemSize.megabytes((long)256L));
    static final byte[] MAGIC = new byte[]{76, 90, 52, 1};
    static final byte[] LAST_BLOCK_BYTES = new byte[]{-1, -1, -1, -1};
    static final byte[] MAGIC_AND_LAST_BLOCK_BYTES;
    static final int MAGIC_LENGTH;
    static final int COMPRESSED_LENGTH_MASK = Integer.MAX_VALUE;
    static final byte END_OF_BLOCK = 1;
    private final LZ4Factory factory;
    private int compressionLevel;

    private LZ4FrameFormat(LZ4Factory factory) {
        this.factory = factory;
    }

    public static LZ4FrameFormat create() {
        return new LZ4FrameFormat(LZ4Factory.fastestInstance());
    }

    public static LZ4FrameFormat create(LZ4Factory factory) {
        return new LZ4FrameFormat(factory);
    }

    public LZ4FrameFormat withHighCompression() {
        this.compressionLevel = -1;
        return this;
    }

    public LZ4FrameFormat withCompressionLevel(int compressionLevel) {
        Checks.checkArgument((compressionLevel >= -1 ? 1 : 0) != 0);
        this.compressionLevel = compressionLevel;
        return this;
    }

    @Override
    public BlockEncoder createEncoder() {
        LZ4Compressor compressor = this.compressionLevel == 0 ? this.factory.fastCompressor() : (this.compressionLevel == -1 ? this.factory.highCompressor() : this.factory.highCompressor(this.compressionLevel));
        return new LZ4BlockEncoder(compressor);
    }

    @Override
    public BlockDecoder createDecoder() {
        return new LZ4BlockDecoder(this.factory.fastDecompressor());
    }

    static {
        MAGIC_LENGTH = MAGIC.length;
        MAGIC_AND_LAST_BLOCK_BYTES = new byte[MAGIC.length + LAST_BLOCK_BYTES.length];
        System.arraycopy(MAGIC, 0, MAGIC_AND_LAST_BLOCK_BYTES, 0, MAGIC.length);
        System.arraycopy(LAST_BLOCK_BYTES, 0, MAGIC_AND_LAST_BLOCK_BYTES, MAGIC.length, LAST_BLOCK_BYTES.length);
    }
}

