/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.callback.Callback;
import io.activej.async.process.AsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.ApplicationSettings;
import io.activej.common.MemSize;
import io.activej.common.recycle.Recyclable;
import io.activej.csp.ChannelInput;
import io.activej.csp.ChannelOutput;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.consumer.ChannelConsumers;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.csp.supplier.ChannelSuppliers;
import io.activej.http.ConnectionsLinkedList;
import io.activej.http.GzipProcessorUtils;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpUtils;
import io.activej.http.IWebSocket;
import io.activej.http.MalformedHttpException;
import io.activej.http.WebSocketException;
import io.activej.http.stream.BufsConsumerChunkedDecoder;
import io.activej.http.stream.BufsConsumerChunkedEncoder;
import io.activej.http.stream.BufsConsumerDelimiter;
import io.activej.http.stream.BufsConsumerGzipDeflater;
import io.activej.http.stream.BufsConsumerGzipInflater;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactor;
import java.time.Duration;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHttpConnection
extends AbstractReactive {
    public static final MemSize MAX_HEADER_LINE_SIZE = MemSize.of((long)ApplicationSettings.getInt(HttpMessage.class, (String)"maxHeaderLineSize", (Integer)MemSize.kilobytes((long)8L).toInt()).intValue());
    public static final int MAX_HEADER_LINE_SIZE_BYTES = MAX_HEADER_LINE_SIZE.toInt();
    public static final int MAX_HEADERS = ApplicationSettings.getInt(HttpMessage.class, (String)"maxHeaders", (Integer)100);
    protected static final HttpHeaderValue CONNECTION_KEEP_ALIVE_HEADER = HttpHeaderValue.ofBytes(ByteBufStrings.encodeAscii((String)"keep-alive"));
    protected static final HttpHeaderValue CONNECTION_CLOSE_HEADER = HttpHeaderValue.ofBytes(ByteBufStrings.encodeAscii((String)"close"));
    protected static final long UNSET_CONTENT_LENGTH = -1L;
    protected static final byte[] CONNECTION_KEEP_ALIVE = ByteBufStrings.encodeAscii((String)"keep-alive");
    protected static final byte[] TRANSFER_ENCODING_CHUNKED = ByteBufStrings.encodeAscii((String)"chunked");
    protected static final byte[] CONTENT_ENCODING_GZIP = ByteBufStrings.encodeAscii((String)"gzip");
    protected static final byte[] UPGRADE_WEBSOCKET = ByteBufStrings.encodeAscii((String)"websocket");
    protected static final byte[] WEB_SOCKET_VERSION = ByteBufStrings.encodeAscii((String)"13");
    protected final ITcpSocket socket;
    protected final int maxBodySize;
    protected static final byte KEEP_ALIVE = 1;
    protected static final byte GZIPPED = 2;
    protected static final byte CHUNKED = 4;
    protected static final byte WEB_SOCKET = 8;
    protected static final byte BODY_RECEIVED = 16;
    protected static final byte BODY_SENT = 32;
    protected static final byte READING_MESSAGES = 64;
    protected static final byte CLOSED = -128;
    protected byte flags = 0;
    protected ByteBuf readBuf;
    @Nullable
    protected ConnectionsLinkedList pool;
    @Nullable
    protected AbstractHttpConnection prev;
    @Nullable
    protected AbstractHttpConnection next;
    protected long poolTimestamp;
    protected int numberOfRequests;
    protected long contentLength;
    @Nullable
    protected Exception closeException;
    @Nullable
    private Object userData;
    protected Recyclable stashedBufs;
    protected final ReadConsumer readMessageConsumer = new ReadConsumer(){

        @Override
        protected void thenRun() throws MalformedHttpException {
            AbstractHttpConnection.this.readMessage();
        }
    };
    protected final ReadConsumer readHeadersConsumer = new ReadConsumer(){

        @Override
        protected void thenRun() throws MalformedHttpException {
            AbstractHttpConnection.this.readHeaders(AbstractHttpConnection.this.readBuf.head());
        }
    };

    protected AbstractHttpConnection(Reactor reactor, ITcpSocket socket, int maxBodySize) {
        super(reactor);
        this.socket = socket;
        this.maxBodySize = maxBodySize;
    }

    protected abstract void onStartLine(byte[] var1, int var2, int var3) throws MalformedHttpException;

    protected abstract void onHeader(HttpHeader var1, byte[] var2, int var3, int var4) throws MalformedHttpException;

    protected abstract void onHeadersReceived(@Nullable ByteBuf var1, @Nullable ChannelSupplier<ByteBuf> var2);

    protected abstract void onBodyReceived();

    protected abstract void onBodySent();

    protected abstract void onNoContentLength();

    protected abstract void onClosed();

    protected abstract void onClosedWithError(Exception var1);

    protected abstract void onMalformedHttpException(MalformedHttpException var1);

    public final boolean isClosed() {
        return this.flags < 0;
    }

    public boolean isKeepAlive() {
        return (this.flags & 1) != 0;
    }

    public boolean isGzipped() {
        return (this.flags & 2) != 0;
    }

    public boolean isChunked() {
        return (this.flags & 4) != 0;
    }

    public boolean isBodyReceived() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isBodySent() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isWebSocket() {
        return (this.flags & 8) != 0;
    }

    public void setUserData(@Nullable Object userData) {
        this.userData = userData;
    }

    public Duration getPoolTimestamp() {
        return Duration.ofMillis(this.poolTimestamp);
    }

    @Nullable
    public Object getUserData() {
        return this.userData;
    }

    public MemSize getContentLength() {
        return MemSize.bytes((long)this.contentLength);
    }

    public MemSize getMaxBodySize() {
        return MemSize.bytes((long)this.maxBodySize);
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    protected void closeWebSocketConnection(Exception e) {
        if (e instanceof WebSocketException) {
            this.close();
        } else {
            this.closeEx(HttpUtils.translateToHttpException(e));
        }
    }

    protected final void close() {
        if (this.isClosed()) {
            return;
        }
        this.flags = (byte)(this.flags | 0xFFFFFF80);
        this.onClosed();
        this.socket.close();
    }

    protected final void closeEx(Exception e) {
        if (this.isClosed()) {
            return;
        }
        this.flags = (byte)(this.flags | 0xFFFFFF80);
        this.onClosedWithError(e);
        this.onClosed();
        this.socket.closeEx(e);
        this.closeException = e;
    }

    protected void read() {
        if (this.readBuf == null) {
            this.socket.read().subscribe((Callback)this.readMessageConsumer);
            return;
        }
        try {
            this.readMessage();
        }
        catch (MalformedHttpException e) {
            this.onMalformedHttpException(e);
        }
    }

    protected abstract void readMessage() throws MalformedHttpException;

    protected final void readStartLine() throws MalformedHttpException {
        byte[] array = this.readBuf.array();
        int head = this.readBuf.head();
        int tail = this.readBuf.tail();
        for (int p = head; p < tail; ++p) {
            if (array[p] != 10) continue;
            this.onStartLine(array, head, p + 1);
            this.readHeaders(p + 1);
            return;
        }
        if (this.readBuf.readRemaining() > MAX_HEADER_LINE_SIZE_BYTES) {
            throw new MalformedHttpException("Header line exceeds max header size");
        }
        this.socket.read().subscribe((Callback)this.readMessageConsumer);
    }

    private void readHeaders(int from) throws MalformedHttpException {
        byte[] array = this.readBuf.array();
        int offset = from;
        int tail = this.readBuf.tail();
        assert (!this.isClosed());
        while (offset < tail) {
            int headerLen;
            int i;
            for (i = offset; i < tail; ++i) {
                int limit;
                if (array[i] != 10) continue;
                if (i > offset + 1 && (i + 1 >= tail || array[i + 1] == 32 || array[i + 1] == 9)) break;
                int n = limit = i - 1 >= offset && array[i - 1] == 13 ? i - 1 : i;
                if (limit != offset) {
                    this.readHeader(array, offset, limit);
                    offset = i + 1;
                    continue;
                }
                this.readBuf.head(i + 1);
                this.readBody();
                return;
            }
            if (i == tail && tail - offset <= 1 || (headerLen = this.scanHeader(Math.max(offset, i - 1), array, offset, tail)) == -1) break;
            if (headerLen != 0) {
                this.readHeader(array, offset, offset + headerLen);
            }
            if (array[offset += headerLen] == 13) {
                ++offset;
            }
            if (array[offset] == 10) {
                ++offset;
            }
            if (headerLen != 0) continue;
            this.readBuf.head(offset);
            this.readBody();
            return;
        }
        this.readBuf.head(offset);
        if (this.readBuf.readRemaining() > MAX_HEADER_LINE_SIZE_BYTES) {
            throw new MalformedHttpException("Header line exceeds max header size");
        }
        this.socket.read().subscribe((Callback)this.readHeadersConsumer);
    }

    private int scanHeader(int from, byte[] array, int head, int tail) throws MalformedHttpException {
        int i = from;
        while (true) {
            byte b;
            if (i < tail && (b = array[i]) != 13 && b != 10) {
                ++i;
                continue;
            }
            if (i >= tail) {
                return -1;
            }
            b = array[i];
            if (b == 13) {
                if (++i >= tail) {
                    return -1;
                }
                b = array[i];
                if (b != 10) {
                    throw new MalformedHttpException("Invalid CRLF");
                }
                if (i - head == 1) {
                    return 0;
                }
                if (++i >= tail) {
                    return -1;
                }
                b = array[i];
                if (b == 32 || b == 9) {
                    array[i - 2] = 32;
                    array[i - 1] = 32;
                    continue;
                }
                return i - 2 - head;
            }
            assert (b == 10);
            if (i - head == 0) {
                return 0;
            }
            if (++i >= tail) {
                return -1;
            }
            b = array[i];
            if (b != 32 && b != 9) break;
            array[i - 1] = 32;
        }
        return i - 1 - head;
    }

    private void readHeader(byte[] array, int off, int limit) throws MalformedHttpException {
        byte b;
        int pos;
        int hashCodeCI = 0;
        for (pos = off; pos < limit && (b = array[pos]) != 58; ++pos) {
            hashCodeCI += b | 0x20;
        }
        if (pos == limit) {
            throw new MalformedHttpException("Header name is absent");
        }
        HttpHeader header = HttpHeaders.of(hashCodeCI, array, off, pos - off);
        ++pos;
        while (pos < limit && (array[pos] == 32 || array[pos] == 9)) {
            ++pos;
        }
        int len = limit - pos;
        if (header == HttpHeaders.CONTENT_LENGTH) {
            this.contentLength = HttpUtils.trimAndDecodePositiveLong(array, pos, len);
        } else if (header == HttpHeaders.CONNECTION) {
            this.flags = (byte)(this.flags & 0xFFFFFFFE | (ByteBufStrings.equalsLowerCaseAscii((byte[])CONNECTION_KEEP_ALIVE, (byte[])array, (int)pos, (int)len) ? 1 : 0));
        } else if (IWebSocket.ENABLED && header == HttpHeaders.UPGRADE) {
            this.flags = (byte)(this.flags | (ByteBufStrings.equalsLowerCaseAscii((byte[])UPGRADE_WEBSOCKET, (byte[])array, (int)pos, (int)len) ? 8 : 0));
        } else if (header == HttpHeaders.TRANSFER_ENCODING) {
            this.flags = (byte)(this.flags | (ByteBufStrings.equalsLowerCaseAscii((byte[])TRANSFER_ENCODING_CHUNKED, (byte[])array, (int)pos, (int)len) ? 4 : 0));
        } else if (header == HttpHeaders.CONTENT_ENCODING) {
            this.flags = (byte)(this.flags | (ByteBufStrings.equalsLowerCaseAscii((byte[])CONTENT_ENCODING_GZIP, (byte[])array, (int)pos, (int)len) ? 2 : 0));
        }
        this.onHeader(header, array, pos, len);
    }

    private void readBody() {
        ChannelOutput<ByteBuf> bodyStream;
        BufsConsumerChunkedDecoder process;
        AbstractCommunicatingProcess decoder;
        assert (!this.isClosed());
        if ((this.flags & 4) == 0) {
            if (this.contentLength == 0L) {
                this.onHeadersReceived(ByteBuf.empty(), null);
                if (this.isClosed()) {
                    return;
                }
                this.onBodyReceived();
                return;
            }
            if (this.contentLength == -1L) {
                this.onNoContentLength();
                return;
            }
            if ((this.flags & 2) == 0 && (long)this.readBuf.readRemaining() >= this.contentLength) {
                ByteBuf body;
                if ((long)this.readBuf.readRemaining() == this.contentLength) {
                    body = this.readBuf;
                    this.readBuf = null;
                } else {
                    body = this.readBuf.slice((int)this.contentLength);
                    this.readBuf.moveHead((int)this.contentLength);
                }
                this.onHeadersReceived(body, null);
                if (this.isClosed()) {
                    return;
                }
                this.onBodyReceived();
                return;
            }
        }
        ByteBuf readBuf = this.detachReadBuf();
        ByteBufs readBufs = new ByteBufs();
        readBufs.add(readBuf);
        BinaryChannelSupplier encodedStream = BinaryChannelSupplier.ofProvidedBufs((ByteBufs)readBufs, () -> this.socket.read().thenCallback((buf, cb) -> {
            if (buf == null) {
                cb.setException((Exception)new MalformedHttpException("Incomplete HTTP message"));
                return;
            }
            readBufs.add(buf);
            cb.set(null);
        }, (e, cb) -> {
            e = HttpUtils.translateToHttpException(e);
            this.closeEx((Exception)e);
            cb.setException(e);
        }), Promise::complete, (AsyncCloseable)AsyncCloseable.of(e -> {
            Exception httpException = HttpUtils.translateToHttpException(e);
            if (e instanceof MalformedHttpException) {
                this.onMalformedHttpException((MalformedHttpException)e);
            } else {
                this.closeEx(httpException);
            }
        }));
        if ((this.flags & 4) == 0) {
            decoder = BufsConsumerDelimiter.create(this.contentLength);
            process = decoder;
            encodedStream.bindTo(decoder.getInput());
            bodyStream = decoder.getOutput();
        } else {
            decoder = BufsConsumerChunkedDecoder.create();
            process = decoder;
            encodedStream.bindTo(decoder.getInput());
            bodyStream = decoder.getOutput();
        }
        if ((this.flags & 2) != 0) {
            decoder = BufsConsumerGzipInflater.create();
            process = decoder;
            bodyStream.bindTo((ChannelInput)decoder.getInput());
            bodyStream = decoder.getOutput();
        }
        ChannelSupplier supplier = bodyStream.getSupplier().withEndOfStream(eos -> eos.mapException(HttpUtils::translateToHttpException));
        if (this.isClosed()) {
            return;
        }
        this.onHeadersReceived(null, (ChannelSupplier<ByteBuf>)supplier);
        process.getProcessCompletion().subscribe(($, e) -> {
            if (this.isClosed()) {
                return;
            }
            if (e == null) {
                assert (this.readBuf == null);
                this.readBuf = readBufs.hasRemaining() ? readBufs.takeRemaining() : null;
                this.onBodyReceived();
            } else {
                this.closeEx(HttpUtils.translateToHttpException(e));
            }
        });
    }

    static ByteBuf renderHttpMessage(HttpMessage httpMessage) {
        if (httpMessage.body != null) {
            ByteBuf body = httpMessage.body;
            httpMessage.body = null;
            if ((httpMessage.flags & 2) == 0) {
                httpMessage.headers.add(HttpHeaders.CONTENT_LENGTH, HttpHeaderValue.ofDecimal(body.readRemaining()));
                ByteBuf buf = ByteBufPool.allocate((int)(httpMessage.estimateSize() + body.readRemaining()));
                httpMessage.writeTo(buf);
                buf.put(body);
                body.recycle();
                return buf;
            }
            ByteBuf gzippedBody = GzipProcessorUtils.toGzip(body);
            httpMessage.headers.add(HttpHeaders.CONTENT_ENCODING, HttpHeaderValue.ofBytes(CONTENT_ENCODING_GZIP));
            httpMessage.headers.add(HttpHeaders.CONTENT_LENGTH, HttpHeaderValue.ofDecimal(gzippedBody.readRemaining()));
            ByteBuf buf = ByteBufPool.allocate((int)(httpMessage.estimateSize() + gzippedBody.readRemaining()));
            httpMessage.writeTo(buf);
            buf.put(gzippedBody);
            gzippedBody.recycle();
            return buf;
        }
        if (httpMessage.bodyStream == null) {
            if (httpMessage.isContentLengthExpected()) {
                httpMessage.headers.add(HttpHeaders.CONTENT_LENGTH, HttpHeaderValue.ofDecimal(0));
            }
            ByteBuf buf = ByteBufPool.allocate((int)httpMessage.estimateSize());
            httpMessage.writeTo(buf);
            return buf;
        }
        return null;
    }

    protected void writeHttpMessageAsStream(@Nullable ByteBuf writeBuf, HttpMessage httpMessage) {
        ChannelSupplier bodyStream = httpMessage.bodyStream;
        assert (bodyStream != null);
        httpMessage.bodyStream = null;
        if (!IWebSocket.ENABLED || !this.isWebSocket()) {
            if ((httpMessage.flags & 2) != 0) {
                httpMessage.headers.add(HttpHeaders.CONTENT_ENCODING, HttpHeaderValue.ofBytes(CONTENT_ENCODING_GZIP));
                BufsConsumerGzipDeflater deflater = BufsConsumerGzipDeflater.create();
                bodyStream.bindTo(deflater.getInput());
                bodyStream = deflater.getOutput().getSupplier();
            }
            if (httpMessage.headers.get(HttpHeaders.CONTENT_LENGTH) == null) {
                httpMessage.headers.add(HttpHeaders.TRANSFER_ENCODING, HttpHeaderValue.ofBytes(TRANSFER_ENCODING_CHUNKED));
                BufsConsumerChunkedEncoder chunker = BufsConsumerChunkedEncoder.create();
                bodyStream.bindTo(chunker.getInput());
                bodyStream = chunker.getOutput().getSupplier();
            }
        }
        ByteBuf buf = ByteBufPool.allocate((int)httpMessage.estimateSize());
        httpMessage.writeTo(buf);
        this.writeStream((ChannelSupplier<ByteBuf>)ChannelSuppliers.concat((ChannelSupplier)(writeBuf != null ? ChannelSuppliers.ofValues((Object[])new ByteBuf[]{writeBuf, buf}) : ChannelSuppliers.ofValue((Object)buf)), bodyStream));
    }

    protected void writeBuf(ByteBuf buf) {
        this.socket.write(buf).subscribe(($, e) -> {
            if (this.isClosed()) {
                return;
            }
            if (e == null) {
                this.onBodySent();
            } else {
                this.closeEx(HttpUtils.translateToHttpException(e));
            }
        });
    }

    private void writeStream(ChannelSupplier<ByteBuf> supplier) {
        supplier.streamTo(ChannelConsumers.ofAsyncConsumer(buf -> this.socket.write(buf).whenException(e -> this.closeEx(HttpUtils.translateToHttpException(e))), (AsyncCloseable)AsyncCloseable.of(e -> this.closeEx(HttpUtils.translateToHttpException(e))))).whenResult(this::onBodySent);
    }

    protected void switchPool(ConnectionsLinkedList newPool) {
        this.pool.removeNode(this);
        this.pool = newPool;
        this.pool.addLastNode(this);
        this.poolTimestamp = this.reactor.currentTimeMillis();
    }

    protected final void stashBuf(ByteBuf buf) {
        if (this.stashedBufs == null) {
            this.stashedBufs = buf;
        } else {
            Recyclable prev = this.stashedBufs;
            this.stashedBufs = () -> {
                prev.recycle();
                buf.recycle();
            };
        }
    }

    protected final ByteBuf detachReadBuf() {
        ByteBuf readBuf = this.readBuf;
        this.readBuf = null;
        this.stashBuf(readBuf);
        readBuf.addRef();
        return readBuf;
    }

    protected final ChannelSupplier<ByteBuf> sanitize(final ChannelSupplier<ByteBuf> bodyStream) {
        return new AbstractChannelSupplier<ByteBuf>(bodyStream){

            protected Promise<ByteBuf> doGet() {
                if (AbstractHttpConnection.this.closeException != null) {
                    this.closeEx(AbstractHttpConnection.this.closeException);
                    return Promise.ofException((Exception)AbstractHttpConnection.this.closeException);
                }
                return bodyStream.get().thenCallback((result, cb) -> {
                    if (AbstractHttpConnection.this.closeException != null) {
                        if (result != null) {
                            result.recycle();
                        }
                        this.closeEx(AbstractHttpConnection.this.closeException);
                        cb.setException(AbstractHttpConnection.this.closeException);
                        return;
                    }
                    cb.set(result);
                });
            }
        };
    }

    public String toString() {
        return ", socket=" + this.socket + ", readBuf=" + this.readBuf + ", closed=" + this.isClosed() + ", keepAlive=" + this.isKeepAlive() + ", gzipped=" + this.isGzipped() + ", chunked=" + this.isChunked() + ", webSocket=" + (IWebSocket.ENABLED && this.isWebSocket()) + ", contentLengthRemaining=" + this.contentLength + ", poolTimestamp=" + this.poolTimestamp;
    }

    public abstract class ReadConsumer
    implements Callback<ByteBuf> {
        public void accept(ByteBuf buf, Exception e) {
            assert (!AbstractHttpConnection.this.isClosed() || e != null);
            if (e == null) {
                if (buf != null) {
                    ByteBuf readBuf = AbstractHttpConnection.this.readBuf;
                    if (readBuf == null) {
                        AbstractHttpConnection.this.readBuf = buf;
                    } else if (readBuf.writeRemaining() >= buf.readRemaining()) {
                        readBuf.put(buf);
                        buf.recycle();
                    } else {
                        AbstractHttpConnection.this.stashBuf(readBuf);
                        if (!readBuf.canRead()) {
                            AbstractHttpConnection.this.readBuf = buf;
                        } else {
                            ByteBuf newBuf = ByteBufPool.allocate((int)(readBuf.readRemaining() + buf.readRemaining()));
                            newBuf.put(readBuf);
                            newBuf.put(buf);
                            buf.recycle();
                            AbstractHttpConnection.this.readBuf = newBuf;
                        }
                    }
                    try {
                        this.thenRun();
                    }
                    catch (MalformedHttpException e1) {
                        AbstractHttpConnection.this.onMalformedHttpException(e1);
                    }
                } else {
                    AbstractHttpConnection.this.closeEx(new MalformedHttpException("Unexpected end of data"));
                }
            } else {
                AbstractHttpConnection.this.closeEx(HttpUtils.translateToHttpException(e));
            }
        }

        protected abstract void thenRun() throws MalformedHttpException;
    }
}

