/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;

public final class DebugStacktraceRenderer {
    private static final String IDEA_REST_API_STARTING_PORT = "63342";
    @Language(value="HTML")
    private static final String DEBUG_SERVER_ERROR_HTML = "<!doctype html>\n<html lang=\"en\">\n\t<head>\n\t\t<meta charset=\"UTF-8\">\n\t\t<title>{title}</title>\n\t\t<style>\n\t\t\thtml, body {\n\t\t\t\theight: 100%;\n\t\t\t\tmargin: 0;\n\t\t\t\tpadding: 0;\n\t\t\t}\n\n\t\t\th1, p {\n\t\t\t\tfont-family: sans-serif;\n\t\t\t}\n\n\t\t\t.link {\n\t\t\t\tcolor: #00E;\n\t\t\t\ttext-decoration: underline;\n\t\t\t\tcursor: pointer;\n\t\t\t}\n\t\t</style>\n\t</head>\n\t<body>\n\t\t<script>\n\t\t\twindow.onload = () => {\n\t\t\t\tfunction check(portOffset) {\n\t\t\t\t\tif (portOffset > 10) return Promise.reject('no running intellij idea instance found');\n\t\t\t\t\treturn fetch('http://localhost:' + ($ideaRestApiPort + portOffset))\n\t\t\t\t\t\t.then(r => r.text())\n\t\t\t\t\t\t.then(t => t.includes('IDEA') ? ($ideaRestApiPort + portOffset) : check(portOffset + 1), () => check(portOffset + 1));\n\t\t\t\t}\n\n\t\t\t\tcheck(0).then(port => document.querySelectorAll('[data-target]').forEach(a => {\n\t\t\t\t\ta.onclick = () => fetch('http://localhost:' + port + '/' + a.dataset.target);\n\t\t\t\t\ta.classList.add('link');\n\t\t\t\t}));\n\t\t\t};\n\t\t</script>\n\t\t<div style=\"position:relative;min-height:100%;\">\n\t\t\t<h1 style=\"text-align:center;margin-top:0;padding-top:0.5em;\">{title}</h1>\n\t\t\t<hr style=\"margin-left:10px;margin-right:10px;\">\n\t\t\t<pre style=\"color:#8B0000;font-size:1.5em;padding:10px 10px 4em;\">{stacktrace}</pre>\n\t\t\t<div style=\"position:absolute;bottom:1px;width:100%;height:4em\">\n\t\t\t\t<hr style=\"margin-left:10px;margin-right:10px\">\n\t\t\t\t<p style=\"text-align:center;\">ActiveJ $activejVersion</p>\n\t\t\t</div>\n\t\t</div>\n\t</body>\n</html>\n".replace("$ideaRestApiPort", "63342").replace("$activejVersion", "6.0-beta2");
    private static final Pattern STACK_TRACE_ELEMENT;

    public static HttpResponse.Builder render(Exception e, int code) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        Matcher matcher = STACK_TRACE_ELEMENT.matcher(writer.toString());
        StringBuilder stacktrace = new StringBuilder();
        while (matcher.find()) {
            String cls = matcher.group(2);
            String quotedFile = Matcher.quoteReplacement(cls.substring(0, cls.length() - 1).replace('.', '/').replaceAll("\\$.*(?:\\.|$)", ""));
            matcher.appendReplacement(stacktrace, "$1<a data-target=\"api/file/" + quotedFile + "$4$5\">$3</a>)");
        }
        matcher.appendTail(stacktrace);
        return HttpResponse.ofCode(code).withHtml(DEBUG_SERVER_ERROR_HTML.replace("{title}", HttpUtils.getHttpErrorTitle(code)).replace("{stacktrace}", stacktrace));
    }

    static {
        String ident = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        STACK_TRACE_ELEMENT = Pattern.compile("(at ((?:" + ident + "\\.)+)" + ident + "\\()(" + ident + "(\\." + ident + ")(:\\d+)?)\\)");
    }
}

