/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.http.AcceptCharset;
import io.activej.http.AcceptMediaType;
import io.activej.http.ContentType;
import io.activej.http.HttpCookie;
import io.activej.http.HttpDate;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import java.time.Instant;
import java.util.List;

public abstract class HttpHeaderValue {
    abstract int estimateSize();

    abstract int writeTo(byte[] var1, int var2);

    public abstract String toString();

    public static HttpHeaderValue of(String string) {
        return new HttpHeaderValueOfString(string);
    }

    public static HttpHeaderValue ofBytes(byte[] array, int offset, int size) {
        return new HttpHeaderValueOfBytes(array, offset, size);
    }

    public static HttpHeaderValue ofBytes(byte[] array) {
        return HttpHeaderValue.ofBytes(array, 0, array.length);
    }

    public static HttpHeaderValue ofDecimal(int value) {
        return new HttpHeaderValueOfUnsignedDecimal(value);
    }

    public static HttpHeaderValue ofAcceptCharsets(List<AcceptCharset> charsets) {
        return new HttpHeaderValueOfCharsets(charsets);
    }

    public static HttpHeaderValue ofAcceptCharsets(AcceptCharset ... charsets) {
        return HttpHeaderValue.ofAcceptCharsets(List.of(charsets));
    }

    public static HttpHeaderValue ofInstant(Instant date) {
        return new HttpHeaderValueOfDate(date.getEpochSecond());
    }

    public static HttpHeaderValue ofTimestamp(long timestamp) {
        return new HttpHeaderValueOfDate(timestamp / 1000L);
    }

    public static HttpHeaderValue ofAcceptMediaTypes(List<AcceptMediaType> type) {
        return new HttpHeaderValueOfAcceptMediaTypes(type);
    }

    public static HttpHeaderValue ofAcceptMediaTypes(AcceptMediaType ... types) {
        return HttpHeaderValue.ofAcceptMediaTypes(List.of(types));
    }

    public static HttpHeaderValue ofContentType(ContentType type) {
        return new HttpHeaderValueOfContentType(type);
    }

    public static int toPositiveInt(ByteBuf buf) throws MalformedHttpException {
        return HttpUtils.trimAndDecodePositiveInt(buf.array(), buf.head(), buf.readRemaining());
    }

    public static ContentType toContentType(ByteBuf buf) throws MalformedHttpException {
        try {
            return ContentType.decode(buf.array(), buf.head(), buf.readRemaining());
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode content-type", e);
        }
    }

    public static Instant toInstant(ByteBuf buf) throws MalformedHttpException {
        try {
            return Instant.ofEpochSecond(HttpDate.decode(buf.array(), buf.head()));
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode date", e);
        }
    }

    public ByteBuf getBuf() {
        int estimatedSize = this.estimateSize();
        ByteBuf buf = ByteBuf.wrapForWriting((byte[])new byte[estimatedSize]);
        int pos = this.writeTo(buf.array(), 0);
        buf.tail(pos);
        return buf;
    }

    public static void toAcceptContentTypes(ByteBuf buf, List<AcceptMediaType> into) throws MalformedHttpException {
        try {
            AcceptMediaType.decode(buf.array(), buf.head(), buf.readRemaining(), into);
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode accept-content", e);
        }
    }

    public static void toAcceptCharsets(ByteBuf buf, List<AcceptCharset> into) throws MalformedHttpException {
        try {
            AcceptCharset.decode(buf.array(), buf.head(), buf.readRemaining(), into);
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode accept-charset", e);
        }
    }

    static void toSimpleCookies(ByteBuf buf, List<HttpCookie> into) throws MalformedHttpException {
        try {
            HttpCookie.decodeSimple(buf.array(), buf.head(), buf.tail(), into);
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode cookies", e);
        }
    }

    static void toFullCookies(ByteBuf buf, List<HttpCookie> into) throws MalformedHttpException {
        try {
            HttpCookie.decodeFull(buf.array(), buf.head(), buf.tail(), into);
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode cookies", e);
        }
    }

    public static final class HttpHeaderValueOfString
    extends HttpHeaderValue {
        private final String string;

        HttpHeaderValueOfString(String string) {
            this.string = string;
        }

        @Override
        int estimateSize() {
            return this.string.length();
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return offset + ByteBufStrings.encodeAscii((byte[])array, (int)offset, (String)this.string);
        }

        @Override
        public String toString() {
            return this.string;
        }
    }

    public static final class HttpHeaderValueOfBytes
    extends HttpHeaderValue {
        private final byte[] array;
        private final int offset;
        private final int size;

        HttpHeaderValueOfBytes(byte[] array, int offset, int size) {
            this.array = array;
            this.offset = offset;
            this.size = size;
        }

        @Override
        int estimateSize() {
            return this.size;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            if (this.array.length < 10) {
                for (byte b : this.array) {
                    array[offset++] = b;
                }
                return offset;
            }
            System.arraycopy(this.array, this.offset, array, offset, this.size);
            return offset + this.size;
        }

        @Override
        public ByteBuf getBuf() {
            return ByteBuf.wrap((byte[])this.array, (int)this.offset, (int)(this.offset + this.size));
        }

        @Override
        public String toString() {
            return ByteBufStrings.decodeAscii((byte[])this.array, (int)this.offset, (int)this.size);
        }
    }

    public static final class HttpHeaderValueOfUnsignedDecimal
    extends HttpHeaderValue {
        private final int value;

        HttpHeaderValueOfUnsignedDecimal(int value) {
            this.value = value;
        }

        @Override
        int estimateSize() {
            return 10;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return offset + ByteBufStrings.encodePositiveInt((byte[])array, (int)offset, (int)this.value);
        }

        @Override
        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static final class HttpHeaderValueOfCharsets
    extends HttpHeaderValue {
        private final List<AcceptCharset> charsets;

        HttpHeaderValueOfCharsets(List<AcceptCharset> charsets) {
            this.charsets = charsets;
        }

        @Override
        int estimateSize() {
            int size = 0;
            for (AcceptCharset charset : this.charsets) {
                size += charset.estimateSize() + 2;
            }
            return size;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return AcceptCharset.render(this.charsets, array, offset);
        }

        @Override
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            AcceptCharset.render(this.charsets, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    public static final class HttpHeaderValueOfDate
    extends HttpHeaderValue {
        private final long epochSeconds;

        HttpHeaderValueOfDate(long epochSeconds) {
            this.epochSeconds = epochSeconds;
        }

        @Override
        int estimateSize() {
            return 29;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return HttpDate.render(this.epochSeconds, array, offset);
        }

        @Override
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            HttpDate.render(this.epochSeconds, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    public static final class HttpHeaderValueOfAcceptMediaTypes
    extends HttpHeaderValue {
        private final List<AcceptMediaType> types;

        HttpHeaderValueOfAcceptMediaTypes(List<AcceptMediaType> types) {
            this.types = types;
        }

        @Override
        public int estimateSize() {
            int size = 0;
            for (AcceptMediaType type : this.types) {
                size += type.estimateSize() + 2;
            }
            return size;
        }

        @Override
        public int writeTo(byte[] array, int offset) {
            return AcceptMediaType.render(this.types, array, offset);
        }

        @Override
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            AcceptMediaType.render(this.types, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    public static final class HttpHeaderValueOfContentType
    extends HttpHeaderValue {
        private final ContentType type;

        HttpHeaderValueOfContentType(ContentType type) {
            this.type = type;
        }

        @Override
        public int estimateSize() {
            return this.type.size();
        }

        @Override
        public int writeTo(byte[] array, int offset) {
            return ContentType.render(this.type, array, offset);
        }

        @Override
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            ContentType.render(this.type, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    public static final class HttpHeaderValueOfSetCookies
    extends HttpHeaderValue {
        final HttpCookie cookie;

        HttpHeaderValueOfSetCookies(HttpCookie cookie) {
            this.cookie = cookie;
        }

        @Override
        int estimateSize() {
            int size = 0;
            size += this.cookie.getName().length();
            size += this.cookie.getValue() == null ? 0 : this.cookie.getValue().length() + 1;
            size += this.cookie.getDomain() == null ? 0 : this.cookie.getDomain().length() + 10;
            size += this.cookie.getPath() == null ? 0 : this.cookie.getPath().length() + 6;
            size += this.cookie.getExtension() == null ? 0 : this.cookie.getExtension().length();
            return size += 102;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return this.cookie.renderFull(array, offset);
        }

        @Override
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            this.cookie.renderFull(buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    public static final class HttpHeaderValueOfSimpleCookies
    extends HttpHeaderValue {
        final List<HttpCookie> cookies;

        HttpHeaderValueOfSimpleCookies(List<HttpCookie> cookies) {
            this.cookies = cookies;
        }

        @Override
        int estimateSize() {
            int size = 0;
            for (HttpCookie cookie : this.cookies) {
                size += cookie.getName().length();
                size += cookie.getValue() == null ? 0 : cookie.getValue().length() + 1;
            }
            return size += (this.cookies.size() - 1) * 2;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return HttpCookie.renderSimple(this.cookies, array, offset);
        }

        @Override
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            HttpCookie.renderSimple(this.cookies, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    @FunctionalInterface
    public static interface DecoderInToListStreamConsumer<T> {
        public void decode(ByteBuf var1, List<T> var2) throws MalformedHttpException;
    }
}

