/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.ApplicationSettings;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaderValueBiPredicate;
import io.activej.http.HttpHeaderValuePredicate;
import io.activej.http.MalformedHttpException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

final class HttpHeadersMultimap<K, V> {
    static final int INITIAL_SIZE = ApplicationSettings.getInt(HttpHeadersMultimap.class, (String)"initialSize", (Integer)8);
    Object[] kvPairs = new Object[INITIAL_SIZE];
    int size;

    HttpHeadersMultimap() {
    }

    @Contract(pure=true)
    public int size() {
        return this.size;
    }

    public void add(K key, V value) {
        if (this.size++ > this.kvPairs.length / 4) {
            this.resize();
        }
        int i = key.hashCode() & this.kvPairs.length - 2;
        while (true) {
            if (this.kvPairs[i] == null) {
                this.kvPairs[i] = key;
                this.kvPairs[i + 1] = value;
                return;
            }
            i = i + 2 & this.kvPairs.length - 2;
        }
    }

    private void resize() {
        int beforeResize = this.size;
        Object[] oldKvPairs = this.kvPairs;
        this.kvPairs = new Object[this.kvPairs.length * 4];
        for (int i = 0; i != oldKvPairs.length; i += 2) {
            Object k = oldKvPairs[i];
            if (k == null) continue;
            Object v = oldKvPairs[i + 1];
            this.add(k, v);
        }
        this.size = beforeResize;
    }

    @Contract(pure=true)
    @Nullable
    public V get(K key) {
        Object[] kvPairs = this.kvPairs;
        int i = key.hashCode() & kvPairs.length - 2;
        Object k;
        while ((k = kvPairs[i]) != null) {
            if (k.equals(key)) {
                return (V)kvPairs[i + 1];
            }
            i = i + 2 & kvPairs.length - 2;
        }
        return null;
    }

    public Collection<Map.Entry<K, V>> getEntries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return HttpHeadersMultimap.this.size;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int i = 0;
                    @Nullable
                    K k;
                    @Nullable
                    V v;
                    {
                        this.advance();
                    }

                    private void advance() {
                        while (this.i < HttpHeadersMultimap.this.kvPairs.length) {
                            Object k = HttpHeadersMultimap.this.kvPairs[this.i];
                            if (k != null) {
                                this.k = k;
                                this.v = HttpHeadersMultimap.this.kvPairs[this.i + 1];
                                this.i += 2;
                                return;
                            }
                            this.i += 2;
                        }
                        this.k = null;
                        this.v = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.k != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.k == null) {
                            throw new NoSuchElementException();
                        }
                        AbstractMap.SimpleImmutableEntry entry = new AbstractMap.SimpleImmutableEntry(this.k, this.v);
                        this.advance();
                        return entry;
                    }
                };
            }
        };
    }

    public void forEach(HttpHeaderValueBiPredicate predicate) {
        Object[] kvPairs = this.kvPairs;
        for (int i = 0; i < kvPairs.length - 1; i += 2) {
            HttpHeader k = (HttpHeader)kvPairs[i];
            if (k == null) continue;
            try {
                if (predicate.test(k, (HttpHeaderValue)kvPairs[i + 1])) continue;
                break;
            }
            catch (MalformedHttpException malformedHttpException) {
                // empty catch block
            }
        }
    }

    public void forEach(HttpHeader header, HttpHeaderValuePredicate predicate) {
        HttpHeader k;
        Object[] kvPairs = this.kvPairs;
        int i = header.hashCode() & kvPairs.length - 2;
        while ((k = (HttpHeader)kvPairs[i]) != null) {
            if (k.equals(header)) {
                try {
                    if (!predicate.test((HttpHeaderValue)kvPairs[i + 1])) {
                        break;
                    }
                }
                catch (MalformedHttpException malformedHttpException) {
                    // empty catch block
                }
            }
            i = i + 2 & kvPairs.length - 2;
        }
    }

    public String toString() {
        return Arrays.toString(this.kvPairs);
    }
}

