/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.HttpCookie;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpMethod;
import io.activej.http.HttpServerConnection;
import io.activej.http.HttpVersion;
import io.activej.http.MultipartByteBufsDecoder;
import io.activej.http.Protocol;
import io.activej.http.QueryParameter;
import io.activej.http.UrlParser;
import io.activej.promise.Promise;
import io.activej.promise.ToPromise;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class HttpRequest
extends HttpMessage
implements ToPromise<HttpRequest> {
    private static final boolean CHECKS = Checks.isEnabled(HttpRequest.class);
    private static final int LONGEST_HTTP_METHOD_SIZE = 12;
    private static final byte[] HTTP_1_1 = ByteBufStrings.encodeAscii((String)" HTTP/1.1");
    private static final int HTTP_1_1_SIZE = HTTP_1_1.length;
    private final HttpMethod method;
    private final UrlParser url;
    private final HttpServerConnection connection;
    private InetAddress remoteAddress;
    private Map<String, String> pathParameters;
    private Map<String, String> queryParameters;
    private Map<String, String> postParameters;
    @Nullable
    private Map<String, String> parsedCookies;

    HttpRequest(HttpVersion version, HttpMethod method, UrlParser url, @Nullable HttpServerConnection connection) {
        super(version);
        this.method = method;
        this.url = url;
        this.connection = connection;
    }

    public static Builder builder(HttpMethod method, String url) {
        Protocol protocol;
        UrlParser urlParser = UrlParser.of(url);
        Builder builder = new HttpRequest(HttpVersion.HTTP_1_1, method, urlParser, null).new Builder();
        String hostAndPort = urlParser.getHostAndPort();
        if (hostAndPort != null) {
            builder.withHeader(HttpHeaders.HOST, HttpHeaderValue.of(hostAndPort));
        }
        if ((protocol = urlParser.getProtocol()) == Protocol.WS || protocol == Protocol.WSS) {
            builder.withHeader(HttpHeaders.CONNECTION, HttpHeaderValue.of("upgrade"));
            builder.withHeader(HttpHeaders.UPGRADE, HttpHeaderValue.of("websocket"));
            builder.withHeader(HttpHeaders.SEC_WEBSOCKET_VERSION, AbstractHttpConnection.WEB_SOCKET_VERSION);
        }
        return builder;
    }

    public static Builder get(String url) {
        return HttpRequest.builder(HttpMethod.GET, url);
    }

    public static Builder post(String url) {
        return HttpRequest.builder(HttpMethod.POST, url);
    }

    public static Builder put(String url) {
        return HttpRequest.builder(HttpMethod.PUT, url);
    }

    public Promise<HttpRequest> toPromise() {
        return Promise.of((Object)this);
    }

    @Contract(pure=true)
    public HttpMethod getMethod() {
        return this.method;
    }

    @Contract(pure=true)
    public InetAddress getRemoteAddress() {
        if (CHECKS) {
            Checks.checkNotNull((Object)this.remoteAddress);
        }
        return this.remoteAddress;
    }

    void setRemoteAddress(InetAddress inetAddress) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.remoteAddress = inetAddress;
    }

    boolean isRemoteAddressSet() {
        return this.remoteAddress != null;
    }

    public Protocol getProtocol() {
        return this.url.getProtocol();
    }

    void setProtocol(Protocol protocol) {
        this.url.setProtocol(protocol);
    }

    @Override
    boolean isContentLengthExpected() {
        return this.method != HttpMethod.GET && this.method != HttpMethod.HEAD && this.method != HttpMethod.TRACE && this.method != HttpMethod.CONNECT && this.method != HttpMethod.OPTIONS;
    }

    UrlParser getUrl() {
        return this.url;
    }

    @Nullable
    public String getHostAndPort() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getHostAndPort();
    }

    public String getPath() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getPath();
    }

    public String getPathAndQuery() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getPathAndQuery();
    }

    public Map<String, String> getCookies() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.parsedCookies != null) {
            return this.parsedCookies;
        }
        LinkedHashMap<String, String> cookies = new LinkedHashMap<String, String>();
        for (HttpCookie cookie : this.getHeader(HttpHeaders.COOKIE, HttpHeaderValue::toSimpleCookies)) {
            cookies.put(cookie.getName(), cookie.getValue());
        }
        this.parsedCookies = cookies;
        return this.parsedCookies;
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public String getCookie(String cookie) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.getCookies().get(cookie);
    }

    public String getQuery() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQuery();
    }

    public String getFragment() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getFragment();
    }

    public Map<String, String> getQueryParameters() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.queryParameters != null) {
            return this.queryParameters;
        }
        this.queryParameters = this.url.getQueryParameters();
        return this.queryParameters;
    }

    @Nullable
    public String getQueryParameter(String key) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQueryParameter(key);
    }

    public List<String> getQueryParameters(String key) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQueryParameters(key);
    }

    public Iterable<QueryParameter> getQueryParametersIterable() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.getQueryParametersIterable();
    }

    @Nullable
    public String getPostParameter(String name) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.getPostParameters().get(name);
    }

    public Map<String, String> getPostParameters() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.postParameters != null) {
            return this.postParameters;
        }
        if (this.body == null) {
            throw new NullPointerException("Body must be loaded to decode post parameters");
        }
        this.postParameters = this.containsPostParameters() ? UrlParser.parseQueryIntoMap(this.body.array(), this.body.head(), this.body.tail()) : Map.of();
        return this.postParameters;
    }

    public boolean containsPostParameters() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.method != HttpMethod.POST && this.method != HttpMethod.PUT) {
            return false;
        }
        String contentType = this.getHeader(HttpHeaders.CONTENT_TYPE);
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    public boolean containsMultipartData() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.method != HttpMethod.POST && this.method != HttpMethod.PUT) {
            return false;
        }
        String contentType = this.getHeader(HttpHeaders.CONTENT_TYPE);
        return contentType != null && contentType.startsWith("multipart/form-data; boundary=");
    }

    public Map<String, String> getPathParameters() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.pathParameters != null ? this.pathParameters : Map.of();
    }

    public String getPathParameter(String key) {
        String pathParameter;
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.pathParameters != null && (pathParameter = this.pathParameters.get(key)) != null) {
            return pathParameter;
        }
        throw new IllegalArgumentException("No path parameter '" + key + "' found");
    }

    public Promise<Void> handleMultipart(MultipartByteBufsDecoder.AsyncMultipartDataHandler multipartDataHandler) {
        String contentType;
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if ((contentType = this.getHeader(HttpHeaders.CONTENT_TYPE)) == null || !contentType.startsWith("multipart/form-data; boundary=")) {
            return Promise.ofException((Exception)HttpError.ofCode(400, "Content type is not multipart/form-data"));
        }
        String boundary = contentType.substring(30);
        if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
            boundary = boundary.substring(1, boundary.length() - 1);
        }
        return MultipartByteBufsDecoder.create(boundary).split(this.takeBodyStream(), multipartDataHandler);
    }

    int getPos() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.pos;
    }

    void setPos(int pos) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.url.pos = (short)pos;
    }

    public String getRelativePath() {
        String partialPath;
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return (partialPath = this.url.getPartialPath()).startsWith("/") ? partialPath.substring(1) : partialPath;
    }

    String pollUrlPart() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.url.pollUrlPart();
    }

    void removePathParameter(String key) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.pathParameters.remove(key);
    }

    void putPathParameter(String key, String value) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.pathParameters == null) {
            this.pathParameters = new HashMap<String, String>();
        }
        this.pathParameters.put(key, value);
    }

    @Override
    protected int estimateSize() {
        return this.estimateSize(13 + this.url.getPathAndQueryLength()) + HTTP_1_1_SIZE;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        this.method.write(buf);
        buf.put((byte)32);
        this.url.writePathAndQuery(buf);
        buf.put(HTTP_1_1);
        this.writeHeaders(buf);
    }

    public String getFullUrl() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.url.isRelativePath()) {
            String host = this.getHeader(HttpHeaders.HOST);
            return this.getProtocol().lowercase() + "://" + Utils.nonNullElseEmpty((String)host) + this.url;
        }
        return this.url.toString();
    }

    public String toString() {
        if (this.isRecycled()) {
            return "{Recycled HttpRequest}";
        }
        return this.getFullUrl();
    }

    public final class Builder
    extends HttpMessage.Builder<Builder, HttpRequest> {
        private Builder() {
            super(HttpRequest.this);
        }

        @Override
        protected void addCookies(List<HttpCookie> cookies) {
            HttpRequest.this.headers.add(HttpHeaders.COOKIE, new HttpHeaderValue.HttpHeaderValueOfSimpleCookies(cookies));
        }

        @Override
        protected void addCookie(HttpCookie cookie) {
            this.addCookies(List.of(cookie));
        }
    }
}

