/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.stream;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.TruncatedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.ChannelOutput;
import io.activej.csp.binary.BinaryChannelInput;
import io.activej.csp.binary.decoder.ByteBufsDecoders;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.dsl.WithBinaryChannelInput;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.promise.Promise;
import io.activej.reactor.Reactive;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class BufsConsumerGzipInflater
extends AbstractCommunicatingProcess
implements WithChannelTransformer<BufsConsumerGzipInflater, ByteBuf, ByteBuf>,
WithBinaryChannelInput<BufsConsumerGzipInflater> {
    public static final int MAX_HEADER_FIELD_LENGTH = 4096;
    public static final int DEFAULT_BUF_SIZE = 512;
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8};
    private static final int GZIP_FOOTER_SIZE = 8;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private final CRC32 crc32 = new CRC32();
    private Inflater inflater = new Inflater(true);
    private ByteBufs bufs;
    private AbstractCommunicatingProcess.SanitizedBinaryChannelSupplier input;
    private ChannelConsumer<ByteBuf> output;

    private BufsConsumerGzipInflater() {
    }

    public static BufsConsumerGzipInflater create() {
        return (BufsConsumerGzipInflater)((Object)BufsConsumerGzipInflater.builder().build());
    }

    public static Builder builder() {
        return new BufsConsumerGzipInflater().new Builder();
    }

    public BinaryChannelInput getInput() {
        return input -> {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            this.bufs = input.getBufs();
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    protected void doProcess() {
        this.processHeader();
    }

    private void processHeader() {
        if (this.input.getBufs().isEmpty()) {
            this.input.getUnsanitizedSupplier().needMoreData().whenResult(this::processHeader).whenException(e -> {
                if (e instanceof TruncatedDataException) {
                    this.output.acceptEndOfStream().whenResult(() -> this.completeProcess());
                } else {
                    this.closeEx((Exception)e);
                }
            });
            return;
        }
        this.input.decode(ByteBufsDecoders.ofFixedSize((int)10)).whenResult(buf -> {
            if (buf.get() != GZIP_HEADER[0] || buf.get() != GZIP_HEADER[1]) {
                buf.recycle();
                this.closeEx((Exception)new UnknownFormatException("Incorrect identification bytes. Not in GZIP format"));
                return;
            }
            if (buf.get() != GZIP_HEADER[2]) {
                buf.recycle();
                this.closeEx((Exception)new UnknownFormatException("Unsupported compression method. Deflate compression required"));
                return;
            }
            byte flag = buf.get();
            if ((flag & 0xE0) > 0) {
                buf.recycle();
                this.closeEx((Exception)((Object)new MalformedDataException("Flag byte of a header is malformed. Reserved bits are set")));
                return;
            }
            flag = (byte)(flag & 0xFFFFFFFE);
            buf.recycle();
            this.runNext(flag);
        }).whenException(arg_0 -> ((BufsConsumerGzipInflater)this).closeEx(arg_0));
    }

    private void processBody() {
        ByteBufs bufs = new ByteBufs();
        while (this.bufs.hasRemaining()) {
            ByteBuf src = this.bufs.peekBuf();
            assert (src != null);
            this.inflater.setInput(src.array(), src.head(), src.readRemaining());
            try {
                this.inflate(bufs, src);
            }
            catch (DataFormatException e) {
                bufs.recycle();
                this.closeEx(e);
                return;
            }
            if (!this.inflater.finished()) continue;
            this.output.acceptAll(bufs.asIterator()).whenResult(this::processFooter);
            return;
        }
        this.output.acceptAll(bufs.asIterator()).then(() -> this.input.needMoreData()).whenResult(this::processBody);
    }

    private void processFooter() {
        this.input.decode(ByteBufsDecoders.ofFixedSize((int)8)).whenResult(buf -> {
            if ((int)this.crc32.getValue() != Integer.reverseBytes(buf.readInt())) {
                this.closeEx((Exception)((Object)new MalformedDataException("CRC32 value of uncompressed data differs")));
                buf.recycle();
                return;
            }
            if (this.inflater.getTotalOut() != Integer.reverseBytes(buf.readInt())) {
                this.closeEx((Exception)new InvalidSizeException("Decompressed data size is not equal to input size from GZIP trailer"));
                buf.recycle();
                return;
            }
            buf.recycle();
            this.input.endOfStream().then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
        }).whenException(arg_0 -> ((BufsConsumerGzipInflater)this).closeEx(arg_0));
    }

    private void inflate(ByteBufs bufs, ByteBuf src) throws DataFormatException {
        while (true) {
            ByteBuf buf = ByteBufPool.allocate((int)Math.max(src.readRemaining(), 512));
            int beforeInflation = this.inflater.getTotalIn();
            int len = this.inflater.inflate(buf.array(), 0, buf.writeRemaining());
            buf.moveTail(len);
            src.moveHead(this.inflater.getTotalIn() - beforeInflation);
            if (len == 0) {
                if (!src.canRead()) {
                    this.bufs.take().recycle();
                }
                buf.recycle();
                return;
            }
            this.crc32.update(buf.array(), buf.head(), buf.readRemaining());
            bufs.add(buf);
        }
    }

    private void skipHeaders(int flag) {
        if ((flag & 4) != 0) {
            this.skipExtra(flag);
        } else if ((flag & 8) != 0) {
            this.skipTerminatorByte(flag, 8);
        } else if ((flag & 0x10) != 0) {
            this.skipTerminatorByte(flag, 16);
        } else if ((flag & 2) != 0) {
            this.skipCRC16(flag);
        }
    }

    private void skipTerminatorByte(int flag, int part) {
        this.input.decode(ByteBufsDecoders.ofNullTerminatedBytes((int)4096)).whenException(e -> this.closeEx((Exception)new InvalidSizeException("FNAME or FEXTRA header is larger than maximum allowed length"))).whenResult(ByteBuf::recycle).whenResult(() -> this.runNext(flag - part));
    }

    private void skipExtra(int flag) {
        this.input.decode(ByteBufsDecoders.ofFixedSize((int)2)).map(shortBuf -> {
            short toSkip = Short.reverseBytes(shortBuf.readShort());
            shortBuf.recycle();
            return toSkip;
        }).then(toSkip -> {
            if (toSkip > 4096) {
                InvalidSizeException exception = new InvalidSizeException("FEXTRA part of a header is larger than maximum allowed length");
                this.closeEx((Exception)exception);
                return Promise.ofException((Exception)exception);
            }
            return this.input.decode(ByteBufsDecoders.ofFixedSize((int)toSkip.shortValue()));
        }).whenException(arg_0 -> ((BufsConsumerGzipInflater)this).closeEx(arg_0)).whenResult(ByteBuf::recycle).whenResult(() -> this.runNext(flag - 4));
    }

    private void skipCRC16(int flag) {
        this.input.decode(ByteBufsDecoders.ofFixedSize((int)2)).whenException(arg_0 -> ((BufsConsumerGzipInflater)this).closeEx(arg_0)).whenResult(ByteBuf::recycle).whenResult(() -> this.runNext(flag - 2));
    }

    private void runNext(int flag) {
        if (flag != 0) {
            this.skipHeaders(flag);
        } else {
            this.processBody();
        }
    }

    protected void doClose(Exception e) {
        this.inflater.end();
        this.input.closeEx(e);
        this.output.closeEx(e);
    }

    public final class Builder
    extends AbstractBuilder<Builder, BufsConsumerGzipInflater> {
        private Builder() {
        }

        public Builder withInflater(Inflater inflater) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            BufsConsumerGzipInflater.this.inflater = inflater;
            return this;
        }

        protected BufsConsumerGzipInflater doBuild() {
            return BufsConsumerGzipInflater.this;
        }
    }
}

