/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns;

import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.dns.DnsCache;
import io.activej.dns.IDnsClient;
import io.activej.dns.protocol.DnsQuery;
import io.activej.dns.protocol.DnsQueryException;
import io.activej.dns.protocol.DnsResponse;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import io.activej.reactor.jmx.ReactiveJmxBean;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedDnsClient
extends AbstractReactive
implements IDnsClient,
ReactiveJmxBean {
    private static final Logger logger = LoggerFactory.getLogger(CachedDnsClient.class);
    private static final boolean CHECKS = Checks.isEnabled(CachedDnsClient.class);
    private final IDnsClient client;
    private final DnsCache cache;
    private final Map<DnsQuery, Promise<DnsResponse>> pending = new HashMap<DnsQuery, Promise<DnsResponse>>();
    private final Set<DnsQuery> refreshingNow = Collections.newSetFromMap(new ConcurrentHashMap());

    private CachedDnsClient(Reactor reactor, IDnsClient client, DnsCache cache) {
        super(reactor);
        this.client = client;
        this.cache = cache;
    }

    public static CachedDnsClient create(Reactor reactor, IDnsClient client, DnsCache cache) {
        return (CachedDnsClient)CachedDnsClient.builder(reactor, client, cache).build();
    }

    public static CachedDnsClient create(Reactor reactor, IDnsClient client) {
        return (CachedDnsClient)CachedDnsClient.builder(reactor, client).build();
    }

    public static Builder builder(Reactor reactor, IDnsClient client) {
        return CachedDnsClient.builder(reactor, client, DnsCache.create(reactor));
    }

    public static Builder builder(Reactor reactor, IDnsClient client, DnsCache cache) {
        return new CachedDnsClient(reactor, client, cache).new Builder();
    }

    public IDnsClient adaptToAnotherReactor(final Reactor anotherReactor) {
        if (anotherReactor == this.reactor) {
            return this;
        }
        return new IDnsClient(){

            @Override
            public Promise<DnsResponse> resolve(DnsQuery query) {
                DnsResponse fromQuery;
                if (CHECKS) {
                    Reactor.checkInReactorThread((Reactor)anotherReactor);
                }
                if ((fromQuery = IDnsClient.resolveFromQuery(query)) != null) {
                    logger.trace("{} already contained an IP address within itself", (Object)query);
                    return Promise.of((Object)fromQuery);
                }
                DnsCache.DnsQueryCacheResult cacheResult = CachedDnsClient.this.cache.tryToResolve(query);
                if (cacheResult != null) {
                    if (cacheResult.doesNeedRefreshing() && !CachedDnsClient.this.refreshingNow.add(query)) {
                        CachedDnsClient.this.reactor.execute(() -> CachedDnsClient.this.refresh(query));
                    }
                    return cacheResult.getResponseAsPromise();
                }
                anotherReactor.startExternalTask();
                return Promise.ofCallback(cb -> CachedDnsClient.this.reactor.execute(() -> CachedDnsClient.this.resolve(query).subscribe((result, e) -> {
                    anotherReactor.execute(() -> cb.set(result, e));
                    anotherReactor.completeExternalTask();
                })));
            }

            @Override
            public void close() {
                Reactor.checkInReactorThread((Reactor)anotherReactor);
                CachedDnsClient.this.reactor.execute(CachedDnsClient.this::close);
            }
        };
    }

    private void addToCache(DnsQuery query, DnsResponse response, @Nullable Exception e) {
        if (e == null) {
            this.cache.add(query, response);
        } else if (e instanceof DnsQueryException) {
            this.cache.add(query, ((DnsQueryException)e).getResult());
        }
    }

    private void refresh(DnsQuery query) {
        if (!this.refreshingNow.add(query)) {
            logger.trace("{} needs refreshing, but it does so right now", (Object)query);
            return;
        }
        logger.trace("Refreshing {}", (Object)query);
        this.client.resolve(query).subscribe((response, e) -> {
            this.addToCache(query, (DnsResponse)response, e);
            this.refreshingNow.remove(query);
        });
    }

    @Override
    public Promise<DnsResponse> resolve(DnsQuery query) {
        DnsResponse fromQuery;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if ((fromQuery = IDnsClient.resolveFromQuery(query)) != null) {
            logger.trace("{} already contained an IP address within itself", (Object)query);
            return Promise.of((Object)fromQuery);
        }
        logger.trace("Resolving {}", (Object)query);
        DnsCache.DnsQueryCacheResult cacheResult = this.cache.tryToResolve(query);
        if (cacheResult != null) {
            if (cacheResult.doesNeedRefreshing()) {
                this.refresh(query);
            }
            return cacheResult.getResponseAsPromise();
        }
        this.cache.performCleanup();
        Promise<DnsResponse> promise = this.pending.get(query);
        if (promise != null) {
            return promise;
        }
        Promise<DnsResponse> resolve = this.client.resolve(query);
        resolve.subscribe((response, e) -> this.addToCache(query, (DnsResponse)response, e));
        if (resolve.isComplete()) {
            return resolve;
        }
        this.pending.put(query, resolve);
        return resolve.whenComplete(() -> this.pending.remove(query));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @JmxAttribute(name="")
    public DnsCache getCache() {
        return this.cache;
    }

    @JmxOperation
    public List<String> getResolvedDomains() {
        return this.cache.getResolvedDomains();
    }

    @JmxOperation
    public List<String> getFailedDomains() {
        return this.cache.getFailedDomains();
    }

    @JmxOperation
    public List<String> getDomainRecord(String domain) {
        return this.cache.getDomainRecord(domain);
    }

    @JmxOperation
    public List<String> getDomainRecords() {
        return this.cache.getDomainRecords();
    }

    @JmxOperation
    public void clear() {
        this.cache.clear();
    }

    public final class Builder
    extends AbstractBuilder<Builder, CachedDnsClient> {
        private Builder() {
        }

        public Builder withExpiration(Duration errorCacheExpiration, Duration hardExpirationDelta) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withExpiration(errorCacheExpiration, hardExpirationDelta, DnsCache.DEFAULT_TIMED_OUT_EXPIRATION);
        }

        public Builder withExpiration(Duration errorCacheExpiration, Duration hardExpirationDelta, Duration timedOutExceptionTtl) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            CachedDnsClient.this.cache.setErrorCacheExpiration(errorCacheExpiration);
            CachedDnsClient.this.cache.setHardExpirationDelta(hardExpirationDelta);
            CachedDnsClient.this.cache.setTimedOutExpiration(timedOutExceptionTtl);
            return this;
        }

        protected CachedDnsClient doBuild() {
            return CachedDnsClient.this;
        }
    }
}

