/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.http.HttpCharset;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import java.nio.charset.Charset;
import java.util.List;

public final class AcceptCharset {
    public static final int DEFAULT_Q = 100;
    private static final byte[] Q_KEY = ByteBufStrings.encodeAscii((String)"q");
    private final HttpCharset charset;
    private final int q;

    private AcceptCharset(HttpCharset charset, int q) {
        this.charset = charset;
        this.q = q;
    }

    private AcceptCharset(HttpCharset charset) {
        this(charset, 100);
    }

    public static AcceptCharset of(Charset charset) {
        return new AcceptCharset(HttpCharset.of(charset));
    }

    public static AcceptCharset of(Charset charset, int q) {
        Checks.checkArgument((q >= 0 && q <= 100 ? 1 : 0) != 0, (Object)"Cannot create AcceptCharset with 'q' that is outside of bounds [0, 100]");
        return new AcceptCharset(HttpCharset.of(charset), q);
    }

    private static AcceptCharset of(HttpCharset charset) {
        return new AcceptCharset(charset);
    }

    private static AcceptCharset of(HttpCharset charset, int q) {
        return new AcceptCharset(charset, q);
    }

    public Charset getCharset() throws MalformedHttpException {
        return this.charset.toJavaCharset();
    }

    public int getQ() {
        return this.q;
    }

    static void decode(byte[] bytes, int pos, int len, List<AcceptCharset> list) throws MalformedHttpException {
        int end = pos + len;
        while (pos < end) {
            int start = pos = HttpUtils.skipSpaces(bytes, pos, end);
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            HttpCharset charset = HttpCharset.decode(bytes, start, pos - start);
            if (pos < end) {
                if (bytes[pos++] == 44) {
                    list.add(AcceptCharset.of(charset));
                    continue;
                }
                int q = 100;
                start = pos = HttpUtils.skipSpaces(bytes, pos, end);
                while (pos < end && bytes[pos] != 44) {
                    if (bytes[pos] == 61 && ByteBufStrings.equalsLowerCaseAscii((byte[])Q_KEY, (byte[])bytes, (int)start, (int)(pos - start))) {
                        start = ++pos;
                        while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                            ++pos;
                        }
                        q = HttpUtils.decodeQ(bytes, start, pos - start);
                        --pos;
                    } else if (bytes[pos] == 59) {
                        start = pos = HttpUtils.skipSpaces(bytes, pos + 1, end);
                    }
                    ++pos;
                }
                list.add(AcceptCharset.of(charset, q));
                ++pos;
                continue;
            }
            list.add(AcceptCharset.of(charset));
        }
    }

    static void render(List<AcceptCharset> charsets, ByteBuf buf) {
        int pos = AcceptCharset.render(charsets, buf.array(), buf.tail());
        buf.tail(pos);
    }

    static int render(List<AcceptCharset> charsets, byte[] bytes, int pos) {
        for (int i = 0; i < charsets.size(); ++i) {
            AcceptCharset charset = charsets.get(i);
            pos += HttpCharset.render(charset.charset, bytes, pos);
            if (charset.q != 100) {
                bytes[pos++] = 59;
                bytes[pos++] = 32;
                bytes[pos++] = 113;
                bytes[pos++] = 61;
                bytes[pos++] = 48;
                bytes[pos++] = 46;
                int q = charset.q;
                if (q % 10 == 0) {
                    q /= 10;
                }
                pos += ByteBufStrings.encodePositiveInt((byte[])bytes, (int)pos, (int)q);
            }
            if (i >= charsets.size() - 1) continue;
            bytes[pos++] = 44;
            bytes[pos++] = 32;
        }
        return pos;
    }

    int estimateSize() {
        return this.charset.size() + 10;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptCharset that = (AcceptCharset)o;
        if (this.q != that.q) {
            return false;
        }
        return this.charset.equals(that.charset);
    }

    public int hashCode() {
        int result = this.charset.hashCode();
        result = 31 * result + this.q;
        return result;
    }

    public String toString() {
        return "AcceptCharset{charset=" + this.charset + ", q=" + this.q + "}";
    }
}

