/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import java.util.List;

public final class AcceptMediaType {
    public static final int DEFAULT_Q = 100;
    private static final byte[] Q_KEY = new byte[]{113};
    private final MediaType mime;
    private final int q;

    private AcceptMediaType(MediaType mime, int q) {
        this.mime = mime;
        this.q = q;
    }

    private AcceptMediaType(MediaType mime) {
        this(mime, 100);
    }

    public static AcceptMediaType of(MediaType mime) {
        return new AcceptMediaType(mime);
    }

    public static AcceptMediaType of(MediaType mime, int q) {
        Checks.checkArgument((q >= 0 && q <= 100 ? 1 : 0) != 0, (Object)"Cannot create AcceptMediaType with 'q' that is outside of bounds [0, 100]");
        return new AcceptMediaType(mime, q);
    }

    static void decode(byte[] bytes, int pos, int length, List<AcceptMediaType> list) throws MalformedHttpException {
        int end = pos + length;
        while (pos < end) {
            int start = pos = HttpUtils.skipSpaces(bytes, pos, end);
            int hashCodeCI = 0;
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                byte b = bytes[pos++];
                hashCodeCI += b | 0x20;
            }
            MediaType mime = MediaTypes.of(hashCodeCI, bytes, start, pos - start);
            if (pos < end) {
                if (bytes[pos++] == 44) {
                    list.add(AcceptMediaType.of(mime));
                    continue;
                }
                int q = 100;
                start = pos = HttpUtils.skipSpaces(bytes, pos, end);
                while (pos < end && bytes[pos] != 44) {
                    if (bytes[pos] == 61 && ByteBufStrings.equalsLowerCaseAscii((byte[])Q_KEY, (byte[])bytes, (int)start, (int)(pos - start))) {
                        start = ++pos;
                        while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                            ++pos;
                        }
                        q = HttpUtils.decodeQ(bytes, start, pos - start);
                        --pos;
                    } else if (bytes[pos] == 59) {
                        start = pos = HttpUtils.skipSpaces(bytes, pos + 1, end);
                    }
                    ++pos;
                }
                list.add(AcceptMediaType.of(mime, q));
                ++pos;
                continue;
            }
            list.add(AcceptMediaType.of(mime));
        }
    }

    static void render(List<AcceptMediaType> types, ByteBuf buf) {
        int pos = AcceptMediaType.render(types, buf.array(), buf.tail());
        buf.tail(pos);
    }

    static int render(List<AcceptMediaType> types, byte[] container, int pos) {
        for (int i = 0; i < types.size(); ++i) {
            AcceptMediaType type = types.get(i);
            pos += MediaTypes.render(type.mime, container, pos);
            if (type.q != 100) {
                container[pos++] = 59;
                container[pos++] = 32;
                container[pos++] = 113;
                container[pos++] = 61;
                container[pos++] = 48;
                container[pos++] = 46;
                int q = type.q;
                if (q % 10 == 0) {
                    q /= 10;
                }
                pos += ByteBufStrings.encodePositiveInt((byte[])container, (int)pos, (int)q);
            }
            if (i >= types.size() - 1) continue;
            container[pos++] = 44;
            container[pos++] = 32;
        }
        return pos;
    }

    int estimateSize() {
        return this.mime.size() + 10;
    }

    public MediaType getMediaType() {
        return this.mime;
    }

    public int getQ() {
        return this.q;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptMediaType that = (AcceptMediaType)o;
        if (this.q != that.q) {
            return false;
        }
        return this.mime.equals(that.mime);
    }

    public int hashCode() {
        int result = this.mime.hashCode();
        result = 31 * result + this.q;
        return result;
    }

    public String toString() {
        return "AcceptMediaType{mime=" + this.mime + ", q=" + this.q + "}";
    }
}

