/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.http.DebugStacktraceRenderer;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import io.activej.promise.Promise;
import org.intellij.lang.annotations.Language;

@FunctionalInterface
public interface HttpExceptionFormatter {
    public static final String ACTIVEJ_VERSION = "6.0-rc2";
    @Language(value="HTML")
    public static final String HTTP_ERROR_HTML = "<!doctype html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>{title}</title>\n<style>h1, p { font-family: sans-serif; }</style>\n</head>\n<body>\n<h1 style=\"text-align: center;\">{title}</h1>\n<hr>\n<p style=\"text-align: center\">{message}</p>\n<hr>\n<p style=\"text-align: center;\">{activej_version}</p>\n</body>\n</html>\n".replace("{activej_version}", "6.0-rc2");
    public static final String INTERNAL_SERVER_ERROR_HTML = HTTP_ERROR_HTML.replace("{title}", "Internal Server Error").replace("<p style=\"text-align: center\">{message}</p>\n<hr>", "");
    public static final HttpExceptionFormatter DEFAULT_FORMATTER = e -> {
        HttpResponse.Builder responseBuilder;
        if (e instanceof HttpError) {
            HttpError httpError = (HttpError)e;
            int code = httpError.getCode();
            responseBuilder = HttpResponse.ofCode(code).withHtml(HTTP_ERROR_HTML.replace("{title}", HttpUtils.getHttpErrorTitle(code)).replace("{message}", e.toString()));
        } else {
            responseBuilder = e instanceof MalformedHttpException ? HttpResponse.ofCode(400).withHtml(HTTP_ERROR_HTML.replace("{title}", "400. Bad Request").replace("{message}", e.toString())) : HttpResponse.ofCode(500).withHtml(INTERNAL_SERVER_ERROR_HTML);
        }
        return ((HttpResponse.Builder)responseBuilder.withHeader(HttpHeaders.CACHE_CONTROL, "no-store")).toPromise();
    };
    public static final HttpExceptionFormatter DEBUG_FORMATTER = e -> {
        int n;
        if (e instanceof HttpError) {
            HttpError httpError = (HttpError)e;
            n = httpError.getCode();
        } else {
            n = e instanceof MalformedHttpException ? 400 : 500;
        }
        int code = n;
        return ((HttpResponse.Builder)DebugStacktraceRenderer.render(e, code).withHeader(HttpHeaders.CACHE_CONTROL, "no-store")).toPromise();
    };
    public static final HttpExceptionFormatter COMMON_FORMATTER = System.getProperty("java.class.path", "").contains("idea_rt.jar") ? DEBUG_FORMATTER : DEFAULT_FORMATTER;

    public Promise<HttpResponse> formatException(Exception var1);
}

