/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.http.ContentTypes;
import io.activej.http.HttpClientConnection;
import io.activej.http.HttpCookie;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpVersion;
import io.activej.promise.Promise;
import io.activej.promise.ToPromise;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class HttpResponse
extends HttpMessage
implements ToPromise<HttpResponse> {
    private static final boolean CHECKS = Checks.isEnabled(HttpResponse.class);
    private static final byte[] HTTP11_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 ");
    private static final byte[] CODE_ERROR_BYTES = ByteBufStrings.encodeAscii((String)" Error");
    private static final byte[] CODE_OK_BYTES = ByteBufStrings.encodeAscii((String)" OK");
    private static final byte[] CODE_100_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 100 Continue");
    private static final byte[] CODE_101_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 101 Switching protocols");
    private static final byte[] CODE_102_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 102 Processing");
    private static final byte[] CODE_103_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 103 Early Hints");
    private static final byte[] CODE_200_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 200 OK");
    private static final byte[] CODE_201_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 201 Created");
    private static final byte[] CODE_202_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 202 Accepted");
    private static final byte[] CODE_203_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 203 Non-Authoritative Information");
    private static final byte[] CODE_204_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 204 No Content");
    private static final byte[] CODE_205_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 205 Reset Content");
    private static final byte[] CODE_206_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 206 Partial Content");
    private static final byte[] CODE_207_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 207 Multi-Status");
    private static final byte[] CODE_208_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 208 Already Reported");
    private static final byte[] CODE_226_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 226 IM Used");
    private static final byte[] CODE_300_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 300 Multiple Choices");
    private static final byte[] CODE_301_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 301 Moved Permanently");
    private static final byte[] CODE_302_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 302 Found");
    private static final byte[] CODE_303_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 303 See Other");
    private static final byte[] CODE_304_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 304 Not Modified");
    private static final byte[] CODE_305_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 305 Use Proxy");
    private static final byte[] CODE_307_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 307 Temporary Redirect");
    private static final byte[] CODE_308_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 308 Permanent Redirect");
    private static final byte[] CODE_400_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 400 Bad Request");
    private static final byte[] CODE_401_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 401 Unauthorized");
    private static final byte[] CODE_402_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 402 Payment required");
    private static final byte[] CODE_403_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 403 Forbidden");
    private static final byte[] CODE_404_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 404 Not Found");
    private static final byte[] CODE_405_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 405 Method Not Allowed");
    private static final byte[] CODE_406_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 406 Not Acceptable");
    private static final byte[] CODE_407_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 407 Proxy Authentication Required");
    private static final byte[] CODE_408_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 408 Request Timeout");
    private static final byte[] CODE_409_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 409 Conflict");
    private static final byte[] CODE_410_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 410 Gone");
    private static final byte[] CODE_411_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 411 Length Required");
    private static final byte[] CODE_412_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 412 Precondition Failed");
    private static final byte[] CODE_413_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 413 Payload Too Large");
    private static final byte[] CODE_414_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 414 URI Too Long");
    private static final byte[] CODE_415_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 415 Unsupported Media Type");
    private static final byte[] CODE_416_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 416 Range Not Satisfiable");
    private static final byte[] CODE_417_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 417 Expectation Failed");
    private static final byte[] CODE_421_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 421 Misdirected Request");
    private static final byte[] CODE_422_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 422 Unprocessable Entity");
    private static final byte[] CODE_423_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 423 Locked");
    private static final byte[] CODE_424_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 424 Failed Dependency");
    private static final byte[] CODE_425_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 425 Too Early");
    private static final byte[] CODE_426_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 426 Upgrade Required");
    private static final byte[] CODE_428_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 428 Precondition Required");
    private static final byte[] CODE_429_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 429 Too Many Requests");
    private static final byte[] CODE_431_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 431 Request Header Fields Too Large");
    private static final byte[] CODE_451_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 451 Unavailable For Legal Reasons");
    private static final byte[] CODE_500_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 500 Internal Server Error");
    private static final byte[] CODE_501_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 501 Not Implemented");
    private static final byte[] CODE_502_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 502 Bad Gateway");
    private static final byte[] CODE_503_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 503 Service Unavailable");
    private static final byte[] CODE_504_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 504 Gateway Timeout");
    private static final byte[] CODE_505_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 505 HTTP Version Not Supported");
    private static final byte[] CODE_506_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 506 Variant Also Negotiates");
    private static final byte[] CODE_507_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 507 Insufficient Storage");
    private static final byte[] CODE_508_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 508 Loop Detected");
    private static final byte[] CODE_510_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 510 Not Extended");
    private static final byte[] CODE_511_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 511 Network Authentication Required");
    private static final int LONGEST_FIRST_LINE_SIZE = CODE_511_BYTES.length;
    private final HttpClientConnection connection;
    private int code;
    @Nullable
    private Map<String, HttpCookie> parsedCookies;

    HttpResponse(HttpVersion version, int code, @Nullable HttpClientConnection connection) {
        super(version);
        this.code = code;
        this.connection = connection;
    }

    HttpResponse(HttpVersion version, int code) {
        this(version, code, null);
    }

    public static Builder builder() {
        return new HttpResponse(HttpVersion.HTTP_1_1, 0).new Builder();
    }

    public static Builder ofCode(int code) {
        return HttpResponse.builder().withCode(code);
    }

    public static Builder ok200() {
        return HttpResponse.ofCode(200);
    }

    public static Builder ok201() {
        return HttpResponse.ofCode(201);
    }

    public static Builder ok206() {
        return HttpResponse.ofCode(206);
    }

    public static Builder redirect301(String url) {
        return (Builder)HttpResponse.ofCode(301).withHeader(HttpHeaders.LOCATION, url);
    }

    public static Builder redirect302(String url) {
        return (Builder)HttpResponse.ofCode(302).withHeader(HttpHeaders.LOCATION, url);
    }

    public static Builder redirect307(String url) {
        return (Builder)HttpResponse.ofCode(307).withHeader(HttpHeaders.LOCATION, url);
    }

    public static Builder redirect308(String url) {
        return (Builder)HttpResponse.ofCode(308).withHeader(HttpHeaders.LOCATION, url);
    }

    public static Builder unauthorized401(String challenge) {
        return (Builder)HttpResponse.ofCode(401).withHeader(HttpHeaders.WWW_AUTHENTICATE, challenge);
    }

    public static Builder notFound404() {
        return HttpResponse.ofCode(404);
    }

    public Promise<HttpResponse> toPromise() {
        return Promise.of((Object)this);
    }

    @Override
    boolean isContentLengthExpected() {
        return true;
    }

    public HttpClientConnection getConnection() {
        return this.connection;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, HttpCookie> getCookies() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.parsedCookies != null) {
            return this.parsedCookies;
        }
        LinkedHashMap<String, HttpCookie> cookies = new LinkedHashMap<String, HttpCookie>();
        for (HttpCookie cookie : this.getHeader(HttpHeaders.SET_COOKIE, HttpHeaderValue::toFullCookies)) {
            cookies.put(cookie.getName(), cookie);
        }
        this.parsedCookies = cookies;
        return this.parsedCookies;
    }

    @Nullable
    public HttpCookie getCookie(String cookie) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.getCookies().get(cookie);
    }

    private static void writeCodeMessage(ByteBuf buf, int code) {
        byte[] result;
        switch (code) {
            case 100: {
                result = CODE_100_BYTES;
                break;
            }
            case 101: {
                result = CODE_101_BYTES;
                break;
            }
            case 102: {
                result = CODE_102_BYTES;
                break;
            }
            case 103: {
                result = CODE_103_BYTES;
                break;
            }
            case 200: {
                result = CODE_200_BYTES;
                break;
            }
            case 201: {
                result = CODE_201_BYTES;
                break;
            }
            case 202: {
                result = CODE_202_BYTES;
                break;
            }
            case 203: {
                result = CODE_203_BYTES;
                break;
            }
            case 204: {
                result = CODE_204_BYTES;
                break;
            }
            case 205: {
                result = CODE_205_BYTES;
                break;
            }
            case 206: {
                result = CODE_206_BYTES;
                break;
            }
            case 207: {
                result = CODE_207_BYTES;
                break;
            }
            case 208: {
                result = CODE_208_BYTES;
                break;
            }
            case 226: {
                result = CODE_226_BYTES;
                break;
            }
            case 300: {
                result = CODE_300_BYTES;
                break;
            }
            case 301: {
                result = CODE_301_BYTES;
                break;
            }
            case 302: {
                result = CODE_302_BYTES;
                break;
            }
            case 303: {
                result = CODE_303_BYTES;
                break;
            }
            case 304: {
                result = CODE_304_BYTES;
                break;
            }
            case 305: {
                result = CODE_305_BYTES;
                break;
            }
            case 307: {
                result = CODE_307_BYTES;
                break;
            }
            case 308: {
                result = CODE_308_BYTES;
                break;
            }
            case 400: {
                result = CODE_400_BYTES;
                break;
            }
            case 401: {
                result = CODE_401_BYTES;
                break;
            }
            case 402: {
                result = CODE_402_BYTES;
                break;
            }
            case 403: {
                result = CODE_403_BYTES;
                break;
            }
            case 404: {
                result = CODE_404_BYTES;
                break;
            }
            case 405: {
                result = CODE_405_BYTES;
                break;
            }
            case 406: {
                result = CODE_406_BYTES;
                break;
            }
            case 407: {
                result = CODE_407_BYTES;
                break;
            }
            case 408: {
                result = CODE_408_BYTES;
                break;
            }
            case 409: {
                result = CODE_409_BYTES;
                break;
            }
            case 410: {
                result = CODE_410_BYTES;
                break;
            }
            case 411: {
                result = CODE_411_BYTES;
                break;
            }
            case 412: {
                result = CODE_412_BYTES;
                break;
            }
            case 413: {
                result = CODE_413_BYTES;
                break;
            }
            case 414: {
                result = CODE_414_BYTES;
                break;
            }
            case 415: {
                result = CODE_415_BYTES;
                break;
            }
            case 416: {
                result = CODE_416_BYTES;
                break;
            }
            case 417: {
                result = CODE_417_BYTES;
                break;
            }
            case 421: {
                result = CODE_421_BYTES;
                break;
            }
            case 422: {
                result = CODE_422_BYTES;
                break;
            }
            case 423: {
                result = CODE_423_BYTES;
                break;
            }
            case 424: {
                result = CODE_424_BYTES;
                break;
            }
            case 425: {
                result = CODE_425_BYTES;
                break;
            }
            case 426: {
                result = CODE_426_BYTES;
                break;
            }
            case 428: {
                result = CODE_428_BYTES;
                break;
            }
            case 429: {
                result = CODE_429_BYTES;
                break;
            }
            case 431: {
                result = CODE_431_BYTES;
                break;
            }
            case 451: {
                result = CODE_451_BYTES;
                break;
            }
            case 500: {
                result = CODE_500_BYTES;
                break;
            }
            case 501: {
                result = CODE_501_BYTES;
                break;
            }
            case 502: {
                result = CODE_502_BYTES;
                break;
            }
            case 503: {
                result = CODE_503_BYTES;
                break;
            }
            case 504: {
                result = CODE_504_BYTES;
                break;
            }
            case 505: {
                result = CODE_505_BYTES;
                break;
            }
            case 506: {
                result = CODE_506_BYTES;
                break;
            }
            case 507: {
                result = CODE_507_BYTES;
                break;
            }
            case 508: {
                result = CODE_508_BYTES;
                break;
            }
            case 510: {
                result = CODE_510_BYTES;
                break;
            }
            case 511: {
                result = CODE_511_BYTES;
                break;
            }
            default: {
                HttpResponse.writeCodeMessage2(buf, code);
                return;
            }
        }
        buf.put(result);
    }

    private static void writeCodeMessage2(ByteBuf buf, int code) {
        buf.put(HTTP11_BYTES);
        ByteBufStrings.putPositiveInt((ByteBuf)buf, (int)code);
        if (code >= 400) {
            buf.put(CODE_ERROR_BYTES);
        } else {
            buf.put(CODE_OK_BYTES);
        }
    }

    @Override
    protected int estimateSize() {
        return this.estimateSize(LONGEST_FIRST_LINE_SIZE);
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        HttpResponse.writeCodeMessage(buf, this.code);
        this.writeHeaders(buf);
    }

    public String toString() {
        if (this.isRecycled()) {
            return "{Recycled HttpResponse}";
        }
        return HttpResponse.class.getSimpleName() + ": " + this.code;
    }

    public final class Builder
    extends HttpMessage.Builder<Builder, HttpResponse> {
        private Builder() {
            super(HttpResponse.this);
        }

        public Builder withCode(int code) {
            if (CHECKS) {
                Checks.checkArgument((code >= 100 && code < 600 ? 1 : 0) != 0, (Object)"Code should be in range [100, 600)");
            }
            HttpResponse.this.code = code;
            return this;
        }

        public Builder withPlainText(String text) {
            return (Builder)((Builder)this.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.PLAIN_TEXT_UTF_8))).withBody(text.getBytes(StandardCharsets.UTF_8));
        }

        public Builder withHtml(String text) {
            return (Builder)((Builder)this.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.HTML_UTF_8))).withBody(text.getBytes(StandardCharsets.UTF_8));
        }

        public Builder withJson(String text) {
            return (Builder)((Builder)this.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.JSON_UTF_8))).withBody(text.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        protected void addCookies(List<HttpCookie> cookies) {
            for (HttpCookie cookie : cookies) {
                this.addCookie(cookie);
            }
        }

        @Override
        protected void addCookie(HttpCookie cookie) {
            HttpResponse.this.headers.add(HttpHeaders.SET_COOKIE, new HttpHeaderValue.HttpHeaderValueOfSetCookies(cookie));
        }

        @Override
        public HttpResponse build() {
            HttpResponse httpResponse = (HttpResponse)super.build();
            Checks.checkArgument((httpResponse.code > 0 ? 1 : 0) != 0);
            return httpResponse;
        }
    }
}

