/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.exception.AsyncTimeoutException;
import io.activej.common.ApplicationSettings;
import io.activej.common.MemSize;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.http.AsyncServlet;
import io.activej.http.ConnectionsLinkedList;
import io.activej.http.HttpExceptionFormatter;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpServerConnection;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import io.activej.http.PoolLabel;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.net.AbstractReactiveServer;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettableCallback;
import io.activej.promise.SettablePromise;
import io.activej.reactor.Reactor;
import io.activej.reactor.nio.NioReactor;
import io.activej.reactor.schedule.ScheduledRunnable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class HttpServer
extends AbstractReactiveServer {
    public static final Duration READ_WRITE_TIMEOUT = ApplicationSettings.getDuration(HttpServer.class, (String)"readWriteTimeout", (Duration)Duration.ZERO);
    public static final Duration READ_WRITE_TIMEOUT_SHUTDOWN = ApplicationSettings.getDuration(HttpServer.class, (String)"readWriteTimeout_Shutdown", (Duration)Duration.ofSeconds(3L));
    public static final Duration SERVE_TIMEOUT_SHUTDOWN = ApplicationSettings.getDuration(HttpServer.class, (String)"serveTimeout_Shutdown", (Duration)Duration.ofSeconds(0L));
    public static final Duration KEEP_ALIVE_TIMEOUT = ApplicationSettings.getDuration(HttpServer.class, (String)"keepAliveTimeout", (Duration)Duration.ofSeconds(30L));
    public static final MemSize MAX_BODY_SIZE = ApplicationSettings.getMemSize(HttpServer.class, (String)"maxBodySize", (MemSize)MemSize.ZERO);
    public static final MemSize MAX_WEB_SOCKET_MESSAGE_SIZE = ApplicationSettings.getMemSize(HttpServer.class, (String)"maxWebSocketMessageSize", (MemSize)MemSize.megabytes((long)1L));
    public static final int MAX_KEEP_ALIVE_REQUESTS = ApplicationSettings.getInt(HttpServer.class, (String)"maxKeepAliveRequests", (Integer)0);
    private final AsyncServlet servlet;
    private HttpExceptionFormatter errorFormatter = HttpExceptionFormatter.COMMON_FORMATTER;
    int readWriteTimeoutMillis = (int)READ_WRITE_TIMEOUT.toMillis();
    int readWriteTimeoutMillisShutdown = (int)READ_WRITE_TIMEOUT_SHUTDOWN.toMillis();
    int serveTimeoutMillisShutdown = (int)SERVE_TIMEOUT_SHUTDOWN.toMillis();
    int keepAliveTimeoutMillis = (int)KEEP_ALIVE_TIMEOUT.toMillis();
    int maxBodySize = MAX_BODY_SIZE.toInt();
    int maxWebSocketMessageSize = MAX_WEB_SOCKET_MESSAGE_SIZE.toInt();
    int maxKeepAliveRequests = MAX_KEEP_ALIVE_REQUESTS;
    final ConnectionsLinkedList poolNew = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolReadWrite = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolServing = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolKeepAlive = new ConnectionsLinkedList();
    private int poolKeepAliveExpired;
    private int poolReadWriteExpired;
    @Nullable
    private ScheduledRunnable expiredConnectionsCheck;
    @Nullable
    Inspector inspector;
    private final SettablePromise<@Nullable Void> closeNotification = new SettablePromise();
    @Nullable
    private SettableCallback<Void> closeCallback;

    private HttpServer(NioReactor reactor, AsyncServlet servlet) {
        super(reactor);
        this.servlet = servlet;
    }

    public static Builder builder(NioReactor reactor, AsyncServlet servlet) {
        return new HttpServer(reactor, servlet).new Builder();
    }

    public Duration getKeepAliveTimeout() {
        return Duration.ofMillis(this.keepAliveTimeoutMillis);
    }

    public Duration getReadWriteTimeout() {
        return Duration.ofMillis(this.readWriteTimeoutMillis);
    }

    public Promise<Void> getCloseNotification() {
        return this.closeNotification;
    }

    private void scheduleExpiredConnectionsCheck() {
        assert (this.expiredConnectionsCheck == null);
        this.expiredConnectionsCheck = this.reactor.delayBackground(1000L, () -> {
            boolean isClosing;
            this.expiredConnectionsCheck = null;
            boolean bl = isClosing = this.closeCallback != null;
            if (this.readWriteTimeoutMillis != 0 || isClosing) {
                this.poolReadWriteExpired += this.poolNew.closeExpiredConnections(this.reactor.currentTimeMillis() - (long)(!isClosing ? this.readWriteTimeoutMillis : this.readWriteTimeoutMillisShutdown));
                this.poolReadWriteExpired += this.poolReadWrite.closeExpiredConnections(this.reactor.currentTimeMillis() - (long)(!isClosing ? this.readWriteTimeoutMillis : this.readWriteTimeoutMillisShutdown), new AsyncTimeoutException("Read timeout"));
            }
            this.poolKeepAliveExpired += this.poolKeepAlive.closeExpiredConnections(this.reactor.currentTimeMillis() - (long)this.keepAliveTimeoutMillis);
            if (this.getConnectionsCount() != 0) {
                this.scheduleExpiredConnectionsCheck();
                if (isClosing) {
                    this.logger.info("...Waiting for {}", (Object)this);
                }
            }
        });
    }

    protected void serve(ITcpSocket socket, InetAddress remoteAddress) {
        if (this.expiredConnectionsCheck == null) {
            this.scheduleExpiredConnectionsCheck();
        }
        HttpServerConnection connection = new HttpServerConnection((Reactor)this.reactor, socket, remoteAddress, this, this.servlet);
        connection.serve();
    }

    void onConnectionClosed() {
        if (this.getConnectionsCount() == 0 && this.closeCallback != null) {
            this.closeCallback.set(null);
            this.closeCallback = null;
        }
    }

    protected void onClose(SettableCallback<@Nullable Void> cb) {
        this.closeNotification.set(null);
        this.poolKeepAlive.closeAllConnections();
        this.keepAliveTimeoutMillis = 0;
        if (this.getConnectionsCount() == 0) {
            cb.set(null);
        } else {
            if (!this.poolServing.isEmpty() && this.serveTimeoutMillisShutdown != 0) {
                this.reactor.delayBackground((long)this.serveTimeoutMillisShutdown, this.poolServing::closeAllConnections);
            }
            this.closeCallback = cb;
            this.logger.info("Waiting for {}", (Object)this);
        }
    }

    public List<String> getHttpAddresses() {
        return HttpUtils.getHttpAddresses(this);
    }

    Promise<HttpResponse> formatHttpError(Exception e) {
        return this.errorFormatter.formatException(e);
    }

    @JmxAttribute(description="current number of connections", reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsCount() {
        return this.poolNew.size() + this.poolKeepAlive.size() + this.poolReadWrite.size() + this.poolServing.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsNewCount() {
        return this.poolNew.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteCount() {
        return this.poolReadWrite.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsServingCount() {
        return this.poolServing.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveCount() {
        return this.poolKeepAlive.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveExpired() {
        return this.poolKeepAliveExpired;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteExpired() {
        return this.poolReadWriteExpired;
    }

    @JmxAttribute(name="")
    @Nullable
    public JmxInspector getStats() {
        return (JmxInspector)BaseInspector.lookup((BaseInspector)this.inspector, JmxInspector.class);
    }

    public String toString() {
        return "HttpServer{new:" + this.poolNew.size() + " read/write:" + this.poolReadWrite.size() + " serving:" + this.poolServing.size() + " keep-alive:" + this.poolKeepAlive.size() + "}";
    }

    public final class Builder
    extends AbstractReactiveServer.Builder<Builder, HttpServer> {
        private Builder() {
            super((AbstractReactiveServer)HttpServer.this);
        }

        public Builder withKeepAliveTimeout(Duration keepAliveTime) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.keepAliveTimeoutMillis = (int)keepAliveTime.toMillis();
            return this;
        }

        public Builder withMaxKeepAliveRequests(int maxKeepAliveRequests) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.maxKeepAliveRequests = maxKeepAliveRequests;
            return this;
        }

        public Builder withNoKeepAlive() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withKeepAliveTimeout(Duration.ZERO);
        }

        public Builder withReadWriteTimeout(Duration readWriteTimeout) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
            return this;
        }

        public Builder withReadWriteTimeout(Duration readWriteTimeout, Duration readWriteTimeoutShutdown) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
            HttpServer.this.readWriteTimeoutMillisShutdown = (int)readWriteTimeoutShutdown.toMillis();
            return this;
        }

        public Builder withServeTimeoutShutdown(Duration serveTimeoutShutdown) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.serveTimeoutMillisShutdown = (int)serveTimeoutShutdown.toMillis();
            return this;
        }

        public Builder withMaxBodySize(MemSize maxBodySize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withMaxBodySize(maxBodySize.toInt());
        }

        public Builder withMaxBodySize(int maxBodySize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.maxBodySize = maxBodySize;
            return this;
        }

        public Builder withMaxWebSocketMessageSize(MemSize maxWebSocketMessageSize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.maxWebSocketMessageSize = maxWebSocketMessageSize.toInt();
            return this;
        }

        public Builder withHttpErrorFormatter(HttpExceptionFormatter httpExceptionFormatter) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.errorFormatter = httpExceptionFormatter;
            return this;
        }

        public Builder withInspector(Inspector inspector) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpServer.this.inspector = inspector;
            return this;
        }
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onAccept(HttpServerConnection var1);

        public void onHttpRequest(HttpRequest var1);

        public void onHttpResponse(HttpRequest var1, HttpResponse var2);

        public void onHttpResponseComplete(HttpServerConnection var1);

        public void onServletException(HttpRequest var1, Exception var2);

        public void onHttpError(HttpServerConnection var1, Exception var2);

        public void onMalformedHttpRequest(HttpServerConnection var1, MalformedHttpException var2, byte[] var3);

        public void onDisconnect(HttpServerConnection var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final EventStats totalConnections = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats totalRequests = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats totalResponses = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats httpTimeouts = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats httpErrors = ExceptionStats.create();
        private final ExceptionStats malformedHttpExceptions = ExceptionStats.create();
        private final ExceptionStats servletExceptions = ExceptionStats.create();
        private int activeConnections;
        private int activeRequests;

        @Override
        public void onAccept(HttpServerConnection connection) {
            this.totalConnections.recordEvent();
            ++this.activeConnections;
        }

        @Override
        public void onHttpRequest(HttpRequest request) {
            ++this.activeRequests;
            this.totalRequests.recordEvent();
        }

        @Override
        public void onHttpResponse(HttpRequest request, HttpResponse httpResponse) {
            this.totalResponses.recordEvent();
        }

        @Override
        public void onServletException(HttpRequest request, Exception e) {
            HttpServerConnection connection = request.getConnection();
            InetAddress remoteAddress = connection.getRemoteAddress();
            this.servletExceptions.recordException((Throwable)e, (Object)(remoteAddress + ": " + request));
        }

        @Override
        public void onHttpError(HttpServerConnection connection, Exception e) {
            this.tryDecrementActiveRequests(connection);
            if (e instanceof AsyncTimeoutException) {
                this.httpTimeouts.recordEvent();
            } else {
                InetAddress remoteAddress = connection.getRemoteAddress();
                this.httpErrors.recordException((Throwable)e, (Object)remoteAddress);
            }
        }

        @Override
        public void onMalformedHttpRequest(HttpServerConnection connection, MalformedHttpException e, byte[] malformedRequestBytes) {
            this.tryDecrementActiveRequests(connection);
            String requestString = new String(malformedRequestBytes, StandardCharsets.ISO_8859_1);
            InetAddress remoteAddress = connection.getRemoteAddress();
            this.malformedHttpExceptions.recordException((Throwable)e, (Object)(remoteAddress + ": " + requestString));
        }

        @Override
        public void onDisconnect(HttpServerConnection connection) {
            --this.activeConnections;
        }

        @Override
        public void onHttpResponseComplete(HttpServerConnection httpServerConnection) {
            --this.activeRequests;
        }

        private void tryDecrementActiveRequests(HttpServerConnection connection) {
            HttpRequest request;
            PoolLabel pool = connection.getCurrentPool();
            if (pool == PoolLabel.SERVING) {
                --this.activeRequests;
            }
            if (pool == PoolLabel.READ_WRITE && (request = connection.getRequest()) != null && request.isRemoteAddressSet()) {
                --this.activeRequests;
            }
        }

        @JmxAttribute(extraSubAttributes={"totalCount"})
        public EventStats getTotalConnections() {
            return this.totalConnections;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"})
        public EventStats getTotalRequests() {
            return this.totalRequests;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"})
        public EventStats getTotalResponses() {
            return this.totalResponses;
        }

        @JmxAttribute
        public EventStats getHttpTimeouts() {
            return this.httpTimeouts;
        }

        @JmxAttribute(description="Number of requests which were invalid according to http protocol. Responses were not sent for this requests")
        public ExceptionStats getHttpErrors() {
            return this.httpErrors;
        }

        @JmxAttribute
        public ExceptionStats getMalformedHttpExceptions() {
            return this.malformedHttpExceptions;
        }

        @JmxAttribute(description="Number of requests which were valid according to http protocol, but application produced error during handling this request (responses with 4xx and 5xx HTTP status codes)")
        public ExceptionStats getServletExceptions() {
            return this.servletExceptions;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getActiveConnections() {
            return this.activeConnections;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getActiveRequests() {
            return this.activeRequests;
        }
    }
}

