/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.callback.Callback;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.Utils;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.recycle.Recyclable;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.csp.supplier.ChannelSuppliers;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.AsyncServlet;
import io.activej.http.GzipProcessorUtils;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpMethod;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpServer;
import io.activej.http.HttpVersion;
import io.activej.http.IWebSocket;
import io.activej.http.MalformedHttpException;
import io.activej.http.PoolLabel;
import io.activej.http.Protocol;
import io.activej.http.UrlParser;
import io.activej.http.WebSocketConstants;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.net.socket.tcp.SslTcpSocket;
import io.activej.promise.Promise;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public final class HttpServerConnection
extends AbstractHttpConnection {
    private static final boolean CHECKS = Checks.isEnabled(HttpServerConnection.class);
    private static final int INITIAL_WRITE_BUFFER_SIZE = ApplicationSettings.getMemSize(HttpServerConnection.class, (String)"initialWriteBufferSize", (MemSize)MemSize.ZERO).toInt();
    private static final HttpMethod[] METHODS = new HttpMethod[128];
    private final InetAddress remoteAddress;
    private final HttpServer server;
    private final AsyncServlet servlet;
    @Nullable
    private HttpRequest request;
    @Nullable
    private final HttpServer.Inspector inspector;
    @Nullable
    private ByteBuf writeBuf;
    private static final byte[] EXPECT_100_CONTINUE;
    private static final byte[] EXPECT_RESPONSE_CONTINUE;
    private static final byte[] MALFORMED_HTTP_RESPONSE;

    HttpServerConnection(Reactor reactor, ITcpSocket socket, InetAddress remoteAddress, HttpServer server, AsyncServlet servlet) {
        super(reactor, socket, server.maxBodySize);
        this.remoteAddress = remoteAddress;
        this.server = server;
        this.servlet = servlet;
        this.inspector = server.inspector;
    }

    void serve() {
        if (this.inspector != null) {
            this.inspector.onAccept(this);
        }
        this.pool = this.server.poolNew;
        this.pool.addLastNode(this);
        this.poolTimestamp = this.reactor.currentTimeMillis();
        this.socket.read().subscribe((Callback)this.readMessageConsumer);
    }

    @Override
    public PoolLabel getCurrentPool() {
        if (this.pool == this.server.poolNew) {
            return PoolLabel.NEW;
        }
        if (this.pool == this.server.poolKeepAlive) {
            return PoolLabel.KEEP_ALIVE;
        }
        if (this.pool == this.server.poolReadWrite) {
            return PoolLabel.READ_WRITE;
        }
        if (this.pool == this.server.poolServing) {
            return PoolLabel.SERVING;
        }
        return PoolLabel.NONE;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nullable
    HttpRequest getRequest() {
        return this.request;
    }

    @Override
    protected void readMessage() throws MalformedHttpException {
        boolean continueReading;
        do {
            this.request = (HttpRequest)Utils.nullify((Object)this.request, HttpMessage::recycle);
            this.contentLength = 0L;
            this.flags = (byte)64;
            this.readStartLine();
            if (this.isClosed()) {
                return;
            }
            boolean bl = continueReading = (this.flags & 0x31) == 49 && this.readBuf != null;
            if (!continueReading || this.inspector == null) continue;
            this.inspector.onHttpResponseComplete(this);
        } while (continueReading);
        this.flags = (byte)(this.flags & 0xFFFFFFBF);
        if (this.writeBuf != null) {
            ByteBuf writeBuf = this.writeBuf;
            this.writeBuf = null;
            this.writeBuf(writeBuf);
        } else if ((this.flags & 0x30) == 48) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onClosedWithError(Exception e) {
        if (this.inspector != null) {
            this.inspector.onHttpError(this, e);
        }
    }

    @Override
    protected void onMalformedHttpException(MalformedHttpException e) {
        if (this.inspector != null) {
            this.inspector.onMalformedHttpRequest(this, e, this.readBuf == null ? EMPTY_BYTE_ARRAY : this.readBuf.getArray());
        }
        this.writeBuf = this.ensureWriteBuffer(MALFORMED_HTTP_RESPONSE.length);
        this.writeBuf.put(MALFORMED_HTTP_RESPONSE);
        ByteBuf writeBuf = this.writeBuf;
        this.writeBuf = null;
        this.socket.write(writeBuf).whenComplete(this::close);
    }

    @Override
    protected boolean isValidStartLinePrefix(byte[] line, int pos, int limit) {
        block0: for (HttpMethod method : HttpMethod.values()) {
            byte[] bytes = method.bytes();
            int end = Math.min(bytes.length, limit - pos);
            for (int i = 0; i < end; ++i) {
                if (line[pos + i] != bytes[i]) continue block0;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onStartLine(byte[] line, int pos, int limit) throws MalformedHttpException {
        HttpVersion version;
        int urlStart;
        int urlEnd;
        HttpMethod method;
        block11: {
            block12: {
                int p;
                this.switchPool(this.server.poolReadWrite);
                method = HttpServerConnection.getHttpMethod(line, pos);
                if (method == null) {
                    if (!DETAILED_ERROR_MESSAGES) {
                        throw new MalformedHttpException("Unknown HTTP method");
                    }
                    throw new MalformedHttpException("Unknown HTTP method. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
                }
                for (urlEnd = urlStart = pos + method.size + 1; urlEnd < limit && line[urlEnd] != 32; ++urlEnd) {
                }
                for (p = urlEnd + 1; p < limit && line[p] == 32; ++p) {
                }
                if (p + 7 >= limit || line[p + 0] != 72 || line[p + 1] != 84 || line[p + 2] != 84 || line[p + 3] != 80 || line[p + 4] != 47 || line[p + 5] != 49 || line[p + 6] != 46) break block12;
                if (line[p + 7] == 49) {
                    this.flags = (byte)(this.flags | 1);
                    version = HttpVersion.HTTP_1_1;
                    break block11;
                } else if (line[p + 7] == 48) {
                    version = HttpVersion.HTTP_1_0;
                    break block11;
                } else {
                    if (!DETAILED_ERROR_MESSAGES) {
                        throw new MalformedHttpException("Unknown HTTP version");
                    }
                    throw new MalformedHttpException("Unknown HTTP version. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
                }
            }
            if (!DETAILED_ERROR_MESSAGES) {
                throw new MalformedHttpException("Unsupported HTTP version");
            }
            throw new MalformedHttpException("Unsupported HTTP version. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
        }
        this.request = new HttpRequest(version, method, UrlParser.parse(line, urlStart, urlEnd), this);
        this.request.maxBodySize = this.maxBodySize;
        if (method == HttpMethod.GET || method == HttpMethod.DELETE) {
            this.contentLength = 0L;
        }
    }

    private static HttpMethod getHttpMethod(byte[] line, int pos) {
        boolean post;
        boolean get;
        boolean bl = get = line[pos] == 71 && line[pos + 1] == 69 && line[pos + 2] == 84 && (line[pos + 3] == 32 || line[pos + 3] == 9);
        if (get) {
            return HttpMethod.GET;
        }
        boolean bl2 = post = line[0] == 80 && line[1] == 79 && line[2] == 83 && line[3] == 84 && (line[4] == 32 || line[4] == 9);
        if (post) {
            return HttpMethod.POST;
        }
        return HttpServerConnection.getHttpMethodFromMap(line, pos);
    }

    private static HttpMethod getHttpMethodFromMap(byte[] line, int pos) {
        int hashCode = 0;
        for (int i = pos; i < Math.min(pos + 10, line.length); ++i) {
            byte b = line[i];
            if (b == 32 || b == 9) {
                int slot = hashCode & METHODS.length - 1;
                HttpMethod method = METHODS[slot];
                return method != null && method.compareTo(line, pos, i - pos) ? method : null;
            }
            hashCode += b;
        }
        return null;
    }

    @Override
    protected void onHeader(HttpHeader header, byte[] array, int off, int len) throws MalformedHttpException {
        if (header == HttpHeaders.EXPECT && ByteBufStrings.equalsLowerCaseAscii((byte[])EXPECT_100_CONTINUE, (byte[])array, (int)off, (int)len)) {
            this.socket.write(ByteBuf.wrapForReading((byte[])EXPECT_RESPONSE_CONTINUE));
        }
        if (this.request.headers.size() >= MAX_HEADERS) {
            throw new MalformedHttpException("Too many headers");
        }
        this.request.headers.add(header, HttpHeaderValue.ofBytes(array, off, len));
    }

    private void writeHttpResponse(HttpResponse httpResponse) {
        boolean isWebSocket;
        boolean bl = isWebSocket = IWebSocket.ENABLED && this.isWebSocket();
        if (!isWebSocket || httpResponse.getCode() != 101) {
            httpResponse.headers.addIfAbsent(HttpHeaders.CONNECTION, () -> {
                if ((this.flags & 1) == 0 || this.server.keepAliveTimeoutMillis == 0 || this.numberOfRequests >= this.server.maxKeepAliveRequests && this.server.maxKeepAliveRequests != 0) {
                    return CONNECTION_CLOSE_HEADER;
                }
                return CONNECTION_KEEP_ALIVE_HEADER;
            });
            if (isWebSocket) {
                this.flags = (byte)(this.flags & 0xFFFFFFF7);
            }
        }
        if (this.renderHttpResponse(httpResponse)) {
            if ((this.flags & 0x40) != 0) {
                this.flags = (byte)(this.flags | 0x20);
            } else {
                ByteBuf writeBuf = this.writeBuf;
                this.writeBuf = null;
                this.writeBuf(writeBuf);
            }
        } else {
            ByteBuf writeBuf = this.writeBuf;
            this.writeBuf = null;
            this.writeHttpMessageAsStream(writeBuf, httpResponse);
        }
    }

    boolean renderHttpResponse(HttpMessage httpMessage) {
        if (httpMessage.body != null) {
            ByteBuf body = httpMessage.body;
            httpMessage.body = null;
            if ((httpMessage.flags & 2) == 0) {
                httpMessage.headers.addIfAbsent(HttpHeaders.CONTENT_LENGTH, () -> HttpHeaderValue.ofDecimal(body.readRemaining()));
                int messageSize = httpMessage.estimateSize() + body.readRemaining();
                this.writeBuf = this.ensureWriteBuffer(messageSize);
                httpMessage.writeTo(this.writeBuf);
                this.writeBuf.put(body);
                body.recycle();
            } else {
                ByteBuf gzippedBody = GzipProcessorUtils.toGzip(body);
                httpMessage.headers.addIfAbsent(HttpHeaders.CONTENT_ENCODING, CONTENT_ENCODING_GZIP_HEADER);
                httpMessage.headers.addIfAbsent(HttpHeaders.CONTENT_LENGTH, () -> HttpHeaderValue.ofDecimal(gzippedBody.readRemaining()));
                int messageSize = httpMessage.estimateSize() + gzippedBody.readRemaining();
                this.writeBuf = this.ensureWriteBuffer(messageSize);
                httpMessage.writeTo(this.writeBuf);
                this.writeBuf.put(gzippedBody);
                gzippedBody.recycle();
            }
            return true;
        }
        if (httpMessage.bodyStream == null) {
            if (httpMessage.isContentLengthExpected()) {
                httpMessage.headers.addIfAbsent(HttpHeaders.CONTENT_LENGTH, ZERO_HEADER);
            }
            this.writeBuf = this.ensureWriteBuffer(httpMessage.estimateSize());
            httpMessage.writeTo(this.writeBuf);
            return true;
        }
        return false;
    }

    private ByteBuf ensureWriteBuffer(int messageSize) {
        return this.writeBuf == null ? ByteBufPool.allocate((int)Math.max(messageSize, INITIAL_WRITE_BUFFER_SIZE)) : ByteBufPool.ensureWriteRemaining((ByteBuf)this.writeBuf, (int)messageSize);
    }

    @Override
    protected void onHeadersReceived(@Nullable ByteBuf body, @Nullable ChannelSupplier<ByteBuf> bodySupplier) {
        Promise servletResult;
        assert (!this.isClosed());
        this.request.flags = (byte)(this.request.flags | 1);
        this.request.body = body;
        if (bodySupplier != null) {
            this.request.bodyStream = this.sanitize(bodySupplier);
            this.request.flags = (byte)(this.request.flags | ((this.flags & 2) != 0 ? 4 : 0));
        }
        if (IWebSocket.ENABLED && this.isWebSocket()) {
            if (!this.processWebSocketRequest(body)) {
                return;
            }
        } else {
            this.request.setProtocol(this.socket instanceof SslTcpSocket ? Protocol.HTTPS : Protocol.HTTP);
        }
        this.request.setRemoteAddress(this.remoteAddress);
        ++this.numberOfRequests;
        if (this.inspector != null) {
            this.inspector.onHttpRequest(this.request);
        }
        this.switchPool(this.server.poolServing);
        HttpRequest request = this.request;
        try {
            servletResult = this.servlet.serve(request);
        }
        catch (Exception e2) {
            FatalErrorHandler.handleError((Throwable)e2, (Object)((Object)this));
            servletResult = Promise.ofException((Exception)e2);
        }
        servletResult.subscribe((response, e) -> {
            if (CHECKS) {
                Reactive.checkInReactorThread((Reactive)this);
            }
            if (this.isClosed()) {
                request.recycle();
                this.readBuf = (ByteBuf)Utils.nullify((Object)this.readBuf, ByteBuf::recycle);
                this.stashedBufs = (Recyclable)Utils.nullify((Object)this.stashedBufs, Recyclable::recycle);
                if (response != null) {
                    response.recycleBody();
                }
                return;
            }
            this.switchPool(this.server.poolReadWrite);
            if (e == null) {
                if (this.inspector != null) {
                    this.inspector.onHttpResponse(request, (HttpResponse)response);
                }
                this.recycle();
                this.writeHttpResponse((HttpResponse)response);
            } else {
                if (this.inspector != null) {
                    this.inspector.onServletException(request, e);
                }
                this.recycle();
                this.writeException(e);
            }
        });
    }

    private void recycle() {
        if (this.stashedBufs != null) {
            this.stashedBufs.recycle();
            this.stashedBufs = null;
        }
        if (this.readBuf != null && !this.readBuf.canRead()) {
            this.readBuf.recycle();
            this.readBuf = null;
        }
        this.request.recycle();
    }

    private boolean processWebSocketRequest(@Nullable ByteBuf body) {
        if (body != null && body.readRemaining() == 0) {
            ChannelSupplier ofReadBufSupplier = ChannelSuppliers.ofValue((Object)this.detachReadBuf());
            ChannelSupplier ofSocketSupplier = ChannelSuppliers.ofSocket((ITcpSocket)this.socket);
            this.request.bodyStream = this.sanitize((ChannelSupplier<ByteBuf>)ChannelSuppliers.concat((ChannelSupplier)ofReadBufSupplier, (ChannelSupplier)ofSocketSupplier).withEndOfStream(eos -> eos.whenException(this::closeWebSocketConnection)));
            this.request.setProtocol(this.socket instanceof SslTcpSocket ? Protocol.WSS : Protocol.WS);
            this.request.maxBodySize = this.server.maxWebSocketMessageSize;
            return true;
        }
        this.closeEx(WebSocketConstants.UPGRADE_WITH_BODY);
        return false;
    }

    @Override
    protected void onBodyReceived() {
        assert (!this.isClosed());
        this.flags = (byte)(this.flags | 0x10);
        if ((this.flags & 0x70) == 48 && this.pool != this.server.poolServing) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onBodySent() {
        assert (!this.isClosed());
        this.flags = (byte)(this.flags | 0x20);
        if ((this.flags & 0x70) == 48 && this.pool != this.server.poolServing) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onNoContentLength() {
        throw new AssertionError((Object)"This method should not be called on a server");
    }

    private void onHttpMessageComplete() {
        assert (!this.isClosed());
        if (this.inspector != null) {
            this.inspector.onHttpResponseComplete(this);
        }
        if (IWebSocket.ENABLED && this.isWebSocket()) {
            return;
        }
        if ((this.flags & 1) != 0 && this.server.keepAliveTimeoutMillis != 0) {
            this.request = (HttpRequest)Utils.nullify((Object)this.request, HttpMessage::recycle);
            this.switchPool(this.server.poolKeepAlive);
            if (this.socket.isReadAvailable()) {
                this.socket.read().whenResult(buf -> {
                    this.readBuf = this.readBuf == null ? buf : ByteBufPool.append((ByteBuf)this.readBuf, (ByteBuf)buf);
                });
            }
            this.read();
        } else {
            this.close();
        }
    }

    private void writeException(Exception e) {
        this.server.formatHttpError(e).whenComplete(this::writeHttpResponse, this::closeEx);
    }

    @Override
    protected void onClosed() {
        if (this.pool != this.server.poolServing) {
            this.request = (HttpRequest)Utils.nullify((Object)this.request, HttpMessage::recycle);
            this.readBuf = (ByteBuf)Utils.nullify((Object)this.readBuf, ByteBuf::recycle);
            this.stashedBufs = (Recyclable)Utils.nullify((Object)this.stashedBufs, Recyclable::recycle);
        }
        if (this.inspector != null) {
            this.inspector.onDisconnect(this);
        }
        this.pool.removeNode(this);
        if (!$assertionsDisabled) {
            this.pool = null;
            if (null != null) {
                throw new AssertionError();
            }
        }
        this.server.onConnectionClosed();
        this.writeBuf = (ByteBuf)Utils.nullify((Object)this.writeBuf, ByteBuf::recycle);
    }

    @Override
    public String toString() {
        return "HttpServerConnection{pool=" + this.getCurrentPool() + ", remoteAddress=" + this.remoteAddress + "," + super.toString() + "}";
    }

    static {
        assert (Integer.bitCount(METHODS.length) == 1);
        for (HttpMethod httpMethod : HttpMethod.values()) {
            int hashCode = 0;
            for (int i = 0; i < httpMethod.bytes.length; ++i) {
                hashCode += httpMethod.bytes[i];
            }
            int slot = hashCode & METHODS.length - 1;
            if (METHODS[slot] != null) {
                throw new IllegalArgumentException("HTTP METHODS hash collision, try to increase METHODS size");
            }
            HttpServerConnection.METHODS[slot] = httpMethod;
        }
        EXPECT_100_CONTINUE = ByteBufStrings.encodeAscii((String)"100-continue");
        EXPECT_RESPONSE_CONTINUE = ByteBufStrings.encodeAscii((String)"HTTP/1.1 100 Continue\r\n\r\n");
        MALFORMED_HTTP_RESPONSE = ByteBufStrings.encodeAscii((String)"HTTP/1.1 400 Bad Request\r\nConnection: close\r\nContent-Length: 0\r\n\r\n");
    }
}

