/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.exception.MalformedDataException;
import io.activej.http.HttpException;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.IWebSocket;
import io.activej.http.MalformedHttpException;
import io.activej.http.WebSocketConstants;
import io.activej.net.AbstractReactiveServer;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class HttpUtils {
    private static final int URI_DEFAULT_CAPACITY = 32;
    private static final int LIMIT_INT = 0xCCCCCCC;
    private static final int REMAINDER_INT = 7;
    private static final long LIMIT_LONG = 0xCCCCCCCCCCCCCCCL;
    private static final long REMAINDER_LONG = 7L;
    static final byte EQUALS = 61;
    static final byte SEMICOLON = 59;
    static final byte COLON = 58;
    static final byte Q = 113;
    static final byte DOT = 46;
    static final byte ZERO = 48;
    static final byte COMMA = 44;

    public static InetAddress inetAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isInetAddress(String host) {
        int colons = 0;
        int dots = 0;
        byte[] bytes = ByteBufStrings.encodeAscii((String)host);
        if (bytes[0] == 91) {
            return bytes[bytes.length - 1] == 93 && HttpUtils.checkIpv6(bytes, 1, bytes.length - 1);
        }
        for (byte b : bytes) {
            if (b == 46) {
                ++dots;
                continue;
            }
            if (b == 58) {
                if (dots != 0) {
                    return false;
                }
                ++colons;
                continue;
            }
            if (Character.digit(b, 16) != -1) continue;
            return false;
        }
        if (dots < 4) {
            if (colons > 0 && colons < 8) {
                return HttpUtils.checkIpv6(bytes, 0, bytes.length);
            }
            return HttpUtils.checkIpv4(bytes, 0, bytes.length);
        }
        return false;
    }

    private static boolean checkIpv4(byte[] bytes, int pos, int length) {
        int start = pos;
        for (int i = pos; i < length; ++i) {
            int v;
            if (i == length - 1 && bytes[i] == 46) {
                return false;
            }
            if (bytes[i] != 46 && i != length - 1) continue;
            if (i - start == 0 && i != length - 1) {
                return false;
            }
            try {
                v = HttpUtils.trimAndDecodePositiveInt(bytes, start, i - start);
            }
            catch (MalformedHttpException e) {
                return false;
            }
            if (v < 0 || v > 255) {
                return false;
            }
            start = i + 1;
        }
        return true;
    }

    private static boolean checkIpv6(byte[] bytes, int pos, int length) {
        boolean shortHand = false;
        int numCount = 0;
        int blocksCount = 0;
        int start = 0;
        while (pos < length) {
            if (bytes[pos] == 58) {
                start = pos;
                ++blocksCount;
                numCount = 0;
                if (pos > 0 && bytes[pos - 1] == 58) {
                    if (shortHand) {
                        return false;
                    }
                    shortHand = true;
                }
            } else {
                if (bytes[pos] == 46) {
                    return HttpUtils.checkIpv4(bytes, start + 1, length - start + 1);
                }
                if (Character.digit(bytes[pos], 16) == -1) {
                    return false;
                }
                if (++numCount > 4) {
                    return false;
                }
            }
            ++pos;
        }
        return blocksCount > 6 || shortHand;
    }

    public static int skipSpaces(byte[] bytes, int pos, int end) {
        while (pos < end && bytes[pos] == 32) {
            ++pos;
        }
        return pos;
    }

    public static int decodeQ(byte[] bytes, int pos, int length) throws MalformedHttpException {
        if (length == 0) {
            return 100;
        }
        if (bytes[pos] == 49) {
            return 100;
        }
        if (bytes[pos] == 48) {
            if (length == 1) {
                return 0;
            }
            length = length > 4 ? 2 : length - 2;
            int q = HttpUtils.trimAndDecodePositiveInt(bytes, pos + 2, length);
            if (length == 1) {
                q *= 10;
            }
            return q;
        }
        throw new MalformedHttpException("Value of 'q' should start either from 0 or 1");
    }

    public static String renderQueryString(Map<String, String> q) {
        return HttpUtils.renderQueryString(q, "UTF-8");
    }

    public static String renderQueryString(Map<String, String> q, String enc) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : q.entrySet()) {
            String name = HttpUtils.urlEncode(e.getKey(), enc);
            sb.append(name);
            if (e.getValue() != null) {
                sb.append('=');
                sb.append(HttpUtils.urlEncode(e.getValue(), enc));
            }
            sb.append('&');
        }
        if (!sb.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String urlEncode(String string, String enc) {
        try {
            return URLEncoder.encode(string, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Can't encode with supplied encoding: " + enc, e);
        }
    }

    public static String urlDecode(@Nullable String string, String enc) throws MalformedHttpException {
        if (string == null) {
            throw new MalformedHttpException("No string to decode");
        }
        try {
            return URLDecoder.decode(string, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedHttpException("Can't encode with supplied encoding: " + enc, e);
        }
    }

    public static int trimAndDecodePositiveInt(byte[] array, int pos, int len) throws MalformedHttpException {
        int left = HttpUtils.trimLeft(array, pos, len);
        len -= left;
        len -= HttpUtils.trimRight(array, pos += left, len);
        return HttpUtils.decodePositiveInt(array, pos, len);
    }

    public static long trimAndDecodePositiveLong(byte[] array, int pos, int len) throws MalformedHttpException {
        int left = HttpUtils.trimLeft(array, pos, len);
        len -= left;
        len -= HttpUtils.trimRight(array, pos += left, len);
        return HttpUtils.decodePositiveLong(array, pos, len);
    }

    private static int trimLeft(byte[] array, int pos, int len) {
        for (int i = 0; i < len; ++i) {
            if (array[pos + i] == 32 || array[pos + i] == 9) continue;
            return i;
        }
        return 0;
    }

    private static int trimRight(byte[] array, int pos, int len) {
        for (int i = len - 1; i >= 0; --i) {
            if (array[pos + i] == 32 || array[pos + i] == 9) continue;
            return len - i - 1;
        }
        return 0;
    }

    @Nullable
    public static String getFullUri(HttpRequest request, int builderCapacity) {
        String host;
        String string = host = request.getUrl().isRelativePath() ? request.getHeader(HttpHeaders.HOST) : request.getHostAndPort();
        if (host == null) {
            return null;
        }
        String query = request.getQuery();
        String fragment = request.getFragment();
        StringBuilder fullUriBuilder = new StringBuilder(builderCapacity).append(request.getProtocol().lowercase()).append("://").append(host).append(request.getPath());
        if (!query.isEmpty()) {
            fullUriBuilder.append("?").append(query);
        }
        if (!fragment.isEmpty()) {
            fullUriBuilder.append("#").append(fragment);
        }
        return fullUriBuilder.toString();
    }

    @Nullable
    public static String getFullUri(HttpRequest request) {
        return HttpUtils.getFullUri(request, 32);
    }

    public static String getHttpErrorTitle(int code) {
        return switch (code) {
            case 400 -> "400. Bad Request";
            case 402 -> "402. Payment Required";
            case 403 -> "403. Forbidden";
            case 404 -> "404. Not Found";
            case 405 -> "405. Method Not Allowed";
            case 406 -> "406. Not Acceptable";
            case 408 -> "408. Request Timeout";
            case 409 -> "409. Conflict";
            case 410 -> "410. Gone";
            case 411 -> "411. Length Required";
            case 413 -> "413. Payload Too Large";
            case 414 -> "414. URI Too Long";
            case 415 -> "415. Unsupported Media Type";
            case 417 -> "417. Expectation Failed";
            case 426 -> "426. Upgrade Required";
            case 500 -> "500. Internal Server Error";
            case 501 -> "501. Not Implemented";
            case 502 -> "502. Bad Gateway";
            case 503 -> "503. Service Unavailable";
            case 504 -> "504. Gateway Timeout";
            case 505 -> "505. HTTP Version Not Supported";
            default -> code + ". Unknown HTTP code, returned from an error";
        };
    }

    public static String formatUrl(InetSocketAddress address, boolean ssl) {
        return (ssl ? "https://" : "http://") + HttpUtils.formatHost(address.getAddress()) + (String)(address.getPort() != (ssl ? 443 : 80) ? ":" + address.getPort() : "") + "/";
    }

    public static List<String> getHttpAddresses(AbstractReactiveServer server) {
        return Stream.concat(server.getBoundAddresses().stream().map(address -> HttpUtils.formatUrl(address, false)), server.getSslBoundAddresses().stream().map(address -> HttpUtils.formatUrl(address, true))).collect(Collectors.toList());
    }

    private static String formatHost(InetAddress address) {
        String name = address.getHostName();
        if (address instanceof Inet4Address) {
            return name;
        }
        if (address instanceof Inet6Address && name.contains(":")) {
            return "[" + name + "]";
        }
        return name;
    }

    static String getWebSocketAnswer(String key) {
        String answer;
        try {
            answer = Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA-1").digest((key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return answer;
    }

    static byte[] generateWebSocketKey() {
        byte[] key = new byte[16];
        ThreadLocalRandom.current().nextBytes(key);
        return Base64.getEncoder().encode(key);
    }

    static boolean isAnswerInvalid(HttpResponse response, byte[] key) {
        String header = response.getHeader(HttpHeaders.SEC_WEBSOCKET_ACCEPT);
        return header == null || !HttpUtils.getWebSocketAnswer(new String(key, StandardCharsets.ISO_8859_1)).equals(header.trim());
    }

    static boolean isReservedCloseCode(int closeCode) {
        return closeCode < 1000 || closeCode >= 1004 && closeCode < 1007 || closeCode >= 1015 && closeCode < 3000;
    }

    static String getUTF8(ByteBuf buf) throws CharacterCodingException {
        return StandardCharsets.UTF_8.newDecoder().decode(buf.toReadByteBuffer()).toString();
    }

    static WebSocketConstants.OpCode frameToOpType(IWebSocket.Frame.FrameType frameType) {
        return switch (frameType) {
            default -> throw new IncompatibleClassChangeError();
            case IWebSocket.Frame.FrameType.TEXT -> WebSocketConstants.OpCode.OP_TEXT;
            case IWebSocket.Frame.FrameType.BINARY -> WebSocketConstants.OpCode.OP_BINARY;
            case IWebSocket.Frame.FrameType.CONTINUATION -> WebSocketConstants.OpCode.OP_CONTINUATION;
        };
    }

    static IWebSocket.Frame.FrameType opToFrameType(WebSocketConstants.OpCode opType) {
        return switch (opType) {
            case WebSocketConstants.OpCode.OP_TEXT -> IWebSocket.Frame.FrameType.TEXT;
            case WebSocketConstants.OpCode.OP_BINARY -> IWebSocket.Frame.FrameType.BINARY;
            case WebSocketConstants.OpCode.OP_CONTINUATION -> IWebSocket.Frame.FrameType.CONTINUATION;
            default -> throw new AssertionError();
        };
    }

    static IWebSocket.Message.MessageType frameToMessageType(IWebSocket.Frame.FrameType frameType) {
        return switch (frameType) {
            case IWebSocket.Frame.FrameType.TEXT -> IWebSocket.Message.MessageType.TEXT;
            case IWebSocket.Frame.FrameType.BINARY -> IWebSocket.Message.MessageType.BINARY;
            default -> throw new AssertionError();
        };
    }

    static Exception translateToHttpException(Exception e) {
        if (e instanceof HttpException) {
            return e;
        }
        if (e instanceof MalformedDataException) {
            return new MalformedHttpException(e);
        }
        return new HttpException(e);
    }

    static int decodePositiveInt(byte[] array, int pos, int len) throws MalformedHttpException {
        int result = 0;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedHttpException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if (result >= 0xCCCCCCC && (result != 0xCCCCCCC || b > 7)) {
                throw new MalformedHttpException("Bigger than max int value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            result = b + result * 10;
        }
        return result;
    }

    static long decodePositiveLong(byte[] array, int pos, int len) throws MalformedHttpException {
        long result = 0L;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedHttpException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if (result >= 0xCCCCCCCCCCCCCCCL && (result != 0xCCCCCCCCCCCCCCCL || (long)b > 7L)) {
                throw new MalformedHttpException("Bigger than max long value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            result = (long)b + result * 10L;
        }
        return result;
    }

    static int hashCodeCI(byte[] array, int offset, int size) {
        int result = 0;
        for (int i = offset; i < offset + size; ++i) {
            byte b = array[i];
            result += b | 0x20;
        }
        return result;
    }

    static int hashCodeCI(byte[] array) {
        return HttpUtils.hashCodeCI(array, 0, array.length);
    }
}

