/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.exception.TruncatedDataException;
import io.activej.csp.ChannelOutput;
import io.activej.csp.binary.BinaryChannelInput;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.binary.decoder.ByteBufsDecoder;
import io.activej.csp.binary.decoder.ByteBufsDecoders;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.dsl.WithBinaryChannelInput;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.http.HttpUtils;
import io.activej.http.IWebSocket;
import io.activej.http.WebSocketConstants;
import io.activej.http.WebSocketException;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.Reactive;
import java.nio.charset.CharacterCodingException;
import java.util.function.Consumer;

public final class WebSocketBufsToFrames
extends AbstractCommunicatingProcess
implements WithChannelTransformer<WebSocketBufsToFrames, ByteBuf, IWebSocket.Frame>,
WithBinaryChannelInput<WebSocketBufsToFrames> {
    private static final byte OP_CODE_MASK = 15;
    private static final byte RSV_MASK = 112;
    private static final byte LAST_7_BITS_MASK = 127;
    private static final ByteBufsDecoder<Byte> SINGLE_BYTE_DECODER = bufs -> bufs.hasRemainingBytes(1) ? Byte.valueOf(bufs.getByte()) : null;
    private final long maxMessageSize;
    private final Consumer<ByteBuf> onPing;
    private final Consumer<ByteBuf> onPong;
    private final byte[] mask = new byte[4];
    private final boolean masked;
    private final SettablePromise<WebSocketException> closeReceivedPromise = new SettablePromise();
    private ByteBufs bufs;
    private BinaryChannelSupplier input;
    private ChannelConsumer<IWebSocket.Frame> output;
    private int maskIndex;
    private boolean isFin;
    private boolean waitingForFin;
    private WebSocketConstants.OpCode currentOpCode;
    private final ByteBufs frameBufs = new ByteBufs();
    private final ByteBufs controlMessageBufs = new ByteBufs();

    WebSocketBufsToFrames(long maxMessageSize, Consumer<ByteBuf> onPing, Consumer<ByteBuf> onPong, boolean masked) {
        this.maxMessageSize = maxMessageSize;
        this.onPing = onPing;
        this.onPong = onPong;
        this.masked = masked;
    }

    public static WebSocketBufsToFrames create(long maxMessageSize, Consumer<ByteBuf> onPing, Consumer<ByteBuf> onPong, boolean maskRequired) {
        return new WebSocketBufsToFrames(maxMessageSize, onPing, onPong, maskRequired);
    }

    public BinaryChannelInput getInput() {
        return input -> {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            this.bufs = input.getBufs();
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<IWebSocket.Frame> getOutput() {
        return output -> {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    public Promise<WebSocketException> getCloseReceivedPromise() {
        return this.closeReceivedPromise;
    }

    protected void doProcess() {
        this.processOpCode();
    }

    private void processOpCode() {
        this.input.decode(SINGLE_BYTE_DECODER).whenResult(firstByte -> {
            if ((firstByte & 0x70) != 0) {
                this.onProtocolError(WebSocketConstants.RESERVED_BITS_SET);
                return;
            }
            byte opCodeByte = (byte)(firstByte & 0xF);
            this.currentOpCode = WebSocketConstants.OpCode.fromOpCodeByte(opCodeByte);
            if (this.currentOpCode == null) {
                this.onProtocolError(WebSocketConstants.UNKNOWN_OP_CODE);
                return;
            }
            boolean bl = this.isFin = firstByte < 0;
            if (this.currentOpCode.isControlCode()) {
                if (!this.isFin) {
                    this.onProtocolError(WebSocketConstants.FRAGMENTED_CONTROL_MESSAGE);
                } else {
                    this.processLength();
                }
                return;
            }
            if (this.waitingForFin) {
                if (this.currentOpCode != WebSocketConstants.OpCode.OP_CONTINUATION) {
                    this.onProtocolError(WebSocketConstants.WAITING_FOR_LAST_FRAME);
                    return;
                }
            } else if (this.currentOpCode == WebSocketConstants.OpCode.OP_CONTINUATION) {
                this.onProtocolError(WebSocketConstants.UNEXPECTED_CONTINUATION);
                return;
            }
            this.waitingForFin = !this.isFin;
            this.processLength();
        });
    }

    private void processLength() {
        assert (this.currentOpCode != null);
        this.input.decode(SINGLE_BYTE_DECODER).whenResult(maskAndLen -> {
            boolean msgMasked;
            boolean bl = msgMasked = maskAndLen < 0;
            if (this.masked && !msgMasked) {
                this.onProtocolError(WebSocketConstants.MASK_REQUIRED);
            }
            if (!this.masked && msgMasked) {
                this.onProtocolError(WebSocketConstants.MASK_SHOULD_NOT_BE_PRESENT);
            }
            this.maskIndex = msgMasked ? 0 : -1;
            byte length = (byte)(maskAndLen & 0x7F);
            if (this.currentOpCode.isControlCode() && length > 125) {
                this.onProtocolError(WebSocketConstants.INVALID_PAYLOAD_LENGTH);
                return;
            }
            if (length == 126) {
                this.processLength2(2);
            } else if (length == 127) {
                this.processLength2(8);
            } else {
                this.processMask(length);
            }
        });
    }

    private void processLength2(int numberOfBytes) {
        assert (numberOfBytes == 2 || numberOfBytes == 8);
        this.input.decode(ByteBufsDecoders.ofFixedSize((int)numberOfBytes)).whenResult(lenBuf -> {
            long len;
            if (numberOfBytes == 2) {
                len = Short.toUnsignedLong(lenBuf.readShort());
            } else {
                len = lenBuf.readLong();
                if (len < 0L) {
                    this.onProtocolError(WebSocketConstants.INVALID_PAYLOAD_LENGTH);
                }
            }
            lenBuf.recycle();
            this.processMask(len);
        });
    }

    private void processMask(long length) {
        if ((long)this.frameBufs.remainingBytes() + length > this.maxMessageSize) {
            this.onProtocolError(WebSocketConstants.MESSAGE_TOO_BIG);
            return;
        }
        if (this.maskIndex == -1) {
            this.processPayload(length);
        } else {
            this.input.decode(bufs -> !bufs.hasRemainingBytes(4) ? null : bufs).whenResult(bufs -> {
                bufs.drainTo(this.mask, 0, 4);
                this.processPayload(length);
            });
        }
    }

    private void processPayload(long length) {
        assert (length >= 0L);
        ByteBuf buf = this.bufs.takeAtMost(length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length);
        this.unmask(buf);
        long newLength = length - (long)buf.readRemaining();
        if (buf.canRead()) {
            (this.currentOpCode.isControlCode() ? this.controlMessageBufs : this.frameBufs).add(buf);
        }
        if (newLength != 0L) {
            Promise.complete().then(() -> this.bufs.isEmpty() ? this.input.needMoreData() : Promise.complete()).whenResult(() -> this.processPayload(newLength));
            return;
        }
        if (this.currentOpCode.isControlCode()) {
            this.processControlPayload();
        } else {
            this.output.accept((Object)new IWebSocket.Frame(HttpUtils.opToFrameType(this.currentOpCode), this.frameBufs.takeRemaining(), this.isFin)).whenResult(this::processOpCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processControlPayload() {
        ByteBuf controlPayload = this.controlMessageBufs.takeRemaining();
        if (this.currentOpCode == WebSocketConstants.OpCode.OP_CLOSE) {
            this.frameBufs.recycle();
            if (controlPayload.canRead()) {
                String payload;
                int payloadLength = controlPayload.readRemaining();
                if (payloadLength < 2 || payloadLength > 125) {
                    this.onProtocolError(WebSocketConstants.INVALID_PAYLOAD_LENGTH);
                    return;
                }
                int statusCode = Short.toUnsignedInt(controlPayload.readShort());
                if (HttpUtils.isReservedCloseCode(statusCode)) {
                    this.onProtocolError(WebSocketConstants.INVALID_CLOSE_CODE);
                    return;
                }
                try {
                    payload = HttpUtils.getUTF8(controlPayload);
                }
                catch (CharacterCodingException e) {
                    this.onProtocolError(WebSocketConstants.NOT_A_VALID_UTF_8);
                    return;
                }
                finally {
                    controlPayload.recycle();
                }
                if (statusCode == 1000) {
                    this.output.acceptEndOfStream().whenComplete(() -> this.closeReceivedPromise.trySet((Object)WebSocketConstants.REGULAR_CLOSE)).whenResult(() -> this.completeProcess());
                } else {
                    WebSocketException exception = new WebSocketException(statusCode, payload);
                    this.onCloseReceived(exception);
                }
            } else {
                controlPayload.recycle();
                this.onCloseReceived(WebSocketConstants.STATUS_CODE_MISSING);
            }
        } else if (this.currentOpCode == WebSocketConstants.OpCode.OP_PING) {
            this.onPing.accept(controlPayload);
            this.processOpCode();
        } else {
            assert (this.currentOpCode == WebSocketConstants.OpCode.OP_PONG);
            this.onPong.accept(controlPayload);
            this.processOpCode();
        }
    }

    private void unmask(ByteBuf buf) {
        if (this.maskIndex == -1 || !buf.canRead()) {
            return;
        }
        for (int head = buf.head(); head < buf.tail(); ++head) {
            buf.set(head, (byte)(buf.at(head) ^ this.mask[this.maskIndex++ % 4]));
        }
    }

    private void onCloseReceived(WebSocketException e) {
        this.closeReceivedPromise.trySet((Object)e);
        this.closeEx(e);
    }

    void onProtocolError(WebSocketException e) {
        Reactive.checkInReactorThread((Reactive)this);
        this.closeReceivedPromise.trySetException((Exception)e);
        this.closeEx(e);
    }

    protected void doClose(Exception e) {
        if (this.output != null) {
            this.output.closeEx(e instanceof TruncatedDataException ? WebSocketConstants.CLOSE_FRAME_MISSING : e);
        }
        this.frameBufs.recycle();
        this.controlMessageBufs.recycle();
    }
}

