/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.http.HttpException;
import io.activej.http.HttpUtils;
import org.jetbrains.annotations.Nullable;

public class WebSocketException
extends HttpException {
    public static final boolean WITH_STACK_TRACE = ApplicationSettings.getBoolean(WebSocketException.class, (String)"withStackTrace", (Boolean)false);
    @Nullable
    private final Integer code;

    public WebSocketException() {
        super("");
        this.code = null;
    }

    public WebSocketException(@Nullable Integer code) {
        super("");
        this.code = code;
    }

    public WebSocketException(@Nullable Integer code, String reason) {
        super((String)Checks.checkArgument((Object)reason, r -> r.length() <= 123, (Object)"Reason too long"));
        this.code = code;
    }

    @Nullable
    public Integer getCode() {
        return this.code;
    }

    public String getReason() {
        return super.getMessage();
    }

    boolean canBeEchoed() {
        return this.code == null || !HttpUtils.isReservedCloseCode(this.code);
    }

    @Override
    public final Throwable fillInStackTrace() {
        return WITH_STACK_TRACE ? super.fillInStackTrace() : this;
    }

    @Override
    public String getMessage() {
        return this.code == null ? "" : "[" + this.code + "]" + super.getMessage();
    }
}

