/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.decoder;

import io.activej.common.collection.Either;
import io.activej.common.function.FunctionEx;
import io.activej.http.decoder.DecodeError;
import java.util.List;
import java.util.function.Function;

@FunctionalInterface
public interface Mapper<T, V> {
    public Either<V, List<DecodeError>> map(T var1);

    public static <T, V> Mapper<T, V> of(Function<T, V> fn) {
        return value -> Either.left(fn.apply(value));
    }

    public static <T, V> Mapper<T, V> ofEx(FunctionEx<T, V> fn, String message) {
        return value -> {
            try {
                return Either.left((Object)fn.apply(value));
            }
            catch (Exception ex) {
                return Either.right(List.of(DecodeError.of(message, value)));
            }
        };
    }
}

