/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.http.loader.IStaticLoader;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CacheStaticLoader
extends AbstractReactive
implements IStaticLoader {
    private static final boolean CHECKS = Checks.isEnabled(CacheStaticLoader.class);
    public static final byte[] NOT_FOUND = new byte[0];
    private final IStaticLoader resourceLoader;
    private final Function<String, byte[]> get;
    private final BiConsumer<String, byte[]> put;

    CacheStaticLoader(Reactor reactor, IStaticLoader resourceLoader, Function<String, byte[]> get, BiConsumer<String, byte[]> put) {
        super(reactor);
        this.resourceLoader = resourceLoader;
        this.get = get;
        this.put = put;
    }

    @Override
    public Promise<ByteBuf> load(String path) {
        byte[] bytes;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if ((bytes = this.get.apply(path)) == NOT_FOUND) {
            return Promise.ofException((Exception)new ResourceNotFoundException("Could not find '" + path + "'"));
        }
        if (bytes != null) {
            return Promise.of((Object)ByteBuf.wrapForReading((byte[])bytes));
        }
        return this.doLoad(path);
    }

    private Promise<ByteBuf> doLoad(String path) {
        return this.resourceLoader.load(path).whenResult(buf -> this.put.accept(path, buf.getArray())).whenException(ResourceNotFoundException.class, e -> this.put.accept(path, NOT_FOUND));
    }
}

