/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.http.loader.IStaticLoader;
import io.activej.http.loader.ResourceIsADirectoryException;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;

public class ClassPathStaticLoader
extends AbstractReactive
implements IStaticLoader {
    private static final boolean CHECKS = Checks.isEnabled(ClassPathStaticLoader.class);
    private static final String ROOT = "/";
    private static final int ROOT_OFFSET = 1;
    private final Executor executor;
    private final ClassLoader classLoader;
    private final String root;

    private ClassPathStaticLoader(Reactor reactor, Executor executor, ClassLoader classLoader, String root) {
        super(reactor);
        this.root = root;
        this.executor = executor;
        this.classLoader = classLoader;
    }

    static ClassPathStaticLoader create(Reactor reactor, Executor executor, String root) {
        return ClassPathStaticLoader.create(reactor, executor, Thread.currentThread().getContextClassLoader(), root);
    }

    static ClassPathStaticLoader create(Reactor reactor, Executor executor, ClassLoader classLoader, String root) {
        if (((String)root).startsWith(ROOT)) {
            root = ((String)root).substring(1);
        }
        if (!((String)root).endsWith(ROOT) && !((String)root).isEmpty()) {
            root = (String)root + ROOT;
        }
        return new ClassPathStaticLoader(reactor, executor, classLoader, (String)root);
    }

    @Override
    public Promise<ByteBuf> load(String name) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        Object path = this.root;
        int begin = 0;
        if (name.startsWith(ROOT)) {
            ++begin;
        }
        Object finalPath = path = (String)path + name.substring(begin);
        return Promise.ofBlocking((Executor)this.executor, () -> this.lambda$load$0((String)finalPath, name));
    }

    private byte[] loadResource(URLConnection connection) throws IOException {
        try (InputStream stream = connection.getInputStream();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    private /* synthetic */ ByteBuf lambda$load$0(String finalPath, String name) throws Exception {
        Path filePath;
        URL resource = this.classLoader.getResource(finalPath);
        if (resource == null) {
            throw new ResourceNotFoundException("Could not find '" + name + "' in class path");
        }
        URLConnection connection = resource.openConnection();
        if (connection instanceof JarURLConnection) {
            if (((JarURLConnection)connection).getJarEntry().isDirectory()) {
                throw new ResourceIsADirectoryException("Resource '" + name + "' is a directory");
            }
        } else if ("file".equals(resource.getProtocol()) && !Files.isRegularFile(filePath = Paths.get(resource.toURI()), new LinkOption[0])) {
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                throw new ResourceIsADirectoryException("Resource '" + name + "' is a directory");
            }
            throw new ResourceNotFoundException("Could not find '" + name + "' in class path");
        }
        return ByteBuf.wrapForReading((byte[])this.loadResource(connection));
    }
}

