/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.stream;

import io.activej.async.callback.Callback;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.ChannelOutput;
import io.activej.csp.binary.BinaryChannelInput;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.binary.decoder.ByteBufsDecoders;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.dsl.WithBinaryChannelInput;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.promise.Promise;
import io.activej.reactor.Reactive;

public final class BufsConsumerChunkedDecoder
extends AbstractCommunicatingProcess
implements WithChannelTransformer<BufsConsumerChunkedDecoder, ByteBuf, ByteBuf>,
WithBinaryChannelInput<BufsConsumerChunkedDecoder> {
    public static final int MAX_CHUNK_LENGTH_DIGITS = 8;
    private static final byte[] CRLF = new byte[]{13, 10};
    private ByteBufs bufs;
    private BinaryChannelSupplier input;
    private ChannelConsumer<ByteBuf> output;
    int chunkLength;

    private BufsConsumerChunkedDecoder() {
    }

    public static BufsConsumerChunkedDecoder create() {
        return new BufsConsumerChunkedDecoder();
    }

    public BinaryChannelInput getInput() {
        return input -> {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            this.bufs = input.getBufs();
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    protected void doProcess() {
        this.processLength();
    }

    private void processLength() {
        this.input.decode(bufs -> {
            this.chunkLength = 0;
            int bytes = this.bufs.scanBytes((index, c) -> {
                if (c >= 48 && c <= 57) {
                    this.chunkLength = (this.chunkLength << 4) + (c - 48);
                } else if (c >= 97 && c <= 102) {
                    this.chunkLength = (this.chunkLength << 4) + (c - 97 + 10);
                } else if (c >= 65 && c <= 70) {
                    this.chunkLength = (this.chunkLength << 4) + (c - 65 + 10);
                } else {
                    if (c == 59 || c == 13) {
                        if (index == 0 || this.chunkLength < 0) {
                            throw new InvalidSizeException("Malformed chunk length");
                        }
                        return true;
                    }
                    throw new InvalidSizeException("Unexpected data");
                }
                if (index == 9) {
                    throw new InvalidSizeException("Chunk length exceeds maximum allowed size");
                }
                return false;
            });
            if (bytes == 0) {
                return null;
            }
            this.bufs.skip(bytes - 1);
            return this.chunkLength;
        }).subscribe((chunkLength, e) -> {
            if (e == null) {
                if (chunkLength != 0) {
                    this.consumeCRLF((int)chunkLength);
                } else {
                    this.validateLastChunk();
                }
            } else {
                this.closeEx(e);
            }
        });
    }

    private void processData(int chunkLength) {
        ByteBuf buf = this.bufs.takeAtMost(chunkLength);
        int newChunkLength = chunkLength - buf.readRemaining();
        if (newChunkLength != 0) {
            Promise.complete().thenCallback(cb -> {
                if (buf.canRead()) {
                    this.output.accept((Object)buf).subscribe((Callback)cb);
                } else {
                    cb.set(null);
                }
            }).thenCallback(cb -> {
                if (this.bufs.isEmpty()) {
                    this.input.needMoreData().subscribe((Callback)cb);
                } else {
                    cb.set(null);
                }
            }).whenResult(() -> this.processData(newChunkLength));
            return;
        }
        this.input.decode(ByteBufsDecoders.assertBytes((byte[])CRLF)).whenException(() -> ((ByteBuf)buf).recycle()).thenCallback(cb -> this.output.accept((Object)buf).subscribe((Callback)cb)).whenResult(this::processLength);
    }

    private void consumeCRLF(int chunkLength) {
        this.input.decode(bufs -> {
            ByteBuf maybeResult = (ByteBuf)ByteBufsDecoders.ofCrlfTerminatedBytes().tryDecode(bufs);
            if (maybeResult == null) {
                bufs.skip(bufs.remainingBytes() - 1);
            }
            return maybeResult;
        }).subscribe((buf, e) -> {
            if (e == null) {
                buf.recycle();
                this.processData(chunkLength);
            } else {
                this.closeEx(e);
            }
        });
    }

    private void validateLastChunk() {
        int remainingBytes = this.bufs.remainingBytes();
        if (remainingBytes >= 4) {
            try {
                int bytes = this.bufs.scanBytes(new ByteBufs.ByteScanner(){
                    int crlfCrlfSequence;

                    public boolean consume(int index, byte b) {
                        int remainder;
                        int n = b == 13 ? 0 : (remainder = b == 10 ? 1 : -1);
                        if (this.crlfCrlfSequence % 2 == remainder) {
                            return ++this.crlfCrlfSequence == 4;
                        }
                        this.crlfCrlfSequence = 0;
                        return false;
                    }
                });
                if (bytes != 0) {
                    this.bufs.skip(bytes);
                    this.input.endOfStream().then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
                    return;
                }
            }
            catch (MalformedDataException ignored) {
                throw new AssertionError((Object)"Exceptions cannot be caught here");
            }
            this.bufs.skip(remainingBytes - 3);
        }
        this.input.needMoreData().whenResult(this::validateLastChunk);
    }

    protected void doClose(Exception e) {
        this.input.closeEx(e);
        this.output.closeEx(e);
    }
}

