/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.jmx.AbstractAttributeNodeForLeaf;
import io.activej.jmx.SetterException;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.api.JmxRefreshable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeNodeForConverterType<T>
extends AbstractAttributeNodeForLeaf {
    private static final Logger logger = LoggerFactory.getLogger(AttributeNodeForConverterType.class);
    @Nullable
    private final Method setter;
    private final Function<T, String> to;
    @Nullable
    private final Function<String, T> from;

    public AttributeNodeForConverterType(String name, @Nullable String description, ValueFetcher fetcher, boolean visible, @Nullable Method setter, Function<T, String> to, @Nullable Function<String, T> from) {
        super(name, description, fetcher, visible);
        this.setter = setter;
        this.to = to;
        this.from = from;
    }

    public AttributeNodeForConverterType(String name, @Nullable String description, boolean visible, ValueFetcher fetcher, @Nullable Method setter, Function<T, String> to, @Nullable Function<String, T> from) {
        this(name, description, fetcher, visible, setter, to, from);
    }

    public AttributeNodeForConverterType(String name, String description, boolean visible, ValueFetcher fetcher, Method setter, Function<T, String> to) {
        this(name, description, fetcher, visible, setter, to, null);
    }

    @Override
    @Nullable
    protected Object aggregateAttribute(String attrName, List<?> sources) {
        Object firstPojo = sources.get(0);
        Object firstValue = this.fetcher.fetchFrom(firstPojo);
        if (firstValue == null) {
            return null;
        }
        for (int i = 1; i < sources.size(); ++i) {
            Object currentPojo = sources.get(i);
            Object currentValue = this.fetcher.fetchFrom(currentPojo);
            if (Objects.equals(firstValue, currentValue)) continue;
            return null;
        }
        return this.to.apply(firstValue);
    }

    @Override
    public Map<String, OpenType<?>> getOpenTypes() {
        return Collections.singletonMap(this.name, SimpleType.STRING);
    }

    @Override
    public List<JmxRefreshable> getAllRefreshables(@NotNull Object source) {
        return Collections.emptyList();
    }

    @Override
    public boolean isSettable(@NotNull String attrName) {
        return this.setter != null && this.from != null;
    }

    @Override
    public void setAttribute(@NotNull String attrName, @NotNull Object value, @NotNull List<?> targets) throws SetterException {
        if (!this.isSettable("")) {
            throw new SetterException(new IllegalAccessException("Cannot set non writable attribute " + this.name));
        }
        assert (this.from != null && this.setter != null);
        T result = this.from.apply((String)value);
        for (Object target : targets) {
            try {
                this.setter.invoke(target, result);
            }
            catch (Exception e) {
                logger.error("Can't set attribute " + attrName, (Throwable)e);
            }
        }
    }
}

