/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.jmx.AttributeModifier;
import io.activej.jmx.AttributeNode;
import io.activej.jmx.SetterException;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.api.JmxRefreshable;
import io.activej.jmx.api.attribute.JmxReducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.openmbean.OpenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AttributeNodeForPojo
implements AttributeNode {
    private static final char ATTRIBUTE_NAME_SEPARATOR = '_';
    private final String name;
    private final String description;
    private final ValueFetcher fetcher;
    private final JmxReducer reducer;
    private final Map<String, AttributeNode> fullNameToNode;
    private final List<? extends AttributeNode> subNodes;
    private boolean visible;

    public AttributeNodeForPojo(String name, @Nullable String description, boolean visible, ValueFetcher fetcher, @Nullable JmxReducer reducer, List<? extends AttributeNode> subNodes) {
        this.name = name;
        this.description = description;
        this.visible = visible;
        this.fetcher = fetcher;
        this.reducer = reducer;
        this.fullNameToNode = AttributeNodeForPojo.createFullNameToNodeMapping(name, subNodes);
        this.subNodes = subNodes;
    }

    private static Map<String, AttributeNode> createFullNameToNodeMapping(String name, List<? extends AttributeNode> subNodes) {
        HashMap<String, AttributeNode> fullNameToNodeMapping = new HashMap<String, AttributeNode>();
        for (AttributeNode attributeNode : subNodes) {
            Set<String> currentSubAttrNames = attributeNode.getAllAttributes();
            for (String currentSubAttrName : currentSubAttrNames) {
                String currentAttrFullName = AttributeNodeForPojo.addPrefix(currentSubAttrName, name);
                if (fullNameToNodeMapping.containsKey(currentAttrFullName)) {
                    throw new IllegalArgumentException("There are several attributes with same name: " + currentSubAttrName);
                }
                fullNameToNodeMapping.put(currentAttrFullName, attributeNode);
            }
        }
        return fullNameToNodeMapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getAllAttributes() {
        return this.fullNameToNode.keySet();
    }

    @Override
    public Set<String> getVisibleAttributes() {
        if (!this.visible) {
            return Collections.emptySet();
        }
        HashSet<String> allVisibleAttrs = new HashSet<String>();
        for (AttributeNode attributeNode : this.subNodes) {
            Set<String> visibleSubAttrs = attributeNode.getVisibleAttributes();
            for (String visibleSubAttr : visibleSubAttrs) {
                String visibleAttr = this.addPrefix(visibleSubAttr);
                allVisibleAttrs.add(visibleAttr);
            }
        }
        return allVisibleAttrs;
    }

    @Override
    public Map<String, Map<String, String>> getDescriptions() {
        HashMap<String, Map<String, String>> nameToDescriptions = new HashMap<String, Map<String, String>>();
        for (AttributeNode attributeNode : this.subNodes) {
            Map<String, Map<String, String>> currentSubNodeDescriptions = attributeNode.getDescriptions();
            for (Map.Entry<String, Map<String, String>> entry : currentSubNodeDescriptions.entrySet()) {
                String resultAttrName = this.addPrefix(entry.getKey());
                LinkedHashMap<String, String> curDescriptions = new LinkedHashMap<String, String>();
                if (this.description != null) {
                    curDescriptions.put(this.name, this.description);
                }
                curDescriptions.putAll(entry.getValue());
                nameToDescriptions.put(resultAttrName, curDescriptions);
            }
        }
        return nameToDescriptions;
    }

    @Override
    public Map<String, OpenType<?>> getOpenTypes() {
        HashMap allTypes = new HashMap();
        for (AttributeNode attributeNode : this.subNodes) {
            Map<String, OpenType<?>> subAttrTypes = attributeNode.getOpenTypes();
            for (Map.Entry<String, OpenType<?>> entry : subAttrTypes.entrySet()) {
                String attrName = this.addPrefix(entry.getKey());
                allTypes.put(attrName, entry.getValue());
            }
        }
        return allTypes;
    }

    @Override
    public Map<String, Object> aggregateAttributes(@NotNull Set<String> attrNames, @NotNull List<?> sources) {
        List<Object> subsources;
        List notNullSources = sources.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (notNullSources.isEmpty() || attrNames.isEmpty()) {
            HashMap<String, Object> nullMap = new HashMap<String, Object>();
            for (String attrName : attrNames) {
                nullMap.put(attrName, null);
            }
            return nullMap;
        }
        Map<AttributeNode, Set<String>> groupedAttrs = this.groupBySubnode(attrNames);
        if (notNullSources.size() == 1 || this.reducer == null) {
            subsources = this.fetchInnerPojos(notNullSources);
        } else {
            Object reduced = this.reducer.reduce(this.fetchInnerPojos(sources));
            subsources = Collections.singletonList(reduced);
        }
        HashMap<String, Object> aggregatedAttrs = new HashMap<String, Object>();
        for (Map.Entry<AttributeNode, Set<String>> entry : groupedAttrs.entrySet()) {
            Map<String, Object> subAttrs;
            try {
                subAttrs = entry.getKey().aggregateAttributes(entry.getValue(), subsources);
            }
            catch (AssertionError | Exception e) {
                for (String subAttrName : entry.getValue()) {
                    aggregatedAttrs.put(this.addPrefix(subAttrName), e);
                }
                continue;
            }
            for (Map.Entry<String, Object> subAttrsEntry : subAttrs.entrySet()) {
                aggregatedAttrs.put(this.addPrefix(subAttrsEntry.getKey()), subAttrsEntry.getValue());
            }
        }
        return aggregatedAttrs;
    }

    private List<Object> fetchInnerPojos(List<?> outerPojos) {
        ArrayList<Object> innerPojos = new ArrayList<Object>(outerPojos.size());
        for (Object outerPojo : outerPojos) {
            Object pojo = this.fetcher.fetchFrom(outerPojo);
            if (pojo == null) continue;
            innerPojos.add(pojo);
        }
        return innerPojos;
    }

    private Map<AttributeNode, Set<String>> groupBySubnode(Set<String> attrNames) {
        HashMap<AttributeNode, Set<String>> selectedSubnodes = new HashMap<AttributeNode, Set<String>>();
        for (String attrName : attrNames) {
            AttributeNode subnode = this.fullNameToNode.get(attrName);
            Set subnodeAttrs = selectedSubnodes.computeIfAbsent(subnode, k -> new HashSet());
            String adjustedName = this.removePrefix(attrName);
            subnodeAttrs.add(adjustedName);
        }
        return selectedSubnodes;
    }

    private String removePrefix(String attrName) {
        String adjustedName;
        if (this.name.isEmpty()) {
            adjustedName = attrName;
        } else {
            adjustedName = attrName.substring(this.name.length());
            if (adjustedName.length() > 0) {
                adjustedName = adjustedName.substring(1);
            }
        }
        return adjustedName;
    }

    private String addPrefix(String attrName) {
        return AttributeNodeForPojo.addPrefix(attrName, this.name);
    }

    private static String addPrefix(String attrName, String prefix) {
        if (attrName.isEmpty()) {
            return prefix;
        }
        String actualPrefix = prefix.isEmpty() ? "" : prefix + '_';
        return actualPrefix + attrName;
    }

    @Override
    public List<JmxRefreshable> getAllRefreshables(@NotNull Object source) {
        Object pojo = this.fetcher.fetchFrom(source);
        if (pojo == null) {
            return Collections.emptyList();
        }
        if (pojo instanceof JmxRefreshable) {
            return Collections.singletonList((JmxRefreshable)pojo);
        }
        ArrayList<JmxRefreshable> allJmxRefreshables = new ArrayList<JmxRefreshable>();
        for (AttributeNode attributeNode : this.subNodes) {
            List<JmxRefreshable> subNodeRefreshables = attributeNode.getAllRefreshables(pojo);
            allJmxRefreshables.addAll(subNodeRefreshables);
        }
        return allJmxRefreshables;
    }

    @Override
    public boolean isSettable(@NotNull String attrName) {
        if (!this.fullNameToNode.containsKey(attrName)) {
            throw new IllegalArgumentException("There is no attribute with name: " + attrName);
        }
        AttributeNode appropriateSubNode = this.fullNameToNode.get(attrName);
        return appropriateSubNode.isSettable(this.removePrefix(attrName));
    }

    @Override
    public void setAttribute(@NotNull String attrName, @NotNull Object value, @NotNull List<?> targets) throws SetterException {
        List notNullTargets = targets.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (notNullTargets.isEmpty()) {
            return;
        }
        if (!this.fullNameToNode.containsKey(attrName)) {
            throw new IllegalArgumentException("There is no attribute with name: " + attrName);
        }
        AttributeNode appropriateSubNode = this.fullNameToNode.get(attrName);
        appropriateSubNode.setAttribute(this.removePrefix(attrName), value, this.fetchInnerPojos(targets));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(@NotNull String attrName) {
        if (attrName.equals(this.name)) {
            this.visible = true;
            return;
        }
        if (!this.fullNameToNode.containsKey(attrName)) {
            throw new IllegalArgumentException("There is no attribute with name: " + attrName);
        }
        AttributeNode appropriateSubNode = this.fullNameToNode.get(attrName);
        appropriateSubNode.setVisible(this.removePrefix(attrName));
    }

    @Override
    public void hideNullPojos(@NotNull List<?> sources) {
        List<Object> innerPojos = this.fetchInnerPojos(sources);
        if (innerPojos.isEmpty()) {
            this.visible = false;
            return;
        }
        for (AttributeNode attributeNode : this.subNodes) {
            attributeNode.hideNullPojos(innerPojos);
        }
    }

    @Override
    public void applyModifier(@NotNull String attrName, @NotNull AttributeModifier<?> modifier, @NotNull List<?> target) {
        if (attrName.equals(this.name)) {
            AttributeModifier<?> attrModifierObject = modifier;
            List<Object> attributes = this.fetchInnerPojos(target);
            for (Object attribute : attributes) {
                attrModifierObject.apply(attribute);
            }
            return;
        }
        for (Map.Entry<String, AttributeNode> entry : this.fullNameToNode.entrySet()) {
            if (!AttributeNodeForPojo.flattenedAttrNameContainsNode(entry.getKey(), attrName)) continue;
            entry.getValue().applyModifier(this.removePrefix(attrName), modifier, this.fetchInnerPojos(target));
            return;
        }
        if (!this.fullNameToNode.containsKey(attrName)) {
            throw new IllegalArgumentException("There is no attribute with name: " + attrName);
        }
    }

    private static boolean flattenedAttrNameContainsNode(String flattenedAttrName, String nodeName) {
        return flattenedAttrName.startsWith(nodeName) && (flattenedAttrName.length() == nodeName.length() || flattenedAttrName.charAt(nodeName.length()) == '_');
    }
}

