/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.jmx.AbstractAttributeNodeForLeaf;
import io.activej.jmx.SetterException;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.api.JmxRefreshable;
import io.activej.jmx.api.attribute.JmxReducer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AttributeNodeForSimpleType
extends AbstractAttributeNodeForLeaf {
    @Nullable
    private final Method setter;
    private final Class<?> type;
    private final JmxReducer reducer;

    public AttributeNodeForSimpleType(String name, @Nullable String description, boolean visible, ValueFetcher fetcher, @Nullable Method setter, Class<?> attributeType, @NotNull JmxReducer reducer) {
        super(name, description, fetcher, visible);
        this.setter = setter;
        this.type = attributeType;
        this.reducer = reducer;
    }

    @Override
    public Map<String, OpenType<?>> getOpenTypes() {
        return Collections.singletonMap(this.name, AttributeNodeForSimpleType.simpleTypeOf(this.type));
    }

    @Override
    public Object aggregateAttribute(String attrName, List<?> sources) {
        ArrayList<Object> values = new ArrayList<Object>(sources.size());
        for (Object notNullSource : sources) {
            Object currentValue = this.fetcher.fetchFrom(notNullSource);
            values.add(currentValue);
        }
        return this.reducer.reduce(values);
    }

    @Override
    public List<JmxRefreshable> getAllRefreshables(@NotNull Object source) {
        return Collections.emptyList();
    }

    @Override
    public boolean isSettable(@NotNull String attrName) {
        Checks.checkArgument((boolean)attrName.equals(this.name), (Object)"Attribute names do not match");
        return this.setter != null;
    }

    @Override
    public void setAttribute(@NotNull String attrName, @NotNull Object value, @NotNull List<?> targets) throws SetterException {
        Checks.checkArgument((boolean)attrName.equals(this.name), (Object)"Attribute names do not match");
        if (this.setter == null) {
            return;
        }
        for (Object target : targets.stream().filter(Objects::nonNull).collect(Collectors.toList())) {
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SetterException(e);
            }
        }
    }

    private static SimpleType<?> simpleTypeOf(Class<?> clazz) throws IllegalArgumentException {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return SimpleType.BOOLEAN;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return SimpleType.BYTE;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return SimpleType.SHORT;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return SimpleType.CHARACTER;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return SimpleType.INTEGER;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return SimpleType.LONG;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return SimpleType.FLOAT;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return SimpleType.DOUBLE;
        }
        if (clazz == String.class) {
            return SimpleType.STRING;
        }
        throw new IllegalArgumentException("There is no SimpleType for " + clazz.getName());
    }
}

