/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.jmx.AbstractAttributeNodeForLeaf;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.api.JmxRefreshable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AttributeNodeForThrowable
extends AbstractAttributeNodeForLeaf {
    private static final String THROWABLE_TYPE_KEY = "type";
    private static final String THROWABLE_MESSAGE_KEY = "message";
    private static final String THROWABLE_STACK_TRACE_KEY = "stackTrace";
    private final CompositeType compositeType = AttributeNodeForThrowable.compositeTypeForThrowable();

    public AttributeNodeForThrowable(String name, @Nullable String description, boolean visible, ValueFetcher fetcher) {
        super(name, description, fetcher, visible);
    }

    private static CompositeType compositeTypeForThrowable() {
        try {
            String[] itemNames = new String[]{THROWABLE_TYPE_KEY, THROWABLE_MESSAGE_KEY, THROWABLE_STACK_TRACE_KEY};
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING)};
            return new CompositeType("CompositeType", "CompositeType", itemNames, itemNames, itemTypes);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, OpenType<?>> getOpenTypes() {
        return Collections.singletonMap(this.name, this.compositeType);
    }

    @Override
    @Nullable
    public Object aggregateAttribute(String attrName, List<?> sources) {
        CompositeData compositeData;
        Throwable firstThrowable;
        Object firstPojo = sources.get(0);
        Throwable resultThrowable = firstThrowable = (Throwable)this.fetcher.fetchFrom(firstPojo);
        for (int i = 1; i < sources.size(); ++i) {
            Object currentPojo = sources.get(i);
            Throwable currentThrowable = (Throwable)this.fetcher.fetchFrom(currentPojo);
            if (currentThrowable == null) continue;
            resultThrowable = currentThrowable;
        }
        try {
            compositeData = this.createCompositeDataFor(resultThrowable);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        return compositeData;
    }

    @Nullable
    private CompositeData createCompositeDataFor(Throwable e) throws OpenDataException {
        if (e == null) {
            return null;
        }
        String type = e.getClass().getName();
        String msg = e.getMessage();
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        List<String> stackTrace = Arrays.asList(stringWriter.toString().split("\n"));
        HashMap<String, Object> nameToValue = new HashMap<String, Object>();
        nameToValue.put(THROWABLE_TYPE_KEY, type);
        nameToValue.put(THROWABLE_MESSAGE_KEY, msg);
        nameToValue.put(THROWABLE_STACK_TRACE_KEY, stackTrace.toArray(new String[0]));
        return new CompositeDataSupport(this.compositeType, nameToValue);
    }

    @Override
    public List<JmxRefreshable> getAllRefreshables(@NotNull Object source) {
        return Collections.emptyList();
    }

    @Override
    public boolean isSettable(@NotNull String attrName) {
        return false;
    }

    @Override
    public void setAttribute(@NotNull String attrName, @NotNull Object value, @NotNull List<?> targets) {
        throw new UnsupportedOperationException("Cannot set attributes for throwable attribute node");
    }
}

