/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.common.collection.Either;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.ref.Ref;
import io.activej.common.reflection.ReflectionUtils;
import io.activej.jmx.AttributeModifier;
import io.activej.jmx.AttributeNode;
import io.activej.jmx.AttributeNodeForConverterType;
import io.activej.jmx.AttributeNodeForList;
import io.activej.jmx.AttributeNodeForMap;
import io.activej.jmx.AttributeNodeForPojo;
import io.activej.jmx.AttributeNodeForSimpleType;
import io.activej.jmx.AttributeNodeForThrowable;
import io.activej.jmx.JmxBeanSettings;
import io.activej.jmx.SetterException;
import io.activej.jmx.Utils;
import io.activej.jmx.ValueFetcher;
import io.activej.jmx.ValueFetcherDirect;
import io.activej.jmx.ValueFetcherFromGetter;
import io.activej.jmx.ValueFetcherFromGetterArrayAdapter;
import io.activej.jmx.api.ConcurrentJmxBeanAdapter;
import io.activej.jmx.api.JmxBeanAdapter;
import io.activej.jmx.api.JmxBeanAdapterWithRefresh;
import io.activej.jmx.api.JmxRefreshable;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.jmx.api.attribute.JmxParameter;
import io.activej.jmx.api.attribute.JmxReducer;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.JmxRefreshableStats;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.StatsUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicMBeanFactory
implements WithInitializer<DynamicMBeanFactory> {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMBeanFactory.class);
    public static final Duration DEFAULT_REFRESH_PERIOD_IN_SECONDS = Duration.ofSeconds(1L);
    public static final int MAX_JMX_REFRESHES_PER_ONE_CYCLE_DEFAULT = 500;
    private int maxJmxRefreshesPerOneCycle;
    private Duration specifiedRefreshPeriod;
    private final Map<Class<? extends JmxBeanAdapter>, JmxBeanAdapter> adapters = new HashMap<Class<? extends JmxBeanAdapter>, JmxBeanAdapter>();
    private static final JmxReducer<?> DEFAULT_REDUCER = new JmxReducers.JmxReducerDistinct();
    private static final String CREATE = "create";
    private static final String CREATE_ACCUMULATOR = "createAccumulator";
    private static final DynamicMBeanFactory INSTANCE_WITH_DEFAULT_REFRESH_PERIOD = new DynamicMBeanFactory(DEFAULT_REFRESH_PERIOD_IN_SECONDS, 500);

    private DynamicMBeanFactory(@NotNull Duration refreshPeriod, int maxJmxRefreshesPerOneCycle) {
        this.specifiedRefreshPeriod = refreshPeriod;
        this.maxJmxRefreshesPerOneCycle = maxJmxRefreshesPerOneCycle;
    }

    public static DynamicMBeanFactory create() {
        return INSTANCE_WITH_DEFAULT_REFRESH_PERIOD;
    }

    public static DynamicMBeanFactory create(Duration refreshPeriod, int maxJmxRefreshesPerOneCycle) {
        return new DynamicMBeanFactory(refreshPeriod, maxJmxRefreshesPerOneCycle);
    }

    public Duration getSpecifiedRefreshPeriod() {
        return this.specifiedRefreshPeriod;
    }

    public void setRefreshPeriod(Duration refreshPeriod) {
        this.specifiedRefreshPeriod = refreshPeriod;
        this.updateAdaptersRefreshParameters();
    }

    public int getMaxJmxRefreshesPerOneCycle() {
        return this.maxJmxRefreshesPerOneCycle;
    }

    public void setMaxJmxRefreshesPerOneCycle(int maxJmxRefreshesPerOneCycle) {
        this.maxJmxRefreshesPerOneCycle = maxJmxRefreshesPerOneCycle;
        this.updateAdaptersRefreshParameters();
    }

    public String[] getRefreshStats() {
        return (String[])this.adapters.values().stream().filter(adapter -> adapter instanceof JmxBeanAdapterWithRefresh).map(JmxBeanAdapterWithRefresh.class::cast).map(JmxBeanAdapterWithRefresh::getRefreshStats).flatMap(Collection::stream).toArray(String[]::new);
    }

    public DynamicMBean createDynamicMBean(@NotNull List<?> beans, @NotNull JmxBeanSettings setting, boolean enableRefresh) {
        Checks.checkArgument((!beans.isEmpty() ? 1 : 0) != 0, (Object)"List of beans should not be empty");
        Checks.checkArgument((boolean)beans.stream().noneMatch(Objects::isNull), (Object)"Bean can not be null");
        Checks.checkArgument((beans.stream().map(Object::getClass).collect(Collectors.toSet()).size() == 1 ? 1 : 0) != 0, (Object)"Beans should be of the same type");
        Class<?> beanClass = beans.get(0).getClass();
        JmxBeanAdapter adapter = this.ensureAdapter(beanClass);
        if (adapter.getClass().equals(ConcurrentJmxBeanAdapter.class)) {
            Checks.checkArgument((beans.size() == 1 ? 1 : 0) != 0, (Object)"ConcurrentJmxBeans cannot be used in pool");
        }
        AttributeNodeForPojo rootNode = this.createAttributesTree(beanClass, setting.getCustomTypes());
        rootNode.hideNullPojos(beans);
        for (String included : setting.getIncludedOptionals()) {
            rootNode.setVisible(included);
        }
        for (String attrName : setting.getModifiers().keySet()) {
            AttributeModifier<?> modifier = setting.getModifiers().get(attrName);
            try {
                rootNode.applyModifier(attrName, modifier, beans);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Cannot apply modifier \"%s\" for attribute \"%s\": %s", modifier.getClass().getName(), attrName, e));
            }
        }
        MBeanInfo mBeanInfo = DynamicMBeanFactory.createMBeanInfo(rootNode, beanClass);
        Map<OperationKey, Either<Method, AttributeNode>> opkeyToMethodOrNode = this.fetchOpkeyToMethodOrNode(beanClass, setting.getCustomTypes());
        DynamicMBeanAggregator mbean = new DynamicMBeanAggregator(mBeanInfo, adapter, beans, rootNode, opkeyToMethodOrNode);
        if (enableRefresh && adapter instanceof JmxBeanAdapterWithRefresh) {
            for (Object bean : beans) {
                ((JmxBeanAdapterWithRefresh)adapter).registerRefreshableBean(bean, rootNode.getAllRefreshables(bean));
            }
        }
        return mbean;
    }

    JmxBeanAdapter ensureAdapter(Class<?> beanClass) {
        Class<? extends JmxBeanAdapter> adapterClass = Utils.findAdapterClass(beanClass).orElseThrow(() -> new NoSuchElementException("Class or its superclass or any of implemented interfaces should be annotated with @JmxBean annotation"));
        return this.adapters.computeIfAbsent(adapterClass, $ -> {
            try {
                JmxBeanAdapter jmxBeanAdapter = (JmxBeanAdapter)adapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (jmxBeanAdapter instanceof JmxBeanAdapterWithRefresh) {
                    ((JmxBeanAdapterWithRefresh)jmxBeanAdapter).setRefreshParameters(this.specifiedRefreshPeriod, this.maxJmxRefreshesPerOneCycle);
                }
                return jmxBeanAdapter;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<AttributeNode> createNodesFor(Class<?> clazz, Class<?> beanClass, String[] includedOptionalAttrs, @Nullable Method getter, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        HashSet<String> includedOptionals = new HashSet<String>(Arrays.asList(includedOptionalAttrs));
        List<AttributeDescriptor> attrDescriptors = this.fetchAttributeDescriptors(clazz, customTypes);
        ArrayList<AttributeNode> attrNodes = new ArrayList<AttributeNode>();
        for (AttributeDescriptor descriptor : attrDescriptors) {
            Checks.checkNotNull((Object)descriptor.getGetter(), (String)"@JmxAttribute \"%s\" does not have getter", (Object[])new Object[]{descriptor.getName()});
            Method attrGetter = descriptor.getGetter();
            JmxAttribute attrAnnotation = attrGetter.getAnnotation(JmxAttribute.class);
            String attrAnnotationName = attrAnnotation.name();
            String attrName = attrAnnotationName.equals("_USE_GETTER_NAME_") ? ReflectionUtils.extractFieldNameFromGetter((Method)attrGetter) : attrAnnotationName;
            Checks.checkArgument((!attrName.contains("_") ? 1 : 0) != 0, (String)"@JmxAttribute with name \"%s\" contains underscores", (Object[])new Object[]{attrName});
            String attrDescription = null;
            if (!attrAnnotation.description().equals("_NO_DESCRIPTION_")) {
                attrDescription = attrAnnotation.description();
            }
            boolean included = !attrAnnotation.optional() || includedOptionals.contains(attrName);
            includedOptionals.remove(attrName);
            Type type = attrGetter.getGenericReturnType();
            Method attrSetter = descriptor.getSetter();
            AttributeNode attrNode = this.createAttributeNodeFor(attrName, attrDescription, type, included, attrAnnotation, null, attrGetter, attrSetter, beanClass, customTypes);
            attrNodes.add(attrNode);
        }
        if (!includedOptionals.isEmpty()) {
            assert (getter != null);
            throw new RuntimeException(String.format("Error in \"extraSubAttributes\" parameter in @JmxAnnotation on %s.%s(). There is no field \"%s\" in %s.", getter.getDeclaringClass().getName(), getter.getName(), io.activej.common.Utils.first(includedOptionals), getter.getReturnType().getName()));
        }
        return attrNodes;
    }

    private List<AttributeDescriptor> fetchAttributeDescriptors(Class<?> clazz, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        HashMap<String, AttributeDescriptor> nameToAttr = new HashMap<String, AttributeDescriptor>();
        for (Method method : ReflectionUtils.getAllMethods(clazz)) {
            if (!method.isAnnotationPresent(JmxAttribute.class)) continue;
            DynamicMBeanFactory.validateJmxMethod(method, JmxAttribute.class);
            if (ReflectionUtils.isGetter((Method)method)) {
                DynamicMBeanFactory.processGetter(nameToAttr, method);
                continue;
            }
            if (ReflectionUtils.isSetter((Method)method)) {
                this.processSetter(nameToAttr, method, customTypes);
                continue;
            }
            throw new RuntimeException(String.format("Method \"%s\" of class \"%s\" is annotated with @JmxAnnotation but is neither getter nor setter", method.getName(), method.getClass().getName()));
        }
        return new ArrayList<AttributeDescriptor>(nameToAttr.values());
    }

    private static void validateJmxMethod(Method method, Class<? extends Annotation> annotationClass) {
        if (!ReflectionUtils.isPublic((Method)method)) {
            throw new IllegalStateException(String.format("A method \"%s\" in class '%s' annotated with @%s should be declared public", method.getName(), method.getDeclaringClass().getName(), annotationClass.getSimpleName()));
        }
        if (!ReflectionUtils.isPublic(method.getDeclaringClass())) {
            throw new IllegalStateException(String.format("A class '%s' containing methods annotated with @%s should be declared public", method.getDeclaringClass().getName(), annotationClass.getSimpleName()));
        }
    }

    private static void processGetter(Map<String, AttributeDescriptor> nameToAttr, Method getter) {
        String name = ReflectionUtils.extractFieldNameFromGetter((Method)getter);
        Class<?> attrType = getter.getReturnType();
        if (nameToAttr.containsKey(name)) {
            AttributeDescriptor previousDescriptor = nameToAttr.get(name);
            Checks.checkArgument((previousDescriptor.getGetter() == null ? 1 : 0) != 0, (String)"More than one getter with name \"%s\"", (Object[])new Object[]{getter.getName()});
            Checks.checkArgument((boolean)previousDescriptor.getType().equals(attrType), (String)"Getter with name \"%s\" has different type than appropriate setter", (Object[])new Object[]{getter.getName()});
            nameToAttr.put(name, new AttributeDescriptor(name, attrType, getter, previousDescriptor.getSetter()));
        } else {
            nameToAttr.put(name, new AttributeDescriptor(name, attrType, getter, null));
        }
    }

    private void processSetter(Map<String, AttributeDescriptor> nameToAttr, Method setter, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        Class<?> attrType = setter.getParameterTypes()[0];
        Checks.checkArgument((ReflectionUtils.isSimpleType(attrType) || customTypes.containsKey(attrType) ? 1 : 0) != 0, (String)"Setters are allowed only on SimpleType attributes. But setter \"%s\" is not SimpleType setter", (Object[])new Object[]{setter.getName()});
        String name = ReflectionUtils.extractFieldNameFromSetter((Method)setter);
        if (nameToAttr.containsKey(name)) {
            AttributeDescriptor previousDescriptor = nameToAttr.get(name);
            Checks.checkArgument((previousDescriptor.getSetter() == null ? 1 : 0) != 0, (String)"More than one setter with name \"%s\"", (Object[])new Object[]{setter.getName()});
            Checks.checkArgument((boolean)previousDescriptor.getType().equals(attrType), (String)"Setter with name \"%s\" has different type than appropriate getter", (Object[])new Object[]{setter.getName()});
            nameToAttr.put(name, new AttributeDescriptor(name, attrType, previousDescriptor.getGetter(), setter));
        } else {
            nameToAttr.put(name, new AttributeDescriptor(name, attrType, null, setter));
        }
    }

    private void updateAdaptersRefreshParameters() {
        for (JmxBeanAdapter adapter : this.adapters.values()) {
            if (!(adapter instanceof JmxBeanAdapterWithRefresh)) continue;
            ((JmxBeanAdapterWithRefresh)adapter).setRefreshParameters(this.specifiedRefreshPeriod, this.maxJmxRefreshesPerOneCycle);
        }
    }

    private AttributeNode createAttributeNodeFor(String attrName, @Nullable String attrDescription, Type attrType, boolean included, @Nullable JmxAttribute attrAnnotation, @Nullable JmxReducer<?> reducer, @Nullable Method getter, @Nullable Method setter, Class<?> beanClass, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        if (attrType instanceof Class) {
            ValueFetcher defaultFetcher = DynamicMBeanFactory.createAppropriateFetcher(getter);
            Class returnClass = (Class)attrType;
            if (customTypes.containsKey(attrType)) {
                JmxCustomTypeAdapter<?> customTypeAdapter = customTypes.get(attrType);
                return new AttributeNodeForConverterType(attrName, attrDescription, included, defaultFetcher, setter, customTypeAdapter.to, customTypeAdapter.from);
            }
            if (ReflectionUtils.isSimpleType((Class)returnClass)) {
                reducer = reducer == null ? DynamicMBeanFactory.fetchReducerFrom(getter) : reducer;
                return new AttributeNodeForSimpleType(attrName, attrDescription, included, defaultFetcher, setter, returnClass, reducer);
            }
            if (ReflectionUtils.isThrowable((Class)returnClass)) {
                return new AttributeNodeForThrowable(attrName, attrDescription, included, defaultFetcher);
            }
            if (returnClass.isArray()) {
                Class<?> elementType = returnClass.getComponentType();
                Checks.checkNotNull((Object)getter, (Object)"Arrays can be used only directly in POJO, JmxRefreshableStats or JmxMBeans");
                ValueFetcherFromGetterArrayAdapter fetcher = new ValueFetcherFromGetterArrayAdapter(getter);
                return this.createListAttributeNodeFor(attrName, attrDescription, included, fetcher, elementType, beanClass, customTypes);
            }
            if (StatsUtils.isJmxStats((Class)returnClass)) {
                DynamicMBeanFactory.checkJmxStatsAreValid(returnClass, beanClass, getter);
                String[] extraSubAttributes = attrAnnotation != null ? attrAnnotation.extraSubAttributes() : new String[]{};
                List<AttributeNode> subNodes = this.createNodesFor(returnClass, beanClass, extraSubAttributes, getter, customTypes);
                if (subNodes.isEmpty()) {
                    throw new IllegalArgumentException(String.format("JmxRefreshableStats of type \"%s\" does not have JmxAttributes", returnClass.getName()));
                }
                return new AttributeNodeForPojo(attrName, attrDescription, included, defaultFetcher, DynamicMBeanFactory.createReducerForJmxStats(returnClass), subNodes);
            }
            String[] extraSubAttributes = attrAnnotation != null ? attrAnnotation.extraSubAttributes() : new String[]{};
            List<AttributeNode> subNodes = this.createNodesFor(returnClass, beanClass, extraSubAttributes, getter, customTypes);
            if (subNodes.isEmpty()) {
                throw new IllegalArgumentException(String.format("Unrecognized type of Jmx attribute: %s", attrType.getTypeName()));
            }
            reducer = reducer == null ? DynamicMBeanFactory.fetchReducerFrom(getter) : reducer;
            return new AttributeNodeForPojo(attrName, attrDescription, included, defaultFetcher, reducer == DEFAULT_REDUCER ? null : reducer, subNodes);
        }
        if (attrType instanceof ParameterizedType) {
            return this.createNodeForParametrizedType(attrName, attrDescription, (ParameterizedType)attrType, included, getter, setter, beanClass, customTypes);
        }
        throw new IllegalArgumentException(String.format("Unrecognized type of Jmx attribute: %s", attrType.getTypeName()));
    }

    private static JmxReducer<?> createReducerForJmxStats(Class<? extends JmxStats> jmxStatsClass) {
        return sources -> {
            JmxStats accumulator = DynamicMBeanFactory.createJmxAccumulator(jmxStatsClass);
            for (Object pojo : sources) {
                JmxStats jmxStats = (JmxStats)pojo;
                if (jmxStats == null) continue;
                accumulator.add(jmxStats);
            }
            return accumulator;
        };
    }

    private static JmxStats createJmxAccumulator(Class<? extends JmxStats> jmxStatsClass) {
        JmxStats jmxStats = (JmxStats)ReflectionUtils.tryToCreateInstanceWithFactoryMethods(jmxStatsClass, (String[])new String[]{CREATE_ACCUMULATOR, CREATE});
        if (jmxStats == null) {
            throw new RuntimeException(String.format("Cannot create JmxStats accumulator instance: %s", jmxStatsClass.getName()));
        }
        return jmxStats;
    }

    private static JmxReducer<?> fetchReducerFrom(@Nullable Method getter) {
        JmxOperation opAnnotation;
        if (getter == null) {
            return DEFAULT_REDUCER;
        }
        Class reducerClass = null;
        JmxAttribute attrAnnotation = getter.getAnnotation(JmxAttribute.class);
        if (attrAnnotation != null) {
            reducerClass = attrAnnotation.reducer();
        }
        if ((opAnnotation = getter.getAnnotation(JmxOperation.class)) != null) {
            reducerClass = opAnnotation.reducer();
        }
        if (reducerClass == null || reducerClass == DEFAULT_REDUCER.getClass()) {
            return DEFAULT_REDUCER;
        }
        try {
            return (JmxReducer)reducerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkJmxStatsAreValid(Class<?> returnClass, Class<?> beanClass, @Nullable Method getter) {
        if (JmxRefreshableStats.class.isAssignableFrom(returnClass)) {
            if (!Utils.findAdapterClass(beanClass).filter(JmxBeanAdapterWithRefresh.class::isAssignableFrom).isPresent()) {
                logger.warn("JmxRefreshableStats won't be refreshed when Bean adapter does not implement JmxBeanAdapterWithRefresh. MBean class: {}", (Object)beanClass.getName());
            }
        }
        if (returnClass.isInterface()) {
            throw new IllegalArgumentException(DynamicMBeanFactory.createErrorMessageForInvalidJmxStatsAttribute(getter));
        }
        if (Modifier.isAbstract(returnClass.getModifiers())) {
            throw new IllegalArgumentException(DynamicMBeanFactory.createErrorMessageForInvalidJmxStatsAttribute(getter));
        }
        if (!ReflectionUtils.canBeCreated(returnClass, (String[])new String[]{CREATE_ACCUMULATOR, CREATE})) {
            throw new IllegalArgumentException(DynamicMBeanFactory.createErrorMessageForInvalidJmxStatsAttribute(getter));
        }
    }

    private static String createErrorMessageForInvalidJmxStatsAttribute(@Nullable Method getter) {
        String msg = "Return type of JmxStats attribute must be a concrete class that implements JmxStats interface and contains static factory \"createAccumulator()\" method or static factory \"create()\" method or public no-arg constructor";
        if (getter != null) {
            msg = msg + String.format(". Error at %s.%s()", getter.getDeclaringClass().getName(), getter.getName());
        }
        return msg;
    }

    private AttributeNode createNodeForParametrizedType(String attrName, @Nullable String attrDescription, ParameterizedType pType, boolean included, @Nullable Method getter, @Nullable Method setter, Class<?> beanClass, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        ValueFetcher fetcher = DynamicMBeanFactory.createAppropriateFetcher(getter);
        Class rawType = (Class)pType.getRawType();
        if (rawType == List.class) {
            Type listElementType = pType.getActualTypeArguments()[0];
            return this.createListAttributeNodeFor(attrName, attrDescription, included, fetcher, listElementType, beanClass, customTypes);
        }
        if (rawType == Map.class) {
            Type valueType = pType.getActualTypeArguments()[1];
            JmxReducer<?> reducer = DynamicMBeanFactory.fetchReducerFrom(getter);
            return this.createMapAttributeNodeFor(attrName, attrDescription, included, fetcher, reducer, valueType, beanClass, customTypes);
        }
        if (customTypes.containsKey(rawType)) {
            return this.createConverterAttributeNodeFor(attrName, attrDescription, pType, included, fetcher, setter, customTypes);
        }
        throw new IllegalArgumentException(String.format("There is no support for generic class %s", pType.getTypeName()));
    }

    private AttributeNodeForConverterType createConverterAttributeNodeFor(String attrName, @Nullable String attrDescription, ParameterizedType type, boolean included, ValueFetcher fetcher, @Nullable Method setter, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        Type[] actualTypes;
        for (Type genericType : actualTypes = type.getActualTypeArguments()) {
            if (customTypes.containsKey(genericType)) continue;
            throw new IllegalArgumentException(String.format("There is no support for generic type %s", type.getTypeName()));
        }
        JmxCustomTypeAdapter<?> t = customTypes.get(type.getRawType());
        return new AttributeNodeForConverterType(attrName, attrDescription, fetcher, included, setter, t.to, t.from);
    }

    private AttributeNodeForList createListAttributeNodeFor(String attrName, @Nullable String attrDescription, boolean included, ValueFetcher fetcher, Type listElementType, Class<?> beanClass, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        if (listElementType instanceof Class) {
            Class listElementClass = (Class)listElementType;
            boolean isListOfJmxRefreshable = JmxRefreshable.class.isAssignableFrom(listElementClass);
            return new AttributeNodeForList(attrName, attrDescription, included, fetcher, this.createAttributeNodeFor("", attrDescription, listElementType, true, null, null, null, null, beanClass, customTypes), isListOfJmxRefreshable);
        }
        if (listElementType instanceof ParameterizedType) {
            String typeName = ((Class)((ParameterizedType)listElementType).getRawType()).getSimpleName();
            return new AttributeNodeForList(attrName, attrDescription, included, fetcher, this.createNodeForParametrizedType(typeName, attrDescription, (ParameterizedType)listElementType, true, null, null, beanClass, customTypes), false);
        }
        throw new IllegalArgumentException(String.format("Can't create list attribute node for List<%s>", listElementType.getTypeName()));
    }

    private AttributeNodeForMap createMapAttributeNodeFor(String attrName, @Nullable String attrDescription, boolean included, ValueFetcher fetcher, JmxReducer<?> reducer, Type valueType, Class<?> beanClass, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        AttributeNode node;
        boolean isMapOfJmxRefreshable = false;
        if (valueType instanceof Class) {
            Class valueClass = (Class)valueType;
            isMapOfJmxRefreshable = JmxRefreshable.class.isAssignableFrom(valueClass);
            node = this.createAttributeNodeFor("", attrDescription, valueType, true, null, reducer, null, null, beanClass, customTypes);
        } else if (valueType instanceof ParameterizedType) {
            String typeName = ((Class)((ParameterizedType)valueType).getRawType()).getSimpleName();
            node = this.createNodeForParametrizedType(typeName, attrDescription, (ParameterizedType)valueType, true, null, null, beanClass, customTypes);
        } else {
            throw new IllegalArgumentException(String.format("Can't create map attribute node for %s", valueType.getTypeName()));
        }
        return new AttributeNodeForMap(attrName, attrDescription, included, fetcher, node, isMapOfJmxRefreshable);
    }

    private static ValueFetcher createAppropriateFetcher(@Nullable Method getter) {
        return getter != null ? new ValueFetcherFromGetter(getter) : new ValueFetcherDirect();
    }

    private AttributeNodeForPojo createAttributesTree(Class<?> clazz, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        List<AttributeNode> subNodes = this.createNodesFor(clazz, clazz, new String[0], null, customTypes);
        return new AttributeNodeForPojo("", null, true, new ValueFetcherDirect(), null, subNodes);
    }

    private static MBeanInfo createMBeanInfo(AttributeNodeForPojo rootNode, Class<?> beanClass) {
        String beanName = "";
        String beanDescription = "";
        MBeanAttributeInfo[] attributes = rootNode != null ? DynamicMBeanFactory.fetchAttributesInfo(rootNode) : new MBeanAttributeInfo[]{};
        MBeanOperationInfo[] operations = DynamicMBeanFactory.fetchOperationsInfo(beanClass);
        return new MBeanInfo(beanName, beanDescription, attributes, null, operations, null);
    }

    private static MBeanAttributeInfo[] fetchAttributesInfo(AttributeNodeForPojo rootNode) {
        Set<String> visibleAttrs = rootNode.getVisibleAttributes();
        Map<String, OpenType<?>> nameToType = rootNode.getOpenTypes();
        Map<String, Map<String, String>> nameToDescriptions = rootNode.getDescriptions();
        ArrayList<MBeanAttributeInfo> attrsInfo = new ArrayList<MBeanAttributeInfo>();
        for (String attrName : visibleAttrs) {
            String description = DynamicMBeanFactory.createDescription(attrName, nameToDescriptions.get(attrName));
            OpenType<?> attrType = nameToType.get(attrName);
            boolean writable = rootNode.isSettable(attrName);
            boolean isIs = attrType.equals(SimpleType.BOOLEAN);
            attrsInfo.add(new MBeanAttributeInfo(attrName, attrType.getClassName(), description, true, writable, isIs));
        }
        return attrsInfo.toArray(new MBeanAttributeInfo[0]);
    }

    private static String createDescription(String name, Map<String, String> groupDescriptions) {
        if (groupDescriptions.isEmpty()) {
            return name;
        }
        if (!name.contains("_")) {
            assert (groupDescriptions.size() == 1);
            return (String)io.activej.common.Utils.first(groupDescriptions.values());
        }
        return groupDescriptions.entrySet().stream().map(entry -> String.format("\"%s\": %s", entry.getKey(), entry.getValue())).collect(Collectors.joining("  |  "));
    }

    private static MBeanOperationInfo[] fetchOperationsInfo(Class<?> beanClass) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        List methods = ReflectionUtils.getAllMethods(beanClass);
        for (Method method : methods) {
            if (!method.isAnnotationPresent(JmxOperation.class)) continue;
            DynamicMBeanFactory.validateJmxMethod(method, JmxOperation.class);
            JmxOperation annotation = method.getAnnotation(JmxOperation.class);
            String opName = annotation.name();
            if (opName.equals("")) {
                opName = method.getName();
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            MBeanParameterInfo[] parameterInfos = new MBeanParameterInfo[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterInfos[i] = new MBeanParameterInfo(Arrays.stream(parameterAnnotations[i]).filter(a -> a.annotationType() == JmxParameter.class).map(JmxParameter.class::cast).map(JmxParameter::value).findFirst().orElse(String.format("arg%d", i)), parameterTypes[i].getName(), "");
            }
            MBeanOperationInfo operationInfo = new MBeanOperationInfo(opName, annotation.description(), parameterInfos, method.getReturnType().getName(), 1);
            operations.add(operationInfo);
        }
        return operations.toArray(new MBeanOperationInfo[0]);
    }

    private Map<OperationKey, Either<Method, AttributeNode>> fetchOpkeyToMethodOrNode(Class<?> beanClass, Map<Type, JmxCustomTypeAdapter<?>> customTypes) {
        HashMap<OperationKey, Either<Method, AttributeNode>> opkeyToMethod = new HashMap<OperationKey, Either<Method, AttributeNode>>();
        List methods = ReflectionUtils.getAllMethods(beanClass);
        for (Method method : methods) {
            Either either;
            if (!method.isAnnotationPresent(JmxOperation.class)) continue;
            JmxOperation annotation = method.getAnnotation(JmxOperation.class);
            String opName = annotation.name();
            if (opName.equals("")) {
                opName = method.getName();
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            assert (paramAnnotations.length == paramTypes.length);
            String[] paramTypesNames = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypesNames[i] = paramTypes[i].getName();
            }
            if (ReflectionUtils.isGetter((Method)method)) {
                String name = ReflectionUtils.extractFieldNameFromGetter((Method)method);
                AttributeNode node = this.createAttributeNodeFor(name, null, method.getGenericReturnType(), true, null, null, method, null, beanClass, customTypes);
                either = Either.right((Object)node);
            } else {
                either = Either.left((Object)method);
            }
            opkeyToMethod.put(new OperationKey(opName, paramTypesNames), (Either<Method, AttributeNode>)either);
        }
        return opkeyToMethod;
    }

    private static final class DynamicMBeanAggregator
    implements DynamicMBean {
        private final MBeanInfo mBeanInfo;
        private final JmxBeanAdapter adapter;
        private final List<?> beans;
        private final AttributeNodeForPojo rootNode;
        private final Map<OperationKey, Either<Method, AttributeNode>> opKeyToMethodOrNode;

        public DynamicMBeanAggregator(MBeanInfo mBeanInfo, JmxBeanAdapter adapter, List<?> beans, AttributeNodeForPojo rootNode, Map<OperationKey, Either<Method, AttributeNode>> opKeyToMethodOrNode) {
            this.mBeanInfo = mBeanInfo;
            this.adapter = adapter;
            this.beans = beans;
            this.rootNode = rootNode;
            this.opKeyToMethodOrNode = opKeyToMethodOrNode;
        }

        @Override
        public Object getAttribute(String attribute) throws MBeanException {
            Object value;
            try {
                value = this.rootNode.aggregateAttributes(Collections.singleton(attribute), this.beans).get(attribute);
            }
            catch (Exception e) {
                logger.error("Failed to fetch attribute '{}' from beans {}", new Object[]{attribute, this.beans, e});
                this.propagate(e);
                throw new AssertionError((Object)"Never reached");
            }
            if (value instanceof Throwable) {
                Throwable throwable = (Throwable)value;
                logger.error("Failed to fetch attribute '{}' from beans {}", new Object[]{attribute, this.beans, throwable});
                this.propagate(throwable);
            }
            return value;
        }

        @Override
        public void setAttribute(Attribute attribute) throws MBeanException {
            String attrName = attribute.getName();
            Object attrValue = attribute.getValue();
            CountDownLatch latch = new CountDownLatch(this.beans.size());
            Ref exceptionRef = new Ref();
            for (Object bean : this.beans) {
                this.adapter.execute(bean, () -> {
                    try {
                        this.rootNode.setAttribute(attrName, attrValue, Collections.singletonList(bean));
                        latch.countDown();
                    }
                    catch (Exception e) {
                        logger.error("Failed to set attribute '{}' of {} with value '{}'", new Object[]{attrName, bean, attrValue, e});
                        exceptionRef.set((Object)e);
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MBeanException(e);
            }
            Exception e = (Exception)exceptionRef.get();
            if (e != null) {
                Exception actualException = e;
                if (e instanceof SetterException) {
                    SetterException setterException = (SetterException)e;
                    actualException = setterException.getCausedException();
                }
                this.propagate(actualException);
            }
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            AttributeList attrList = new AttributeList();
            HashSet<String> attrNames = new HashSet<String>(Arrays.asList(attributes));
            try {
                Map<String, Object> aggregatedAttrs = this.rootNode.aggregateAttributes(attrNames, this.beans);
                for (Map.Entry<String, Object> entry : aggregatedAttrs.entrySet()) {
                    if (entry.getValue() instanceof Throwable) continue;
                    attrList.add(new Attribute(entry.getKey(), entry.getValue()));
                }
            }
            catch (Exception e) {
                logger.error("Failed to get attributes {} from beans {}", new Object[]{attrNames, this.beans, e});
            }
            return attrList;
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            AttributeList resultList = new AttributeList();
            for (Object attr : attributes) {
                Attribute attribute = (Attribute)attr;
                try {
                    this.setAttribute(attribute);
                    resultList.add(new Attribute(attribute.getName(), attribute.getValue()));
                }
                catch (MBeanException mBeanException) {}
            }
            return resultList;
        }

        @Override
        @Nullable
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
            Object[] args = (Object[])io.activej.common.Utils.nonNullElse((Object)params, (Object)new Object[0]);
            String[] argTypes = (String[])io.activej.common.Utils.nonNullElse((Object)signature, (Object)new String[0]);
            OperationKey opkey = new OperationKey(actionName, argTypes);
            Either<Method, AttributeNode> methodOrNode = this.opKeyToMethodOrNode.get(opkey);
            if (methodOrNode == null) {
                String operationName = DynamicMBeanAggregator.prettyOperationName(actionName, argTypes);
                String errorMsg = String.format("There is no operation \"%s\"", operationName);
                throw new RuntimeOperationsException(new IllegalArgumentException("Operation not found"), errorMsg);
            }
            if (methodOrNode.isLeft()) {
                return this.invokeMethod((Method)methodOrNode.getLeft(), args);
            }
            if (args.length != 0) {
                throw new MBeanException(new IllegalArgumentException("Passing arguments to getter operation"));
            }
            return this.invokeNode(ReflectionUtils.extractFieldNameFromGetterName((String)actionName), (AttributeNode)methodOrNode.getRight());
        }

        private Object invokeMethod(Method method, Object[] args) throws MBeanException {
            CountDownLatch latch = new CountDownLatch(this.beans.size());
            Ref lastValueRef = new Ref();
            Ref exceptionRef = new Ref();
            for (Object bean : this.beans) {
                this.adapter.execute(bean, () -> {
                    try {
                        Object result = method.invoke(bean, args);
                        lastValueRef.set(result);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        logger.error("Failed to invoke method '{}' on {} with args {}", new Object[]{method, bean, args, e});
                        exceptionRef.set((Object)e);
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MBeanException(e);
            }
            Exception e = (Exception)exceptionRef.get();
            if (e != null) {
                this.propagate(e);
            }
            return this.beans.size() == 1 ? lastValueRef.get() : null;
        }

        private Object invokeNode(String name, AttributeNode node) throws MBeanException {
            try {
                return node.aggregateAttributes(Collections.singleton(name), this.beans).get(name);
            }
            catch (Throwable e) {
                logger.error("Failed to fetch attribute '{}' from beans {}", new Object[]{name, this.beans, e});
                this.propagate(e);
                return null;
            }
        }

        private void propagate(Throwable e) throws MBeanException {
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (targetException instanceof Exception) {
                    throw new MBeanException((Exception)targetException);
                }
                throw new MBeanException(new Exception(String.format("Throwable of type \"%s\" and message \"%s\" was thrown during method invocation", targetException.getClass().getName(), targetException.getMessage())));
            }
            if (e instanceof Exception) {
                throw new MBeanException((Exception)e);
            }
            throw new MBeanException(new Exception(String.format("Throwable of type \"%s\" and message \"%s\" was thrown", e.getClass().getName(), e.getMessage())));
        }

        private static String prettyOperationName(String name, String[] argTypes) {
            StringBuilder operationName = new StringBuilder(name + "(");
            if (argTypes.length > 0) {
                for (int i = 0; i < argTypes.length - 1; ++i) {
                    operationName.append(argTypes[i] + ", ");
                }
                operationName.append(argTypes[argTypes.length - 1]);
            }
            operationName.append(")");
            return operationName.toString();
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return this.mBeanInfo;
        }
    }

    private static final class AttributeDescriptor {
        private final String name;
        private final Type type;
        private final Method getter;
        private final Method setter;

        public AttributeDescriptor(String name, Type type, @Nullable Method getter, @Nullable Method setter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        public Method getGetter() {
            return this.getter;
        }

        @Nullable
        public Method getSetter() {
            return this.setter;
        }
    }

    static class JmxCustomTypeAdapter<T> {
        @Nullable
        public final Function<String, T> from;
        public final Function<T, String> to;

        public JmxCustomTypeAdapter(Function<T, String> to, @Nullable Function<String, T> from) {
            this.to = to;
            this.from = from;
        }

        public JmxCustomTypeAdapter(Function<T, String> to) {
            this.to = to;
            this.from = null;
        }
    }

    private static final class OperationKey {
        private final String name;
        private final String[] argTypes;

        public OperationKey(@NotNull String name, String[] argTypes) {
            this.name = name;
            this.argTypes = argTypes;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OperationKey)) {
                return false;
            }
            OperationKey that = (OperationKey)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return Arrays.equals(this.argTypes, that.argTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.argTypes);
            return result;
        }
    }
}

