/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.jmx.AttributeModifier;
import io.activej.jmx.DynamicMBeanFactory;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class JmxBeanSettings
implements WithInitializer<JmxBeanSettings> {
    private final Set<String> includedOptionals = new HashSet<String>();
    private final Map<String, AttributeModifier<?>> modifiers = new HashMap();
    private final Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes = new HashMap();

    private JmxBeanSettings(Set<String> includedOptionals, Map<String, ? extends AttributeModifier<?>> modifiers, Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes) {
        this.includedOptionals.addAll(includedOptionals);
        this.modifiers.putAll(modifiers);
        this.customTypes.putAll(customTypes);
    }

    public static JmxBeanSettings of(Set<String> includedOptionals, Map<String, ? extends AttributeModifier<?>> modifiers, Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes) {
        return new JmxBeanSettings(includedOptionals, modifiers, customTypes);
    }

    public static JmxBeanSettings create() {
        return new JmxBeanSettings(new HashSet<String>(), new HashMap(), new HashMap());
    }

    public static JmxBeanSettings defaultSettings() {
        return new JmxBeanSettings(Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap());
    }

    public void merge(JmxBeanSettings otherSettings) {
        this.includedOptionals.addAll(otherSettings.includedOptionals);
        this.modifiers.putAll(otherSettings.modifiers);
        this.customTypes.putAll(otherSettings.customTypes);
    }

    public JmxBeanSettings withIncludedOptional(String attrName) {
        this.includedOptionals.add(attrName);
        return this;
    }

    public JmxBeanSettings withModifier(String attrName, AttributeModifier<?> modifier) {
        Checks.checkArgument((!this.modifiers.containsKey(attrName) ? 1 : 0) != 0, (Object)"cannot add two modifiers for one attribute");
        this.modifiers.put(attrName, modifier);
        return this;
    }

    public JmxBeanSettings withCustomTypes(Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> customTypes) {
        this.customTypes.putAll(customTypes);
        return this;
    }

    public Set<String> getIncludedOptionals() {
        return this.includedOptionals;
    }

    public Map<String, ? extends AttributeModifier<?>> getModifiers() {
        return this.modifiers;
    }

    public Map<Type, DynamicMBeanFactory.JmxCustomTypeAdapter<?>> getCustomTypes() {
        return this.customTypes;
    }
}

