/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.initializer.WithInitializer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProtoObjectName
implements WithInitializer<ProtoObjectName> {
    @Nullable
    private final String className;
    @NotNull
    private final String packageName;
    @Nullable
    private final Object qualifier;
    @Nullable
    private final String scope;
    @Nullable
    private final String workerPoolQualifier;
    @Nullable
    private final String workerId;
    @Nullable
    private final List<String> genericParameters;

    public ProtoObjectName(@Nullable String className, @NotNull String packageName, @Nullable Object qualifier, @Nullable String scope, @Nullable String workerPoolQualifier, @Nullable String workerId, @Nullable List<String> genericParameters) {
        this.className = className;
        this.packageName = packageName;
        this.qualifier = qualifier;
        this.scope = scope;
        this.workerPoolQualifier = workerPoolQualifier;
        this.workerId = workerId;
        this.genericParameters = genericParameters;
    }

    public static ProtoObjectName create(@Nullable String className, @NotNull String packageName) {
        return new ProtoObjectName(className, packageName, null, null, null, null, null);
    }

    public ProtoObjectName withClassName(@Nullable String className) {
        return new ProtoObjectName(className, this.packageName, this.qualifier, this.scope, this.workerPoolQualifier, this.workerId, this.genericParameters);
    }

    public ProtoObjectName withPackageName(@NotNull String packageName) {
        return new ProtoObjectName(this.className, packageName, this.qualifier, this.scope, this.workerPoolQualifier, this.workerId, this.genericParameters);
    }

    public ProtoObjectName withQualifier(@Nullable Object qualifier) {
        return new ProtoObjectName(this.className, this.packageName, qualifier, this.scope, this.workerPoolQualifier, this.workerId, this.genericParameters);
    }

    public ProtoObjectName withScope(@Nullable String scope) {
        return new ProtoObjectName(this.className, this.packageName, this.qualifier, scope, this.workerPoolQualifier, this.workerId, this.genericParameters);
    }

    public ProtoObjectName withWorkerPoolQualifier(@Nullable String workerPoolQualifier) {
        return new ProtoObjectName(this.className, this.packageName, this.qualifier, this.scope, workerPoolQualifier, this.workerId, this.genericParameters);
    }

    public ProtoObjectName withWorkerId(@Nullable String workerId) {
        return new ProtoObjectName(this.className, this.packageName, this.qualifier, this.scope, this.workerPoolQualifier, workerId, this.genericParameters);
    }

    public ProtoObjectName withGenericParameters(@Nullable List<String> genericParameters) {
        ArrayList<String> list = genericParameters == null ? null : new ArrayList<String>(genericParameters);
        return new ProtoObjectName(this.className, this.packageName, this.qualifier, this.scope, this.workerPoolQualifier, this.workerId, list);
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @Nullable
    public Object getQualifier() {
        return this.qualifier;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getWorkerPoolQualifier() {
        return this.workerPoolQualifier;
    }

    @Nullable
    public List<String> getGenericParameters() {
        return this.genericParameters;
    }

    @Nullable
    public String getWorkerId() {
        return this.workerId;
    }

    public String toString() {
        return "ProtoObjectName{className='" + this.className + '\'' + ", packageName='" + this.packageName + '\'' + (this.qualifier == null ? "" : ", qualifier='" + this.qualifier + '\'') + (this.scope == null ? "" : ", scope='" + this.scope + '\'') + (this.workerPoolQualifier == null ? "" : ", workerPoolQualifier='" + this.workerPoolQualifier + '\'') + (this.workerId == null ? "" : ", workerId='" + this.workerId + '\'') + (this.genericParameters == null ? "" : ", genericParameters=" + this.genericParameters) + '}';
    }
}

