/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.jmx.ProtoObjectName;
import io.activej.jmx.Utils;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public interface ProtoObjectNameMapper {
    public ProtoObjectName apply(ProtoObjectName var1);

    public static ProtoObjectNameMapper identity() {
        return protoObjectName -> protoObjectName;
    }

    public static ProtoObjectNameMapper mapClassName(UnaryOperator<@NotNull String> mapper) {
        return Utils.doMap(ProtoObjectName::getClassName, mapper, ProtoObjectName::withClassName);
    }

    public static ProtoObjectNameMapper mapPackageName(UnaryOperator<@NotNull String> mapper) {
        return Utils.doMap(ProtoObjectName::getPackageName, mapper, ProtoObjectName::withPackageName);
    }

    public static ProtoObjectNameMapper mapQualifier(UnaryOperator<@NotNull Object> mapper) {
        return Utils.doMap(ProtoObjectName::getQualifier, mapper, ProtoObjectName::withQualifier);
    }

    public static ProtoObjectNameMapper mapScope(UnaryOperator<@NotNull String> mapper) {
        return Utils.doMap(ProtoObjectName::getScope, mapper, ProtoObjectName::withScope);
    }

    public static ProtoObjectNameMapper mapWorkerPoolQualifier(UnaryOperator<@NotNull String> mapper) {
        return Utils.doMap(ProtoObjectName::getWorkerPoolQualifier, mapper, ProtoObjectName::withWorkerPoolQualifier);
    }

    public static ProtoObjectNameMapper mapWorkerId(UnaryOperator<@NotNull String> mapper) {
        return Utils.doMap(ProtoObjectName::getWorkerId, mapper, ProtoObjectName::withWorkerId);
    }

    public static ProtoObjectNameMapper mapGenericParameters(UnaryOperator<@NotNull List<String>> mapper) {
        return Utils.doMap(ProtoObjectName::getGenericParameters, mapper, ProtoObjectName::withGenericParameters);
    }

    default public ProtoObjectNameMapper then(ProtoObjectNameMapper next) {
        return protoObjectName -> next.apply(this.apply(protoObjectName));
    }
}

