/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx;

import io.activej.common.reflection.ReflectionUtils;
import io.activej.jmx.ProtoObjectName;
import io.activej.jmx.ProtoObjectNameMapper;
import io.activej.jmx.api.JmxBean;
import io.activej.jmx.api.JmxBeanAdapter;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.management.DynamicMBean;
import javax.management.MXBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Utils {
    Utils() {
    }

    static boolean isMBean(Class<?> clazz) {
        return Utils.isJmxBean(clazz) || Utils.isStandardMBean(clazz) || Utils.isMXBean(clazz) || Utils.isDynamicMBean(clazz);
    }

    static boolean isJmxBean(Class<?> clazz) {
        return ReflectionUtils.deepFindAnnotation(clazz, JmxBean.class).isPresent();
    }

    static boolean isStandardMBean(Class<?> clazz) {
        return ReflectionUtils.walkClassHierarchy(clazz, anInterface -> anInterface.isInterface() && anInterface.getSimpleName().equals(clazz.getSimpleName() + "MBean") ? Optional.of(anInterface) : Optional.empty()).isPresent();
    }

    static boolean isMXBean(Class<?> clazz) {
        return ReflectionUtils.walkClassHierarchy(clazz, anInterface -> anInterface.isInterface() && (anInterface.getSimpleName().endsWith("MXBean") || anInterface.isAnnotationPresent(MXBean.class)) ? Optional.of(anInterface) : Optional.empty()).isPresent();
    }

    static boolean isDynamicMBean(Class<?> clazz) {
        return DynamicMBean.class.isAssignableFrom(clazz);
    }

    static Optional<Class<? extends JmxBeanAdapter>> findAdapterClass(Class<?> aClass) {
        return ReflectionUtils.deepFindAnnotation(aClass, JmxBean.class).map(JmxBean::value);
    }

    static String getQualifierString(@NotNull Object qualifier) throws ReflectiveOperationException {
        if (qualifier instanceof Class) {
            Class qualifierClass = (Class)qualifier;
            if (qualifierClass.isAnnotation()) {
                return qualifierClass.getSimpleName();
            }
        } else if (qualifier instanceof Annotation) {
            return ReflectionUtils.getAnnotationString((Annotation)((Annotation)qualifier));
        }
        return qualifier.toString();
    }

    static <T> ProtoObjectNameMapper doMap(Function<@NotNull ProtoObjectName, @Nullable T> extractor, UnaryOperator<@NotNull T> mapper, BiFunction<@NotNull ProtoObjectName, @Nullable T, @NotNull ProtoObjectName> result) {
        return protoObjectName -> {
            Object value = extractor.apply(protoObjectName);
            if (value == null) {
                return protoObjectName;
            }
            Object mappedValue = mapper.apply(value);
            return (ProtoObjectName)result.apply(protoObjectName, mappedValue);
        };
    }
}

