/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net.socket.udp;

import io.activej.async.exception.AsyncCloseException;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.common.recycle.Recyclers;
import io.activej.common.tuple.Tuple2;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.NioChannelEventHandler;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ValueStats;
import io.activej.net.socket.udp.AsyncUdpSocket;
import io.activej.net.socket.udp.UdpPacket;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.time.Duration;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncUdpSocketNio
implements AsyncUdpSocket,
NioChannelEventHandler {
    private static final boolean CHECK = Checks.isEnabled(AsyncUdpSocketNio.class);
    private static final int OP_POSTPONED = 128;
    private static final MemSize DEFAULT_UDP_BUFFER_SIZE = MemSize.kilobytes((long)16L);
    private final Eventloop eventloop;
    @Nullable
    private SelectionKey key;
    private int receiveBufferSize = DEFAULT_UDP_BUFFER_SIZE.toInt();
    private final DatagramChannel channel;
    private final ArrayDeque<SettablePromise<UdpPacket>> readQueue = new ArrayDeque();
    private final ArrayDeque<UdpPacket> readBuffer = new ArrayDeque();
    private final ArrayDeque<Tuple2<UdpPacket, SettablePromise<Void>>> writeQueue = new ArrayDeque();
    private int ops = 0;
    @Nullable
    private Inspector inspector;

    private AsyncUdpSocketNio(@NotNull Eventloop eventloop, @NotNull DatagramChannel channel) throws IOException {
        this.eventloop = eventloop;
        this.channel = channel;
        this.key = channel.register(eventloop.ensureSelector(), 0, this);
    }

    public static Promise<AsyncUdpSocketNio> connect(Eventloop eventloop, DatagramChannel channel) {
        try {
            return Promise.of((Object)new AsyncUdpSocketNio(eventloop, channel));
        }
        catch (IOException e) {
            return Promise.ofException((Exception)e);
        }
    }

    public void setInspector(@Nullable Inspector inspector) {
        this.inspector = inspector;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isOpen() {
        return this.key != null;
    }

    @Override
    public Promise<UdpPacket> receive() {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if (!this.isOpen()) {
            return Promise.ofException((Exception)new AsyncCloseException());
        }
        UdpPacket polled = this.readBuffer.poll();
        if (polled != null) {
            return Promise.of((Object)polled);
        }
        return Promise.ofCallback(cb -> {
            this.readQueue.add((SettablePromise<UdpPacket>)cb);
            this.readInterest(true);
        });
    }

    public void onReadReady() {
        while (this.isOpen()) {
            SettablePromise<UdpPacket> cb;
            InetSocketAddress sourceAddress;
            ByteBuffer buffer;
            ByteBuf buf;
            block6: {
                buf = ByteBufPool.allocate((int)this.receiveBufferSize);
                buffer = buf.toWriteByteBuffer();
                sourceAddress = null;
                try {
                    sourceAddress = (InetSocketAddress)this.channel.receive(buffer);
                }
                catch (IOException e) {
                    if (this.inspector == null) break block6;
                    this.inspector.onReceiveError(this, e);
                }
            }
            if (sourceAddress == null) {
                buf.recycle();
                break;
            }
            buf.ofWriteByteBuffer(buffer);
            UdpPacket packet = UdpPacket.of(buf, sourceAddress);
            if (this.inspector != null) {
                this.inspector.onReceive(this, packet);
            }
            if ((cb = this.readQueue.poll()) != null) {
                cb.set((Object)packet);
                return;
            }
            this.readBuffer.add(packet);
        }
    }

    @Override
    public Promise<Void> send(UdpPacket packet) {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if (!this.isOpen()) {
            return Promise.ofException((Exception)new AsyncCloseException());
        }
        return Promise.ofCallback(cb -> {
            this.writeQueue.add((Tuple2<UdpPacket, SettablePromise<Void>>)new Tuple2((Object)packet, cb));
            this.onWriteReady();
        });
    }

    public void onWriteReady() {
        Tuple2<UdpPacket, SettablePromise<Void>> entry;
        while ((entry = this.writeQueue.peek()) != null) {
            UdpPacket packet;
            block5: {
                packet = (UdpPacket)entry.getValue1();
                ByteBuffer buffer = packet.getBuf().toReadByteBuffer();
                try {
                    if (this.channel.send(buffer, packet.getSocketAddress()) == 0) {
                    }
                    break block5;
                }
                catch (IOException e) {
                    if (this.inspector == null) break;
                    this.inspector.onSendError(this, e);
                }
                break;
            }
            ((SettablePromise)entry.getValue2()).set(null);
            if (this.inspector != null) {
                this.inspector.onSend(this, packet);
            }
            this.writeQueue.poll();
            packet.recycle();
        }
        this.writeInterest(!this.writeQueue.isEmpty());
    }

    private void interests(int newOps) {
        if (this.ops != newOps) {
            this.ops = newOps;
            if ((this.ops & 0x80) == 0 && this.key != null) {
                this.key.interestOps(this.ops);
            }
        }
    }

    private void readInterest(boolean readInterest) {
        this.interests(readInterest ? this.ops | 1 : this.ops & 0xFFFFFFFE);
    }

    private void writeInterest(boolean writeInterest) {
        this.interests(writeInterest ? this.ops | 4 : this.ops & 0xFFFFFFFB);
    }

    @Override
    public void close() {
        SelectionKey key;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if ((key = this.key) == null) {
            return;
        }
        this.key = null;
        if (this.inspector != null) {
            this.inspector.onClose(this);
        }
        this.eventloop.closeChannel((SelectableChannel)this.channel, key);
        Recyclers.recycle(this.writeQueue);
    }

    public String toString() {
        if (this.isOpen()) {
            return "UDP socket: " + this.getRemoteSocketAddress();
        }
        return "closed UDP socket";
    }

    private InetSocketAddress getRemoteSocketAddress() {
        try {
            return (InetSocketAddress)this.channel.getRemoteAddress();
        }
        catch (ClosedChannelException ignored) {
            throw new AssertionError((Object)"Channel is closed");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onCreate(AsyncUdpSocketNio var1);

        public void onReceive(AsyncUdpSocketNio var1, UdpPacket var2);

        public void onReceiveError(AsyncUdpSocketNio var1, IOException var2);

        public void onSend(AsyncUdpSocketNio var1, UdpPacket var2);

        public void onSendError(AsyncUdpSocketNio var1, IOException var2);

        public void onClose(AsyncUdpSocketNio var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private final EventStats creates;
        private final ValueStats receives;
        private final EventStats receiveErrors;
        private final ValueStats sends;
        private final EventStats sendErrors;
        private final EventStats closes;

        public JmxInspector(Duration smoothingWindow) {
            this.creates = EventStats.create((Duration)smoothingWindow);
            this.receives = ValueStats.create((Duration)smoothingWindow).withUnit("bytes").withRate();
            this.receiveErrors = EventStats.create((Duration)smoothingWindow);
            this.sends = ValueStats.create((Duration)smoothingWindow).withUnit("bytes").withRate();
            this.sendErrors = EventStats.create((Duration)smoothingWindow);
            this.closes = EventStats.create((Duration)smoothingWindow);
        }

        @Override
        public void onCreate(AsyncUdpSocketNio socket) {
            this.creates.recordEvent();
        }

        @Override
        public void onReceive(AsyncUdpSocketNio socket, UdpPacket packet) {
            this.receives.recordValue(packet.getBuf().readRemaining());
        }

        @Override
        public void onReceiveError(AsyncUdpSocketNio socket, IOException e) {
            this.receiveErrors.recordEvent();
        }

        @Override
        public void onSend(AsyncUdpSocketNio socket, UdpPacket packet) {
            this.sends.recordValue(packet.getBuf().readRemaining());
        }

        @Override
        public void onSendError(AsyncUdpSocketNio socket, IOException e) {
            this.sendErrors.recordEvent();
        }

        @Override
        public void onClose(AsyncUdpSocketNio socket) {
            this.closes.recordEvent();
        }

        @JmxAttribute
        public EventStats getCreates() {
            return this.creates;
        }

        @JmxAttribute(description="Received packet size")
        public ValueStats getReceives() {
            return this.receives;
        }

        @JmxAttribute
        public EventStats getReceiveErrors() {
            return this.receiveErrors;
        }

        @JmxAttribute(description="Sent packet size")
        public ValueStats getSends() {
            return this.sends;
        }

        @JmxAttribute
        public EventStats getSendErrors() {
            return this.sendErrors;
        }

        @JmxAttribute
        public EventStats getCloses() {
            return this.closes;
        }
    }
}

