/*
 * Decompiled with CFR 0.152.
 */
package io.activej.trigger;

import io.activej.common.Utils;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.time.CurrentTimeProvider;
import io.activej.jmx.api.ConcurrentJmxBean;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.jmx.stats.MBeanFormat;
import io.activej.trigger.Severity;
import io.activej.trigger.Trigger;
import io.activej.trigger.TriggerResult;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class Triggers
implements ConcurrentJmxBean,
WithInitializer<Triggers> {
    public static final Duration CACHE_TIMEOUT = Duration.ofSeconds(1L);
    private final List<Trigger> triggers = new ArrayList<Trigger>();
    CurrentTimeProvider now = CurrentTimeProvider.ofSystem();
    private final Map<Trigger, TriggerResult> suppressedResults = new LinkedHashMap<Trigger, TriggerResult>();
    private final Map<Trigger, TriggerResult> cachedResults = new LinkedHashMap<Trigger, TriggerResult>();
    private Map<Trigger, TriggerWithResult> maxSeverityResults = new LinkedHashMap<Trigger, TriggerWithResult>();
    private long cachedTimestamp;
    private final Predicate<TriggerWithResult> isNotSuppressed = triggerWithResult -> {
        Trigger trigger = ((TriggerWithResult)triggerWithResult).trigger;
        if (this.suppressedResults.containsKey(trigger)) {
            TriggerResult suppressedTriggerResult = this.suppressedResults.get(trigger);
            TriggerResult triggerResult = triggerWithResult.getTriggerResult();
            return triggerResult.getCount() > suppressedTriggerResult.getCount() || triggerResult.getTimestamp() > suppressedTriggerResult.getTimestamp();
        }
        return true;
    };

    private Triggers() {
    }

    public static Triggers create() {
        return new Triggers();
    }

    public Triggers withTrigger(Trigger trigger) {
        this.triggers.add(trigger);
        return this;
    }

    public Triggers withTrigger(Severity severity, String component, String name, Supplier<TriggerResult> triggerFunction) {
        return this.withTrigger(Trigger.of(severity, component, name, triggerFunction));
    }

    public synchronized void addTrigger(Trigger trigger) {
        this.withTrigger(trigger);
    }

    public synchronized void addTrigger(Severity severity, String component, String name, Supplier<TriggerResult> triggerFunction) {
        this.withTrigger(severity, component, name, triggerFunction);
    }

    private void refresh() {
        long currentTime = this.now.currentTimeMillis();
        if (this.cachedTimestamp + CACHE_TIMEOUT.toMillis() < currentTime) {
            TriggerResult newResult;
            this.cachedTimestamp = currentTime;
            HashMap<Trigger, TriggerResult> newResults = new HashMap<Trigger, TriggerResult>();
            for (Trigger trigger : this.triggers) {
                try {
                    newResult = trigger.getTriggerFunction().get();
                }
                catch (Exception e) {
                    newResult = TriggerResult.ofError(e);
                }
                if (newResult == null || !newResult.isPresent()) continue;
                newResults.put(trigger, newResult);
            }
            for (Trigger trigger : new HashSet(Utils.difference(this.cachedResults.keySet(), newResults.keySet()))) {
                this.cachedResults.remove(trigger);
                this.suppressedResults.remove(trigger);
            }
            for (Map.Entry entry : newResults.entrySet()) {
                newResult = (TriggerResult)entry.getValue();
                if (!newResult.hasTimestamp()) {
                    TriggerResult oldResult = this.cachedResults.get(entry.getKey());
                    newResult = TriggerResult.create(oldResult == null ? currentTime : oldResult.getTimestamp(), newResult.getThrowable(), newResult.getValue());
                }
                this.cachedResults.put((Trigger)entry.getKey(), newResult.withCount(0));
            }
            for (Map.Entry entry : newResults.entrySet()) {
                TriggerResult oldResult = this.cachedResults.get(entry.getKey());
                this.cachedResults.put((Trigger)entry.getKey(), oldResult.withCount(oldResult.getCount() + ((TriggerResult)entry.getValue()).getCount()));
            }
            this.maxSeverityResults = new HashMap<Trigger, TriggerWithResult>(this.cachedResults.size());
            for (Map.Entry entry : this.cachedResults.entrySet()) {
                Trigger trigger = (Trigger)entry.getKey();
                TriggerResult triggerResult = (TriggerResult)entry.getValue();
                TriggerWithResult oldTriggerWithResult = this.maxSeverityResults.get(trigger);
                if (oldTriggerWithResult == null || oldTriggerWithResult.getTrigger().getSeverity().ordinal() < trigger.getSeverity().ordinal() || oldTriggerWithResult.getTrigger().getSeverity() == trigger.getSeverity() && oldTriggerWithResult.getTriggerResult().getTimestamp() > triggerResult.getTimestamp()) {
                    this.maxSeverityResults.put(trigger, new TriggerWithResult(trigger, triggerResult.withCount(triggerResult.getCount())));
                    continue;
                }
                this.maxSeverityResults.put(trigger, new TriggerWithResult(oldTriggerWithResult.getTrigger(), oldTriggerWithResult.getTriggerResult().withCount(triggerResult.getCount())));
            }
        }
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResultsDebug() {
        return this.getResultsBySeverity(Severity.DEBUG);
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResultsInformation() {
        return this.getResultsBySeverity(Severity.INFORMATION);
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResultsWarning() {
        return this.getResultsBySeverity(Severity.WARNING);
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResultsAverage() {
        return this.getResultsBySeverity(Severity.AVERAGE);
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResultsHigh() {
        return this.getResultsBySeverity(Severity.HIGH);
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResultsDisaster() {
        return this.getResultsBySeverity(Severity.DISASTER);
    }

    private List<TriggerWithResult> getResultsBySeverity(@Nullable Severity severity) {
        this.refresh();
        return this.maxSeverityResults.values().stream().filter(this.isNotSuppressed).filter(entry -> entry.getTrigger().getSeverity() == severity).sorted(Comparator.comparing(item -> item.getTriggerResult().getTimestamp())).collect(Collectors.groupingBy(o -> new TriggerKey(o.getTrigger().getComponent(), o.getTrigger().getName()))).values().stream().flatMap(list -> list.stream().filter(trigger -> trigger.getTrigger().getSeverity() == ((TriggerWithResult)Utils.last((List)list)).getTrigger().getSeverity())).collect(Collectors.toList());
    }

    @JmxAttribute
    public synchronized List<TriggerWithResult> getResults() {
        this.refresh();
        return this.maxSeverityResults.values().stream().filter(this.isNotSuppressed).sorted(Comparator.comparing(item -> item.getTrigger().getSeverity()).thenComparing(item -> item.getTriggerResult().getTimestamp())).collect(Collectors.groupingBy(o -> new TriggerKey(o.getTrigger().getComponent(), o.getTrigger().getName()))).values().stream().flatMap(list -> list.stream().filter(trigger -> trigger.getTrigger().getSeverity() == ((TriggerWithResult)Utils.last((List)list)).getTrigger().getSeverity())).collect(Collectors.toList());
    }

    @JmxAttribute
    public synchronized String getMultilineSuppressedResults() {
        return MBeanFormat.formatListAsMultilineString(new ArrayList<Trigger>(this.suppressedResults.keySet()));
    }

    @JmxAttribute
    public synchronized String getMultilineResultsDebug() {
        return MBeanFormat.formatListAsMultilineString(this.getResultsBySeverity(Severity.DEBUG));
    }

    @JmxAttribute
    public synchronized String getMultilineResultsInformation() {
        return MBeanFormat.formatListAsMultilineString(this.getResultsBySeverity(Severity.INFORMATION));
    }

    @JmxAttribute
    public synchronized String getMultilineResultsWarning() {
        return MBeanFormat.formatListAsMultilineString(this.getResultsBySeverity(Severity.WARNING));
    }

    @JmxAttribute
    public synchronized String getMultilineResultsAverage() {
        return MBeanFormat.formatListAsMultilineString(this.getResultsBySeverity(Severity.AVERAGE));
    }

    @JmxAttribute
    public synchronized String getMultilineResultsHigh() {
        return MBeanFormat.formatListAsMultilineString(this.getResultsBySeverity(Severity.HIGH));
    }

    @JmxAttribute
    public synchronized String getMultilineResultsDisaster() {
        return MBeanFormat.formatListAsMultilineString(this.getResultsBySeverity(Severity.DISASTER));
    }

    @JmxAttribute
    public synchronized String getMultilineResults() {
        return MBeanFormat.formatListAsMultilineString(this.getResults());
    }

    @JmxAttribute
    @Nullable
    public synchronized Severity getMaxSeverity() {
        this.refresh();
        return this.maxSeverityResults.values().stream().filter(this.isNotSuppressed).max(Comparator.comparing(entry -> entry.getTrigger().getSeverity())).map(entry -> entry.getTrigger().getSeverity()).orElse(null);
    }

    @JmxAttribute
    @Nullable
    public synchronized String getMaxSeverityResult() {
        this.refresh();
        return this.maxSeverityResults.values().stream().filter(this.isNotSuppressed).max(Comparator.comparing(entry -> entry.getTrigger().getSeverity())).map(Object::toString).orElse(null);
    }

    @JmxAttribute
    public synchronized List<String> getTriggers() {
        return this.triggers.stream().sorted(Comparator.comparing(Trigger::getSeverity).reversed().thenComparing(Trigger::getComponent).thenComparing(Trigger::getName)).map(t -> (Object)((Object)t.getSeverity()) + " : " + t.getComponent() + " : " + t.getName()).distinct().collect(Collectors.toList());
    }

    @JmxAttribute
    public synchronized List<String> getTriggerNames() {
        return this.triggers.stream().sorted(Comparator.comparing(Trigger::getComponent).thenComparing(Trigger::getName)).map(t -> t.getComponent() + " : " + t.getName()).distinct().collect(Collectors.toList());
    }

    @JmxAttribute
    public synchronized String getTriggerComponents() {
        return this.triggers.stream().sorted(Comparator.comparing(Trigger::getComponent)).map(Trigger::getComponent).distinct().collect(Collectors.joining(", "));
    }

    @JmxOperation
    public synchronized void suppressAllTriggers() {
        this.suppressBy(trigger -> true);
    }

    @JmxOperation
    public synchronized void suppressTriggerByName(String name) {
        this.suppressBy(trigger -> trigger.getName().equals(name));
    }

    @JmxOperation
    public synchronized void suppressTriggerByComponent(String component) {
        this.suppressBy(trigger -> trigger.getComponent().equals(component));
    }

    @JmxOperation
    public synchronized void suppressTriggerBySeverity(String severity) {
        this.suppressBy(trigger -> trigger.getSeverity().name().equalsIgnoreCase(severity));
    }

    @JmxOperation
    public synchronized void suppressTriggersBySignature(String signature) {
        String[] values = signature.split(":");
        if (values.length != 3) {
            return;
        }
        this.suppressBy(trigger -> trigger.getSeverity().name().equalsIgnoreCase(values[0].trim()) && trigger.getComponent().equals(values[1].trim()) && trigger.getName().equals(values[2].trim()));
    }

    private void suppressBy(Predicate<Trigger> condition) {
        this.refresh();
        this.cachedResults.keySet().stream().filter(condition).forEach(trigger -> this.suppressedResults.put((Trigger)trigger, this.cachedResults.get(trigger)));
    }

    public String toString() {
        return this.getTriggerComponents();
    }

    public static final class TriggerWithResult {
        private final Trigger trigger;
        private final TriggerResult triggerResult;

        public TriggerWithResult(Trigger trigger, TriggerResult triggerResult) {
            this.trigger = trigger;
            this.triggerResult = triggerResult;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public TriggerResult getTriggerResult() {
            return this.triggerResult;
        }

        public String toString() {
            return this.trigger + " :: " + this.triggerResult;
        }
    }

    private static final class TriggerKey {
        private final String component;
        private final String name;

        private TriggerKey(String component, String name) {
            this.component = component;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerKey that = (TriggerKey)o;
            return Objects.equals(this.component, that.component) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.component, this.name);
        }
    }
}

